/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.io;

import com.topcoder.io.serialization.basictype.impl.BasicTypeDataOutputImpl;
import com.topcoder.shared.netCommon.CSWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ObjectWriter {
    private final ByteBuffer regularByteBuffer;
    private final ByteBufferOutputStream bbos;
    private final CSWriter csWriter;
    private final int bufferIncrement;
    private final int maxBufferSize;
    ByteBuffer byteBuffer;

    public ObjectWriter(int n, int n2, int n3, CSWriter cSWriter) {
        this.bufferIncrement = n2;
        this.maxBufferSize = n3;
        this.csWriter = cSWriter;
        this.byteBuffer = this.regularByteBuffer = ObjectWriter.allocate(n);
        this.bbos = new ByteBufferOutputStream();
        cSWriter.setDataOutput(new BasicTypeDataOutputImpl(this.bbos));
    }

    private static ByteBuffer allocate(int n) {
        return ByteBuffer.allocate(n);
    }

    public int writeObject(OutputStream outputStream, Object object) throws IOException {
        this.writeObject(object);
        int n = this.byteBuffer.limit();
        outputStream.write(this.byteBuffer.array(), 0, n);
        outputStream.flush();
        this.check();
        return n;
    }

    private void writeObjectInternal(Object object) throws IOException {
        this.byteBuffer.clear();
        this.writeObjectAppend(object);
        this.byteBuffer.flip();
    }

    protected void writeObjectAppend(Object object) throws IOException {
        this.byteBuffer.putInt(0);
        int n = this.byteBuffer.position();
        this.csWriter.writeObject(object);
        int n2 = this.byteBuffer.position();
        this.byteBuffer.position(n - 4);
        int n3 = n2 - n;
        this.byteBuffer.putInt(n3);
        this.byteBuffer.position(n2);
    }

    public void check() {
        if (!this.byteBuffer.hasRemaining()) {
            this.byteBuffer = this.regularByteBuffer;
        }
    }

    public void writeObject(Object object) throws IOException {
        boolean bl = false;
        while (!bl) {
            try {
                this.writeObjectInternal(object);
                bl = true;
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.byteBuffer.clear();
                this.byteBuffer.flip();
                if (this.byteBuffer.capacity() + this.bufferIncrement > this.maxBufferSize) {
                    throw bufferOverflowException;
                }
                this.byteBuffer = ObjectWriter.allocate(this.byteBuffer.capacity() + this.bufferIncrement);
            }
        }
    }

    private final class ByteBufferOutputStream
    extends OutputStream {
        private ByteBufferOutputStream() {
        }

        public void write(int n) {
            ObjectWriter.this.byteBuffer.put((byte)n);
        }

        public void write(byte[] byArray, int n, int n2) {
            ObjectWriter.this.byteBuffer.put(byArray, n, n2);
        }
    }
}

