/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.io;

import com.topcoder.io.serialization.basictype.impl.BasicTypeDataInputImpl;
import com.topcoder.netCommon.io.buffer.ByteBufferUtil;
import com.topcoder.shared.netCommon.CSReader;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;

public class ObjectReader {
    private final int bufferSize;
    private final int bufferIncrement;
    private final int maxBufferSize;
    private final ByteBuffer regularByteBuffer;
    private final ByteBufferInputStream bbis;
    private final CSReader csReader;
    ByteBuffer byteBuffer;

    public ObjectReader(int n, int n2, int n3, CSReader cSReader) {
        this.bufferSize = n;
        this.bufferIncrement = n2;
        this.maxBufferSize = n3;
        this.csReader = cSReader;
        this.byteBuffer = this.regularByteBuffer = ObjectReader.allocate(n);
        this.bbis = new ByteBufferInputStream();
        cSReader.setDataInput(new BasicTypeDataInputImpl(this.bbis));
    }

    private static ByteBuffer allocate(int n) {
        return ByteBuffer.allocate(n);
    }

    Object readObject(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = 4;
        int n3 = n + 4;
        if (n <= 0 || n3 > this.maxBufferSize) {
            throw new StreamCorruptedException("totalSize: " + n3);
        }
        if (n3 > this.bufferSize) {
            int n4;
            for (n4 = this.bufferSize; n3 > n4; n4 += this.bufferIncrement) {
            }
            this.byteBuffer = ObjectReader.allocate(n4);
        }
        this.byteBuffer.clear();
        this.byteBuffer.putInt(n);
        dataInput.readFully(this.byteBuffer.array(), 4, n);
        this.byteBuffer.position(n3);
        Object object = this.readObject();
        this.byteBuffer = this.regularByteBuffer;
        return object;
    }

    public Object readObject() throws IOException {
        this.byteBuffer.flip();
        int n = this.byteBuffer.position();
        Object object = this.readStreamObject();
        if (object == null) {
            this.byteBuffer.position(n);
        } else {
            this.bbis.cleanUp();
        }
        ObjectReader.moveRemaining(this.byteBuffer);
        if (this.byteBuffer != this.regularByteBuffer && object != null && this.byteBuffer.capacity() >= this.bufferSize && this.byteBuffer.position() <= this.bufferSize) {
            ByteBufferUtil.copy(this.byteBuffer, this.regularByteBuffer);
            this.byteBuffer = this.regularByteBuffer;
        }
        return object;
    }

    static final void moveRemaining(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            byteBuffer.clear();
            return;
        }
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.position();
        int n2 = byteBuffer.remaining();
        System.arraycopy(byArray, n, byArray, 0, n2);
        byteBuffer.position(n2);
        byteBuffer.limit(byteBuffer.capacity());
    }

    protected Object readStreamObject() throws IOException {
        if (this.byteBuffer.remaining() < 4) {
            return null;
        }
        this.bbis.setLimit(4);
        int n = this.byteBuffer.getInt();
        if (!this.ensureRequiredDataAvailable(n)) {
            return null;
        }
        this.bbis.setLimit(n);
        Object object = this.readCustomObject();
        return object;
    }

    protected boolean ensureRequiredDataAvailable(int n) throws StreamCorruptedException {
        return this.ensureCapacityAndFilled(this.byteBuffer.position() + n);
    }

    protected boolean ensureCapacityAndFilled(int n) throws StreamCorruptedException {
        if (n <= 0 || n > this.maxBufferSize) {
            throw new StreamCorruptedException("bad size: " + n);
        }
        if (n > this.byteBuffer.capacity()) {
            double d = n - this.byteBuffer.capacity();
            int n2 = this.byteBuffer.capacity() + this.bufferIncrement * (int)Math.ceil(d / (double)this.bufferIncrement);
            ByteBuffer byteBuffer = ObjectReader.allocate(n2);
            ByteBufferUtil.copy(this.byteBuffer, byteBuffer);
            this.byteBuffer = byteBuffer;
            return false;
        }
        return this.byteBuffer.remaining() + this.byteBuffer.position() >= n;
    }

    protected Object readCustomObject() throws IOException {
        this.csReader.setMemoryUsageLimit(this.bbis.available());
        return this.csReader.readObject();
    }

    private final class ByteBufferInputStream
    extends InputStream {
        private int limit;
        private int pos;

        private ByteBufferInputStream() {
        }

        private void setLimit(int n) {
            this.limit = n;
            this.pos = 0;
        }

        public int available() {
            return Math.min(this.limit - this.pos, ObjectReader.this.byteBuffer.remaining());
        }

        private void cleanUp() {
            while (this.read() >= 0) {
            }
        }

        public int read() {
            if (!ObjectReader.this.byteBuffer.hasRemaining() || this.pos >= this.limit) {
                return -1;
            }
            ++this.pos;
            return ObjectReader.this.byteBuffer.get() & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) {
            if (ObjectReader.this.byteBuffer.remaining() == 0 || this.pos >= this.limit) {
                return -1;
            }
            n2 = Math.min(n2, this.available());
            this.pos += n2;
            ObjectReader.this.byteBuffer.get(byArray, n, n2);
            return n2;
        }
    }
}

