/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.response.data;

import com.topcoder.netCommon.contest.round.RoundCustomProperties;
import com.topcoder.netCommon.contestantMessages.response.data.PhaseData;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class RoundData
implements Serializable,
CustomSerializable,
Cloneable {
    int roundID;
    String contestName;
    String roundName;
    int roundType;
    int roundCategoryID;
    PhaseData phaseData;
    boolean enabled;
    private int practiceRoundDivision;
    private int practiceRoomID;
    private RoundCustomProperties customProperties;

    public RoundData() {
    }

    public RoundData(int n, String string, String string2, int n2, PhaseData phaseData, boolean bl, RoundCustomProperties roundCustomProperties) {
        this.roundID = n;
        this.contestName = string;
        this.roundName = string2;
        this.roundType = n2;
        this.phaseData = phaseData;
        this.enabled = bl;
        this.customProperties = roundCustomProperties;
    }

    public RoundData(int n, String string, String string2, int n2, int n3, PhaseData phaseData, RoundCustomProperties roundCustomProperties, int n4, int n5) {
        this(n, string, string2, n2, phaseData, true, roundCustomProperties);
        this.practiceRoundDivision = n4;
        this.practiceRoomID = n5;
        this.roundCategoryID = n3;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.getRoundID());
        cSWriter.writeString(this.getContestName());
        cSWriter.writeString(this.getRoundName());
        cSWriter.writeInt(this.getRoundType());
        cSWriter.writeInt(this.getRoundCategoryID());
        cSWriter.writeObject(this.getPhaseData());
        cSWriter.writeBoolean(this.enabled);
        cSWriter.writeInt(this.practiceRoundDivision);
        cSWriter.writeInt(this.practiceRoomID);
        cSWriter.writeObject(this.customProperties);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.roundID = cSReader.readInt();
        this.contestName = cSReader.readString();
        this.roundName = cSReader.readString();
        this.roundType = cSReader.readInt();
        this.roundCategoryID = cSReader.readInt();
        this.phaseData = (PhaseData)cSReader.readObject();
        this.enabled = cSReader.readBoolean();
        this.practiceRoundDivision = cSReader.readInt();
        this.practiceRoomID = cSReader.readInt();
        this.customProperties = (RoundCustomProperties)cSReader.readObject();
    }

    public int getRoundID() {
        return this.roundID;
    }

    public String getContestName() {
        return this.contestName;
    }

    public String getRoundName() {
        return this.roundName;
    }

    public int getRoundCategoryID() {
        return this.roundCategoryID;
    }

    public int getRoundType() {
        return this.roundType;
    }

    public PhaseData getPhaseData() {
        return this.phaseData;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public int getPracticeRoundDivision() {
        return this.practiceRoundDivision;
    }

    public int getPracticeRoomID() {
        return this.practiceRoomID;
    }

    public RoundCustomProperties getCustomProperties() {
        return this.customProperties;
    }

    public Object clone() {
        RoundData roundData = new RoundData(this.roundID, this.contestName, this.roundName, this.roundType, this.roundCategoryID, this.phaseData, this.customProperties, this.practiceRoundDivision, this.practiceRoomID);
        roundData.enabled = this.enabled;
        return roundData;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.netCommon.contestantMessages.response.data.RoundData) [");
        stringBuffer.append("roundID = ");
        stringBuffer.append(this.roundID);
        stringBuffer.append(", ");
        stringBuffer.append("contestName = ");
        if (this.contestName == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.contestName.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("roundName = ");
        if (this.roundName == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.roundName.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("roundType = ");
        stringBuffer.append(this.roundType);
        stringBuffer.append(", ");
        stringBuffer.append("roundCategoryID = ");
        stringBuffer.append(this.roundCategoryID);
        stringBuffer.append(", ");
        stringBuffer.append("phaseData = ");
        stringBuffer.append(this.phaseData);
        stringBuffer.append(", ");
        stringBuffer.append("enabled = ");
        stringBuffer.append(this.enabled);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

