/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.response.data;

import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public final class CoderHistoryData
implements Serializable,
CustomSerializable {
    private Date time;
    private UserListItem coder;
    private int componentValue;
    private int action;
    private double points;
    private String detail;

    public CoderHistoryData() {
    }

    public CoderHistoryData(Date date, UserListItem userListItem, int n, int n2, double d, String string) {
        this.time = date;
        this.coder = userListItem;
        this.componentValue = n;
        this.action = n2;
        this.points = d;
        this.detail = string;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeLong(this.time.getTime());
        cSWriter.writeObject(this.coder);
        cSWriter.writeInt(this.componentValue);
        cSWriter.writeInt(this.action);
        cSWriter.writeDouble(this.points);
        cSWriter.writeString(this.detail);
    }

    public void customReadObject(CSReader cSReader) throws IOException {
        this.time = new Date(cSReader.readLong());
        this.coder = (UserListItem)cSReader.readObject();
        this.componentValue = cSReader.readInt();
        this.action = cSReader.readInt();
        this.points = cSReader.readDouble();
        this.detail = cSReader.readString();
    }

    public Date getTime() {
        return this.time;
    }

    public UserListItem getCoder() {
        return this.coder;
    }

    public int getComponentValue() {
        return this.componentValue;
    }

    public int getAction() {
        return this.action;
    }

    public double getPoints() {
        return this.points;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getActionDescription() {
        switch (this.action) {
            case 0: {
                return "Submit";
            }
            case 1: {
                return "Challenge";
            }
            case 2: {
                return "Defend";
            }
            case 3: {
                return "Test";
            }
            case 4: {
                return "Full ";
            }
            case 5: {
                return "Full*";
            }
            case 6: {
                return "Example ";
            }
            case 7: {
                return "Example*";
            }
        }
        return "Unknown";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.netCommon.contestantMessages.response.data.CoderHistoryData) [");
        stringBuffer.append("time = ");
        stringBuffer.append(this.time);
        stringBuffer.append(", ");
        stringBuffer.append("coder = ");
        stringBuffer.append(this.coder);
        stringBuffer.append(", ");
        stringBuffer.append("action = ");
        stringBuffer.append(this.action);
        stringBuffer.append(", ");
        stringBuffer.append("points = ");
        stringBuffer.append(this.points);
        stringBuffer.append(", ");
        stringBuffer.append("detail = ");
        stringBuffer.append(this.detail);
        stringBuffer.append(", ");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

