/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.response;

import com.topcoder.netCommon.contestantMessages.response.BaseResponse;
import com.topcoder.netCommon.contestantMessages.response.data.ComponentLabel;
import com.topcoder.netCommon.contestantMessages.response.data.ProblemLabel;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import java.io.IOException;

public class RoundProblemsResponse
extends BaseResponse {
    private int divisionID = -1;
    private long roundID = -1L;
    private ProblemLabel[] problems;
    private ComponentLabel[] assignedComponents;
    private String errorMessage = null;

    public RoundProblemsResponse() {
    }

    public RoundProblemsResponse(long l, int n) {
        this.setRoundID(l);
        this.setDivisionID(n);
    }

    public int getDivisionID() {
        return this.divisionID;
    }

    public void setDivisionID(int n) {
        this.divisionID = n;
    }

    public long getRoundID() {
        return this.roundID;
    }

    public void setRoundID(long l) {
        this.roundID = l;
    }

    public ProblemLabel[] getProblems() {
        return this.problems;
    }

    public void setProblems(ProblemLabel[] problemLabelArray) {
        this.problems = problemLabelArray;
    }

    public ComponentLabel[] getAssignedComponents() {
        return this.assignedComponents;
    }

    public void setAssignedComponents(ComponentLabel[] componentLabelArray) {
        this.assignedComponents = componentLabelArray;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void customReadObject(CSReader cSReader) throws IOException {
        super.customReadObject(cSReader);
        this.roundID = cSReader.readLong();
        this.divisionID = cSReader.readInt();
        this.problems = (ProblemLabel[])cSReader.readObjectArray(ProblemLabel.class);
        this.assignedComponents = (ComponentLabel[])cSReader.readObjectArray(ComponentLabel.class);
        this.errorMessage = cSReader.readString();
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        super.customWriteObject(cSWriter);
        cSWriter.writeLong(this.roundID);
        cSWriter.writeInt(this.divisionID);
        cSWriter.writeObjectArray(this.problems);
        cSWriter.writeObjectArray(this.assignedComponents);
        cSWriter.writeString(this.errorMessage);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(") [");
        stringBuffer.append("roundID = ");
        stringBuffer.append(this.roundID);
        stringBuffer.append(", divisionID = ");
        stringBuffer.append(this.divisionID);
        stringBuffer.append("problems = ");
        if (this.problems == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("{");
            for (n = 0; n < this.problems.length; ++n) {
                stringBuffer.append(this.problems[n].toString() + ",");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(", ");
        if (this.assignedComponents == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("{");
            for (n = 0; n < this.assignedComponents.length; ++n) {
                stringBuffer.append(this.assignedComponents[n].toString() + ",");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(", ");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

