/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.response;

import com.topcoder.netCommon.contestantMessages.response.WatchableResponse;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;

public class CreateUserListResponse
extends WatchableResponse {
    private int type;
    private UserListItem[] items = null;

    public CreateUserListResponse() {
        super(-1, -1);
    }

    public CreateUserListResponse(int n, UserListItem[] userListItemArray, int n2, int n3) {
        super(n2, n3);
        this.type = n;
        this.items = userListItemArray;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        super.customWriteObject(cSWriter);
        cSWriter.writeInt(this.type);
        cSWriter.writeObjectArray(this.items);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        super.customReadObject(cSReader);
        this.type = cSReader.readInt();
        this.items = (UserListItem[])cSReader.readObjectArray(UserListItem.class);
    }

    public int getType() {
        return this.type;
    }

    public UserListItem[] getUserListItems() {
        return this.items;
    }

    public ArrayList getNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            arrayList.add(this.items[i].getUserName());
        }
        return arrayList;
    }

    public ArrayList getRatings() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            arrayList.add(new Integer(this.items[i].getUserRating()));
        }
        return arrayList;
    }

    public ArrayList getTeams() {
        ArrayList<String> arrayList = new ArrayList<String>(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            arrayList.add(this.items[i].getTeamName());
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.netCommon.contestantMessages.response.CreateUserListResponse) [");
        stringBuffer.append("type = ");
        stringBuffer.append(this.type);
        stringBuffer.append(", ");
        stringBuffer.append("items = ");
        if (this.items == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("{");
            for (int i = 0; i < this.items.length; ++i) {
                stringBuffer.append(this.items[i].toString() + ",");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(", ");
        stringBuffer.append(super.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

