/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.response;

import com.topcoder.netCommon.contestantMessages.response.BaseResponse;
import com.topcoder.netCommon.contestantMessages.response.data.ComponentLabel;
import com.topcoder.netCommon.contestantMessages.response.data.ProblemLabel;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import java.io.IOException;
import java.io.ObjectStreamException;

public class CreateProblemsResponse
extends BaseResponse {
    private int divisionID;
    private long roundID;
    private ProblemLabel[] problems;
    private ComponentLabel[] assignedComponents;

    public CreateProblemsResponse() {
    }

    public CreateProblemsResponse(ProblemLabel[] problemLabelArray, ComponentLabel[] componentLabelArray, long l, int n) {
        this.roundID = l;
        this.assignedComponents = componentLabelArray;
        this.problems = problemLabelArray;
        this.divisionID = n;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        super.customWriteObject(cSWriter);
        cSWriter.writeObjectArray(this.problems);
        cSWriter.writeObjectArray(this.assignedComponents);
        cSWriter.writeLong(this.roundID);
        cSWriter.writeInt(this.divisionID);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        super.customReadObject(cSReader);
        this.problems = (ProblemLabel[])cSReader.readObjectArray(ProblemLabel.class);
        this.assignedComponents = (ComponentLabel[])cSReader.readObjectArray(ComponentLabel.class);
        this.roundID = cSReader.readLong();
        this.divisionID = cSReader.readInt();
    }

    public ComponentLabel[] getAssignedComponents() {
        return this.assignedComponents;
    }

    public ProblemLabel[] getProblems() {
        return this.problems;
    }

    public long getRoundID() {
        return this.roundID;
    }

    public int getDivisionID() {
        return this.divisionID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.netCommon.contestantMessages.response.CreateProblemsResponse) [");
        stringBuffer.append("problems = ");
        if (this.problems == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.problems.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("roundID = " + this.roundID);
        stringBuffer.append(", ");
        stringBuffer.append("divisionID = " + this.divisionID);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

