/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.response;

import com.topcoder.netCommon.contestantMessages.response.BaseResponse;
import com.topcoder.netCommon.contestantMessages.response.data.ComponentLabel;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Arrays;

public class AssignComponentsResponse
extends BaseResponse {
    private int divisionID;
    private long roundID;
    private ComponentLabel[] assignedComponents;

    public AssignComponentsResponse() {
    }

    public AssignComponentsResponse(ComponentLabel[] componentLabelArray, long l, int n) {
        this.roundID = l;
        this.assignedComponents = componentLabelArray;
        this.divisionID = n;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        super.customWriteObject(cSWriter);
        cSWriter.writeObjectArray(this.assignedComponents);
        cSWriter.writeLong(this.roundID);
        cSWriter.writeInt(this.divisionID);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        super.customReadObject(cSReader);
        this.assignedComponents = (ComponentLabel[])cSReader.readObjectArray(ComponentLabel.class);
        this.roundID = cSReader.readLong();
        this.divisionID = cSReader.readInt();
    }

    public ComponentLabel[] getAssignedComponents() {
        return this.assignedComponents;
    }

    public long getRoundID() {
        return this.roundID;
    }

    public int getDivisionID() {
        return this.divisionID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.netCommon.contestantMessages.response.AssignComponentsResponse) [");
        stringBuffer.append("components = ");
        if (this.assignedComponents == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(Arrays.asList(this.assignedComponents).toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("roundID = " + this.roundID);
        stringBuffer.append(", ");
        stringBuffer.append("divisionID = " + this.divisionID);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

