/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;

public final class UserInfo
implements Serializable,
CustomSerializable,
Cloneable {
    private String team;
    private boolean captain;
    private int rating;
    private int numRatedEvents;
    private boolean admin;
    private long lastLogin;
    private boolean guest;
    private String handle = "";
    private HashMap preferences = new HashMap();
    private boolean isWeakestLinkParticipant;
    private String avatar;

    public UserInfo() {
    }

    public UserInfo(String string, int n) {
        this.handle = string;
        this.rating = n;
    }

    public UserInfo(String string, boolean bl, boolean bl2, boolean bl3, long l, int n, int n2, boolean bl4, String string2, String string3) {
        this.handle = string;
        this.guest = bl;
        this.admin = bl2;
        this.lastLogin = l;
        this.numRatedEvents = n;
        this.rating = n2;
        this.isWeakestLinkParticipant = bl4;
        this.captain = bl3;
        this.team = string2;
        this.avatar = string3;
    }

    public void clear() {
        this.handle = "";
        this.team = "";
        this.guest = false;
        this.admin = false;
        this.lastLogin = 0L;
        this.numRatedEvents = 0;
        this.rating = 0;
        this.avatar = "";
    }

    public boolean equals(Object object) {
        if (object instanceof UserInfo) {
            UserInfo userInfo = (UserInfo)object;
            return userInfo.handle.equals(this.handle) && userInfo.admin == this.admin && userInfo.guest == this.guest && userInfo.rating == this.rating && userInfo.numRatedEvents == this.numRatedEvents && userInfo.lastLogin == this.lastLogin;
        }
        return false;
    }

    public String toString() {
        return "handle=" + this.handle + "," + "admin=" + this.admin + "," + "guest=" + this.guest + "," + "rating=" + this.rating + "," + "numRatedEvents=" + this.numRatedEvents + "," + "lastLogin=" + this.lastLogin + ", pathImage=" + this.avatar;
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.captain = cSReader.readBoolean();
        this.rating = cSReader.readInt();
        this.numRatedEvents = cSReader.readInt();
        this.admin = cSReader.readBoolean();
        this.lastLogin = cSReader.readLong();
        this.guest = cSReader.readBoolean();
        this.handle = cSReader.readString();
        this.team = cSReader.readString();
        this.preferences = cSReader.readHashMap();
        this.isWeakestLinkParticipant = cSReader.readBoolean();
        this.avatar = cSReader.readString();
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeBoolean(this.captain);
        cSWriter.writeInt(this.rating);
        cSWriter.writeInt(this.numRatedEvents);
        cSWriter.writeBoolean(this.admin);
        cSWriter.writeLong(this.lastLogin);
        cSWriter.writeBoolean(this.guest);
        cSWriter.writeString(this.handle);
        cSWriter.writeString(this.team);
        cSWriter.writeHashMap(this.preferences);
        cSWriter.writeBoolean(this.isWeakestLinkParticipant);
        cSWriter.writeString(this.avatar);
    }

    public boolean isGuest() {
        return this.guest;
    }

    public boolean isCaptain() {
        return this.captain;
    }

    public void setCaptain(boolean bl) {
        this.captain = bl;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String string) {
        this.handle = string;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isFirstTimeUser() {
        return this.lastLogin == 0L;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(long l) {
        this.lastLogin = l;
    }

    public int getNumRatedEvents() {
        return this.numRatedEvents;
    }

    public int getRating() {
        return this.rating;
    }

    public HashMap getPreferences() {
        return this.preferences;
    }

    public void setPreferences(HashMap hashMap) {
        this.preferences = hashMap;
    }

    public boolean isWeakestLinkParticipant() {
        return this.isWeakestLinkParticipant;
    }

    public String getTeam() {
        return this.team;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String string) {
        this.avatar = string;
    }
}

