/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contest;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.ResolvedCustomSerializable;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ResultDisplayType
implements Serializable,
ResolvedCustomSerializable {
    private static final Map all = new HashMap(5);
    public static final ResultDisplayType POINTS = new ResultDisplayType(1, "Points");
    public static final ResultDisplayType PASSED_TESTS = new ResultDisplayType(2, "Passed Tests");
    public static final ResultDisplayType STATUS = new ResultDisplayType(3, "Status");
    private int id;
    private transient String description;

    public ResultDisplayType() {
    }

    private ResultDisplayType(int n, String string) {
        this.id = n;
        this.description = string;
        all.put(new Integer(n), this);
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        return object != null && (object == this || this.getClass().equals(object.getClass()) && this.id == ((ResultDisplayType)object).id);
    }

    public Object readResolve() {
        return ResultDisplayType.get(this.id);
    }

    public static ResultDisplayType get(int n) {
        ResultDisplayType resultDisplayType = (ResultDisplayType)all.get(new Integer(n));
        if (resultDisplayType == null) {
            throw new IllegalArgumentException("Invalid id " + n + " for type " + ResultDisplayType.class.getName());
        }
        return resultDisplayType;
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.id = cSReader.readInt();
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.id);
    }
}

