/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contest;

import com.topcoder.netCommon.contest.RoundTypes;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public final class ContestConstants
implements RoundTypes {
    public static final int[] SEGMENTS = new int[]{1, 2, 3, 4, 5, 6};
    public static final String[] SEGMENT_NAMES = new String[]{"Registration", "Coding", "Intermission", "Challenge", "System Testing", "Moderated Chat"};
    public static final int[] PHASES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final String[] PHASE_NAMES = new String[]{"Inactive", "Starts in", "Registration", "Almost contest", "Coding", "Intermission", "Challenge", "Pending systests", "System testing", "Contest complete", "Voting", "Tie breaking", "Moderated chatting"};
    public static final int[] SPECTATOR_PHASES = new int[]{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 77700, 77701, 77702, 77703, 77704};
    public static final String[] SPECTATOR_PHASE_NAMES = new String[]{"None", "Pre-Contest", "Pre-Contest", "Coding", "Intermission", "Challenge", "Pending Tests", "System Testing", "Post-Contest", "Voting", "Tie-Break", "Contest Info", "Announcements", "Appeals", "Results", "Complete"};
    public static boolean ACCEPT_REPEAT_CHALLENGES = true;
    public static final boolean ACCEPT_MULTIPLE_SUBMISSIONS = Boolean.valueOf(System.getProperty("contestconstants.ACCEPT_MULTIPLE_SUBMISSIONS", "true"));
    public static final String[] LANG_NAMES = new String[]{"", "Java", "", "C++", "C#", "Visual Basic", "Python"};

    public static final boolean isPracticeRoomType(int n) {
        return n == 4 || n == 10 || n == 12 || n == 13;
    }

    public static String makePretty(Object object) {
        if (object == null) {
            return "<null>";
        }
        if (object.getClass().isArray()) {
            StringBuffer stringBuffer = new StringBuffer(250);
            Class<?> clazz = object.getClass().getComponentType();
            stringBuffer.append("{");
            if (Array.getLength(object) > 0) {
                try {
                    if (Integer.TYPE.equals(clazz)) {
                        stringBuffer.append(((int[])object)[0]);
                        int n = 1;
                        while (true) {
                            stringBuffer.append(", " + ((int[])object)[n]);
                            ++n;
                        }
                    }
                    if (Double.TYPE.equals(clazz)) {
                        stringBuffer.append(((double[])object)[0]);
                        int n = 1;
                        while (true) {
                            stringBuffer.append(", " + ((double[])object)[n]);
                            ++n;
                        }
                    }
                    if (Float.TYPE.equals(clazz)) {
                        stringBuffer.append(((float[])object)[0]);
                        int n = 1;
                        while (true) {
                            stringBuffer.append(", " + ((float[])object)[n]);
                            ++n;
                        }
                    }
                    if (Boolean.TYPE.equals(clazz)) {
                        stringBuffer.append(((boolean[])object)[0]);
                        int n = 1;
                        while (true) {
                            stringBuffer.append(", " + ((boolean[])object)[n]);
                            ++n;
                        }
                    }
                    if (Long.TYPE.equals(clazz)) {
                        stringBuffer.append(((long[])object)[0]);
                        int n = 1;
                        while (true) {
                            stringBuffer.append(", " + ((long[])object)[n]);
                            ++n;
                        }
                    }
                    if (Character.TYPE.equals(clazz)) {
                        stringBuffer.append(((char[])object)[0]);
                        int n = 1;
                        while (true) {
                            stringBuffer.append(", " + ((char[])object)[n]);
                            ++n;
                        }
                    }
                    if (Byte.TYPE.equals(clazz)) {
                        stringBuffer.append(((byte[])object)[0]);
                        int n = 1;
                        while (true) {
                            stringBuffer.append(", " + ((byte[])object)[n]);
                            ++n;
                        }
                    }
                    if (Short.TYPE.equals(clazz)) {
                        stringBuffer.append(((short[])object)[0]);
                        int n = 1;
                        while (true) {
                            stringBuffer.append(", " + ((short[])object)[n]);
                            ++n;
                        }
                    }
                    int n = Array.getLength(object);
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(ContestConstants.makePretty(Array.get(object, i)));
                        if (i == n - 1) continue;
                        stringBuffer.append(", ");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        if (object instanceof Collection) {
            StringBuffer stringBuffer = new StringBuffer(250);
            Collection collection = (Collection)object;
            stringBuffer.append("[");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(ContestConstants.makePretty(iterator.next()));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        return object.toString();
    }
}

