/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.io.serialization.basictype.impl;

import com.topcoder.io.serialization.basictype.BasicTypeIOException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

final class Helper {
    static void validateNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string + " should not be null.");
        }
    }

    static String validateEncoding(String string) {
        try {
            if (string == null) {
                return "UTF-8";
            }
            if (string.trim().length() == 0) {
                throw new IllegalArgumentException("Character encoding should not be empty.");
            }
            if (!Charset.isSupported(string)) {
                throw new IllegalArgumentException("Given character encoding is not supported: " + string);
            }
            return string;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new IllegalArgumentException("Given character encoding is illegal: " + string);
        }
    }

    static BasicTypeIOException wrapIOException(String string, IOException iOException) {
        return iOException instanceof BasicTypeIOException ? (BasicTypeIOException)iOException : new BasicTypeIOException(string, iOException);
    }
}

