/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.io.serialization.basictype.impl;

import com.topcoder.io.serialization.basictype.BasicTypeDataOutput;
import com.topcoder.io.serialization.basictype.BasicTypeIOException;
import com.topcoder.io.serialization.basictype.impl.Helper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BasicTypeDataOutputImpl
implements BasicTypeDataOutput {
    private final DataOutputStream stream;

    public BasicTypeDataOutputImpl(OutputStream outputStream) {
        Helper.validateNull(outputStream, "The output stream");
        this.stream = new DataOutputStream(outputStream);
    }

    public void writeBoolean(boolean bl) throws BasicTypeIOException {
        try {
            this.stream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing boolean", iOException);
        }
    }

    public void writeChar(char c) throws BasicTypeIOException {
        try {
            this.stream.writeChar(c);
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing char", iOException);
        }
    }

    public void writeByte(byte by) throws BasicTypeIOException {
        try {
            this.stream.writeByte(by);
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing byte", iOException);
        }
    }

    public void writeInt(int n) throws BasicTypeIOException {
        try {
            this.stream.writeInt(n);
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing int", iOException);
        }
    }

    public void writeLong(long l) throws BasicTypeIOException {
        try {
            this.stream.writeLong(l);
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing long", iOException);
        }
    }

    public void writeDouble(double d) throws BasicTypeIOException {
        try {
            this.stream.writeDouble(d);
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing double", iOException);
        }
    }

    public void writeString(String string, String string2) throws BasicTypeIOException {
        Helper.validateNull(string, "String to be written");
        string2 = Helper.validateEncoding(string2);
        try {
            this.doWriteString(string, string2);
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing String", iOException);
        }
    }

    private void doWriteString(String string, String string2) throws IOException {
        if (string.length() == 0) {
            this.stream.writeInt(0);
        } else {
            byte[] byArray = string.getBytes(string2);
            this.stream.writeInt(byArray.length);
            this.stream.write(byArray);
        }
    }

    public void writeCharArray(char[] cArray) throws BasicTypeIOException {
        Helper.validateNull(cArray, "Char array to be written");
        int n = cArray.length;
        try {
            this.stream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.stream.writeChar(cArray[i]);
            }
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing char array", iOException);
        }
    }

    public void writeByteArray(byte[] byArray) throws BasicTypeIOException {
        Helper.validateNull(byArray, "Byte array to be written");
        int n = byArray.length;
        try {
            this.stream.writeInt(n);
            if (n != 0) {
                this.stream.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing byte array", iOException);
        }
    }

    public void writeIntArray(int[] nArray) throws BasicTypeIOException {
        Helper.validateNull(nArray, "Int array to be written");
        int n = nArray.length;
        try {
            this.stream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.stream.writeInt(nArray[i]);
            }
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing int array", iOException);
        }
    }

    public void writeLongArray(long[] lArray) throws BasicTypeIOException {
        Helper.validateNull(lArray, "Long array to be written");
        int n = lArray.length;
        try {
            this.stream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.stream.writeLong(lArray[i]);
            }
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing long array", iOException);
        }
    }

    public void writeDoubleArray(double[] dArray) throws BasicTypeIOException {
        Helper.validateNull(dArray, "Double array to be written");
        int n = dArray.length;
        try {
            this.stream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.stream.writeDouble(dArray[i]);
            }
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing double array", iOException);
        }
    }

    public void writeStringArray(String[] stringArray, String string) throws BasicTypeIOException {
        int n;
        Helper.validateNull(stringArray, "String array to be written");
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            Helper.validateNull(stringArray[n], "String to be written");
        }
        string = Helper.validateEncoding(string);
        try {
            this.stream.writeInt(n2);
            for (n = 0; n < n2; ++n) {
                this.doWriteString(stringArray[n], string);
            }
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while writing String array", iOException);
        }
    }
}

