/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.io.serialization.basictype.impl;

import com.topcoder.io.serialization.basictype.BasicTypeDataInput;
import com.topcoder.io.serialization.basictype.BasicTypeIOException;
import com.topcoder.io.serialization.basictype.MemoryUsageLimitExceededException;
import com.topcoder.io.serialization.basictype.impl.Helper;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public class BasicTypeDataInputImpl
implements BasicTypeDataInput {
    private final DataInputStream stream;
    private long memoryUsage = 0L;
    private long memoryUsageLimit;

    public BasicTypeDataInputImpl(InputStream inputStream) {
        this(inputStream, Long.MAX_VALUE);
    }

    public BasicTypeDataInputImpl(InputStream inputStream, long l) {
        Helper.validateNull(inputStream, "The input stream");
        BasicTypeDataInputImpl.validateLimit(l);
        this.memoryUsageLimit = l;
        this.stream = new DataInputStream(inputStream);
    }

    private static void validateLimit(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Memory usage limit must be positive(>0), but is: " + l);
        }
    }

    private long checkMemoryUsageLimitExceeded(long l) throws MemoryUsageLimitExceededException {
        long l2 = this.memoryUsageLimit - this.memoryUsage;
        if (l > l2) {
            throw new MemoryUsageLimitExceededException(MessageFormat.format("Memory usage limit exceeded: BytesToRead:{0} > AvailableMemory:{1}.", l + "", l2 + ""));
        }
        return this.memoryUsage + l;
    }

    public boolean readBoolean() throws BasicTypeIOException {
        long l = this.checkMemoryUsageLimitExceeded(1L);
        try {
            boolean bl = this.stream.readBoolean();
            this.memoryUsage = l;
            return bl;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading boolean", iOException);
        }
    }

    public char readChar() throws BasicTypeIOException {
        long l = this.checkMemoryUsageLimitExceeded(2L);
        try {
            char c = this.stream.readChar();
            this.memoryUsage = l;
            return c;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading char", iOException);
        }
    }

    public byte readByte() throws BasicTypeIOException {
        long l = this.checkMemoryUsageLimitExceeded(1L);
        try {
            byte by = this.stream.readByte();
            this.memoryUsage = l;
            return by;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading byte", iOException);
        }
    }

    public int readInt() throws BasicTypeIOException {
        long l = this.checkMemoryUsageLimitExceeded(4L);
        try {
            int n = this.stream.readInt();
            this.memoryUsage = l;
            return n;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading int", iOException);
        }
    }

    private int doReadPositiveIntWithCountMemory(String string) throws IOException {
        long l = this.checkMemoryUsageLimitExceeded(4L);
        int n = this.stream.readInt();
        this.memoryUsage = l;
        if (n < 0) {
            throw new BasicTypeIOException(string + " is negative: " + n);
        }
        return n;
    }

    public long readLong() throws BasicTypeIOException {
        long l = this.checkMemoryUsageLimitExceeded(8L);
        try {
            long l2 = this.stream.readLong();
            this.memoryUsage = l;
            return l2;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading long", iOException);
        }
    }

    public double readDouble() throws BasicTypeIOException {
        long l = this.checkMemoryUsageLimitExceeded(8L);
        try {
            double d = this.stream.readDouble();
            this.memoryUsage = l;
            return d;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading double", iOException);
        }
    }

    public String readString(String string) throws BasicTypeIOException {
        string = Helper.validateEncoding(string);
        try {
            return this.doReadString(string);
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading String", iOException);
        }
    }

    public String readString() throws BasicTypeIOException {
        return this.readString(null);
    }

    private String doReadString(String string) throws IOException {
        byte[] byArray = this.doReadByteArray();
        return byArray.length == 0 ? "" : new String(byArray, string);
    }

    private byte[] doReadByteArray() throws IOException {
        int n = this.doReadPositiveIntWithCountMemory("Length of byte array");
        if (n == 0) {
            return new byte[0];
        }
        long l = this.checkMemoryUsageLimitExceeded(n);
        byte[] byArray = new byte[n];
        this.stream.readFully(byArray);
        this.memoryUsage = l;
        return byArray;
    }

    public byte[] readByteArray() throws BasicTypeIOException {
        try {
            return this.doReadByteArray();
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading byte array", iOException);
        }
    }

    public char[] readCharArray() throws BasicTypeIOException {
        try {
            int n = this.doReadPositiveIntWithCountMemory("Length of char array");
            if (n == 0) {
                return new char[0];
            }
            long l = this.checkMemoryUsageLimitExceeded((long)n << 1);
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.stream.readChar();
            }
            this.memoryUsage = l;
            return cArray;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading char array", iOException);
        }
    }

    public int[] readIntArray() throws BasicTypeIOException {
        try {
            int n = this.doReadPositiveIntWithCountMemory("Length of int array");
            if (n == 0) {
                return new int[0];
            }
            long l = this.checkMemoryUsageLimitExceeded((long)n << 2);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.stream.readInt();
            }
            this.memoryUsage = l;
            return nArray;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading int array", iOException);
        }
    }

    public long[] readLongArray() throws BasicTypeIOException {
        try {
            int n = this.doReadPositiveIntWithCountMemory("Length of long array");
            if (n == 0) {
                return new long[0];
            }
            long l = this.checkMemoryUsageLimitExceeded((long)n << 3);
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = this.stream.readLong();
            }
            this.memoryUsage = l;
            return lArray;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading long array", iOException);
        }
    }

    public double[] readDoubleArray() throws BasicTypeIOException {
        try {
            int n = this.doReadPositiveIntWithCountMemory("Length of double array");
            if (n == 0) {
                return new double[0];
            }
            long l = this.checkMemoryUsageLimitExceeded((long)n << 3);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.stream.readDouble();
            }
            this.memoryUsage = l;
            return dArray;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading double array", iOException);
        }
    }

    public String[] readStringArray(String string) throws BasicTypeIOException {
        string = Helper.validateEncoding(string);
        try {
            int n = this.doReadPositiveIntWithCountMemory("Length of String array");
            if (n == 0) {
                return new String[0];
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.doReadString(string);
            }
            return stringArray;
        }
        catch (IOException iOException) {
            throw Helper.wrapIOException("Error occurs while reading String array", iOException);
        }
    }

    public String[] readStringArray() throws BasicTypeIOException {
        return this.readStringArray(null);
    }

    public void setMemoryUsageLimit(long l) throws MemoryUsageLimitExceededException {
        BasicTypeDataInputImpl.validateLimit(l);
        if (this.memoryUsage > l) {
            throw new MemoryUsageLimitExceededException(MessageFormat.format("Memory usage limit was exceeded: {0} > {1}.", this.memoryUsage + "", this.memoryUsageLimit + ""));
        }
        this.memoryUsageLimit = l;
    }

    public void resetMemoryUsageCounter() {
        this.memoryUsage = 0L;
    }
}

