/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.ui.impl.component;

import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIComponentException;
import com.topcoder.client.ui.UIEventListener;
import com.topcoder.client.ui.event.UIComponentListener;
import com.topcoder.client.ui.event.UIFocusListener;
import com.topcoder.client.ui.event.UIHierarchyBoundsListener;
import com.topcoder.client.ui.event.UIHierarchyListener;
import com.topcoder.client.ui.event.UIInputMethodListener;
import com.topcoder.client.ui.event.UIKeyListener;
import com.topcoder.client.ui.event.UIMouseListener;
import com.topcoder.client.ui.event.UIMouseMotionListener;
import com.topcoder.client.ui.event.UIMouseWheelListener;
import com.topcoder.client.ui.event.UIPropertyChangeListener;
import com.topcoder.client.ui.impl.component.UIAbstractComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Point;

public abstract class UIAWTComponent
extends UIAbstractComponent {
    private Component component;

    protected void initialize() throws UIComponentException {
        super.initialize();
        this.component = (Component)this.getEventSource();
    }

    protected void destroyImpl() {
        this.component.removeNotify();
        super.destroyImpl();
    }

    protected void addChildImpl(UIComponent uIComponent, GridBagConstraints gridBagConstraints) throws UIComponentException {
        throw new UIComponentException("AWT Component is not a container.");
    }

    protected void setPropertyImpl(String string, Object object) throws UIComponentException {
        if ("enabled".equalsIgnoreCase(string)) {
            this.component.setEnabled((Boolean)object);
        } else if ("visible".equalsIgnoreCase(string)) {
            this.component.setVisible((Boolean)object);
        } else if ("background".equalsIgnoreCase(string)) {
            this.component.setBackground((Color)object);
        } else if ("foreground".equalsIgnoreCase(string)) {
            this.component.setForeground((Color)object);
        } else if ("font".equalsIgnoreCase(string)) {
            this.component.setFont((Font)object);
        } else if ("focusable".equalsIgnoreCase(string)) {
            this.component.setFocusable((Boolean)object);
        } else if ("location".equalsIgnoreCase(string)) {
            this.component.setLocation((Point)object);
        } else if ("size".equalsIgnoreCase(string)) {
            this.component.setSize((Dimension)object);
        } else if ("cursor".equalsIgnoreCase(string)) {
            this.component.setCursor((Cursor)object);
        } else if ("name".equalsIgnoreCase(string)) {
            this.component.setName((String)object);
        } else {
            super.setPropertyImpl(string, object);
        }
    }

    protected Object getPropertyImpl(String string) throws UIComponentException {
        if ("enabled".equalsIgnoreCase(string)) {
            return this.component.isEnabled();
        }
        if ("visible".equalsIgnoreCase(string)) {
            return this.component.isVisible();
        }
        if ("alignmentx".equalsIgnoreCase(string)) {
            return new Float(this.component.getAlignmentX());
        }
        if ("alignmenty".equalsIgnoreCase(string)) {
            return new Float(this.component.getAlignmentY());
        }
        if ("background".equalsIgnoreCase(string)) {
            return this.component.getBackground();
        }
        if ("foreground".equalsIgnoreCase(string)) {
            return this.component.getForeground();
        }
        if ("font".equalsIgnoreCase(string)) {
            return this.component.getFont();
        }
        if ("focusable".equalsIgnoreCase(string)) {
            return this.component.isFocusable();
        }
        if ("location".equalsIgnoreCase(string)) {
            return this.component.getLocation();
        }
        if ("locationonscreen".equalsIgnoreCase(string)) {
            return this.component.getLocationOnScreen();
        }
        if ("name".equalsIgnoreCase(string)) {
            return this.component.getName();
        }
        if ("parent".equalsIgnoreCase(string)) {
            return this.component.getParent();
        }
        if ("focusowner".equalsIgnoreCase(string)) {
            return this.component.isFocusOwner();
        }
        if ("graphics".equalsIgnoreCase(string)) {
            return this.component.getGraphics();
        }
        if ("showing".equalsIgnoreCase(string)) {
            return this.component.isShowing();
        }
        if ("maximumsize".equalsIgnoreCase(string)) {
            return this.component.getMaximumSize();
        }
        if ("minimumsize".equalsIgnoreCase(string)) {
            return this.component.getMinimumSize();
        }
        if ("preferredsize".equalsIgnoreCase(string)) {
            return this.component.getPreferredSize();
        }
        if ("size".equalsIgnoreCase(string)) {
            return this.component.getSize();
        }
        if ("cursor".equalsIgnoreCase(string)) {
            return this.component.getCursor();
        }
        if ("x".equalsIgnoreCase(string)) {
            return new Integer(this.component.getX());
        }
        if ("y".equalsIgnoreCase(string)) {
            return new Integer(this.component.getY());
        }
        if ("width".equalsIgnoreCase(string)) {
            return new Integer(this.component.getWidth());
        }
        if ("height".equalsIgnoreCase(string)) {
            return new Integer(this.component.getHeight());
        }
        return super.getPropertyImpl(string);
    }

    protected void addEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        if ("propertychange".equalsIgnoreCase(string)) {
            this.component.addPropertyChangeListener((UIPropertyChangeListener)uIEventListener);
        } else if ("component".equalsIgnoreCase(string)) {
            this.component.addComponentListener((UIComponentListener)uIEventListener);
        } else if ("focus".equalsIgnoreCase(string)) {
            this.component.addFocusListener((UIFocusListener)uIEventListener);
        } else if ("hierarchybounds".equalsIgnoreCase(string)) {
            this.component.addHierarchyBoundsListener((UIHierarchyBoundsListener)uIEventListener);
        } else if ("hierarchy".equalsIgnoreCase(string)) {
            this.component.addHierarchyListener((UIHierarchyListener)uIEventListener);
        } else if ("inputmethod".equalsIgnoreCase(string)) {
            this.component.addInputMethodListener((UIInputMethodListener)uIEventListener);
        } else if ("key".equalsIgnoreCase(string)) {
            this.component.addKeyListener((UIKeyListener)uIEventListener);
        } else if ("mouse".equalsIgnoreCase(string)) {
            this.component.addMouseListener((UIMouseListener)uIEventListener);
        } else if ("mousemotion".equalsIgnoreCase(string)) {
            this.component.addMouseMotionListener((UIMouseMotionListener)uIEventListener);
        } else if ("mousewheel".equalsIgnoreCase(string)) {
            this.component.addMouseWheelListener((UIMouseWheelListener)uIEventListener);
        } else {
            super.addEventListenerImpl(string, uIEventListener);
        }
    }

    protected void removeEventListenerImpl(String string, UIEventListener uIEventListener) throws UIComponentException {
        if ("propertychange".equalsIgnoreCase(string)) {
            this.component.removePropertyChangeListener((UIPropertyChangeListener)uIEventListener);
        } else if ("component".equalsIgnoreCase(string)) {
            this.component.removeComponentListener((UIComponentListener)uIEventListener);
        } else if ("focus".equalsIgnoreCase(string)) {
            this.component.removeFocusListener((UIFocusListener)uIEventListener);
        } else if ("hierarchybounds".equalsIgnoreCase(string)) {
            this.component.removeHierarchyBoundsListener((UIHierarchyBoundsListener)uIEventListener);
        } else if ("hierarchy".equalsIgnoreCase(string)) {
            this.component.removeHierarchyListener((UIHierarchyListener)uIEventListener);
        } else if ("inputmethod".equalsIgnoreCase(string)) {
            this.component.removeInputMethodListener((UIInputMethodListener)uIEventListener);
        } else if ("key".equalsIgnoreCase(string)) {
            this.component.removeKeyListener((UIKeyListener)uIEventListener);
        } else if ("mouse".equalsIgnoreCase(string)) {
            this.component.removeMouseListener((UIMouseListener)uIEventListener);
        } else if ("mousemotion".equalsIgnoreCase(string)) {
            this.component.removeMouseMotionListener((UIMouseMotionListener)uIEventListener);
        } else if ("mousewheel".equalsIgnoreCase(string)) {
            this.component.removeMouseWheelListener((UIMouseWheelListener)uIEventListener);
        } else {
            super.removeEventListenerImpl(string, uIEventListener);
        }
    }

    protected Object performActionImpl(String string, Object[] objectArray) throws UIComponentException {
        if ("repaint".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.repaint();
            return null;
        }
        if ("requestfocus".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.requestFocus();
            return null;
        }
        if ("transferfocus".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.transferFocus();
            return null;
        }
        if ("transferfocusbackward".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.transferFocusBackward();
            return null;
        }
        if ("transferfocusupcycle".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.transferFocusUpCycle();
            return null;
        }
        if ("invalidate".equalsIgnoreCase(string)) {
            this.assertNull(string, objectArray);
            this.component.invalidate();
            return null;
        }
        if ("getfontmetrics".equalsIgnoreCase(string)) {
            this.assertArgs(string, objectArray, new Class[]{Font.class});
            return this.component.getFontMetrics((Font)objectArray[0]);
        }
        return super.performActionImpl(string, objectArray);
    }
}

