/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.testerApplet;

import com.topcoder.client.connectiontype.ConnectionType;
import com.topcoder.client.testerApplet.Tester;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

public abstract class TestProcess {
    private String host;
    private int port;
    private String tunnel;
    private boolean ssl;
    private int threadNum;
    private int packetSize;
    private int batches;
    private int messages;
    private ConnectionType[] types;

    public TestProcess(String string, int n, String string2, boolean bl, int n2, int n3, int n4, int n5, ConnectionType[] connectionTypeArray) {
        this.host = string;
        this.port = n;
        this.tunnel = string2;
        this.ssl = bl;
        this.threadNum = n2;
        this.packetSize = n3;
        this.batches = n4;
        this.messages = n5;
        this.types = connectionTypeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest() {
        TestThread[] testThreadArray = new TestThread[this.threadNum];
        ArrayList<TestThread> arrayList = new ArrayList<TestThread>();
        for (int i = 0; i < this.types.length; ++i) {
            arrayList.clear();
            this.appendLog("Testing " + this.types[i] + ", packet size=" + this.packetSize + ", threads=" + this.threadNum + ", batch=" + this.batches);
            this.types[i].select();
            ConnectionType connectionType = this.types[i];
            for (int j = 0; j < this.batches; ++j) {
                int n;
                for (n = 0; n < testThreadArray.length; ++n) {
                    testThreadArray[n] = new TestThread("Tester " + n, this.packetSize, this.ssl, connectionType, this.messages);
                    testThreadArray[n].start();
                }
                for (n = 0; n < testThreadArray.length; ++n) {
                    try {
                        testThreadArray[n].join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    arrayList.add(testThreadArray[n]);
                }
            }
            connectionType.unselect();
            Collections.sort(arrayList);
            double d = 0.0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                TestThread testThread = (TestThread)iterator.next();
                testThread.close();
                d += (double)testThread.getRunTime() / (double)this.threadNum / (double)this.batches;
            }
            double d2 = arrayList.size() % 2 != 0 ? (double)((TestThread)arrayList.get(arrayList.size() / 2)).getRunTime() : (double)((TestThread)arrayList.get(arrayList.size() / 2 - 1)).getRunTime() / 2.0 + (double)((TestThread)arrayList.get(arrayList.size() / 2)).getRunTime() / 2.0;
            this.appendLog("  Round-trip time:");
            this.appendLog("    Min: " + ((TestThread)arrayList.get(0)).getRunTime() + "ms");
            this.appendLog("    Max: " + ((TestThread)arrayList.get(arrayList.size() - 1)).getRunTime() + "ms");
            this.appendLog("    Avg: " + Math.floor(d * 100.0) / 100.0 + "ms");
            this.appendLog("    Med: " + Math.floor(d2 * 100.0) / 100.0 + "ms");
            this.appendLog("--------------------------");
        }
    }

    private synchronized void appendLog(String string) {
        this.bareAppendLog(string);
    }

    protected abstract void bareAppendLog(String var1);

    private class TestThread
    extends Thread
    implements Comparable {
        private String name;
        private int length;
        private long time = -1L;
        private boolean ssl;
        private Tester tester;
        private ConnectionType type;
        private int messages;

        public int compareTo(Object object) {
            TestThread testThread = (TestThread)object;
            if (this.time == testThread.time) {
                return 0;
            }
            if (this.time < testThread.time) {
                return -1;
            }
            return 1;
        }

        public TestThread(String string, int n, boolean bl, ConnectionType connectionType, int n2) {
            this.name = string;
            this.length = n;
            this.ssl = bl;
            this.type = connectionType;
            this.messages = n2;
        }

        public long getRunTime() {
            return this.time;
        }

        public void close() {
            if (this.tester != null) {
                try {
                    this.tester.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.tester = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.tester = null;
            long l = new Date().getTime();
            try {
                this.tester = new Tester(TestProcess.this.host, TestProcess.this.port, TestProcess.this.tunnel, this.type, this.ssl);
                this.tester.sendAndWait(this.length, this.messages);
            }
            catch (Exception exception) {
                TestProcess.this.appendLog("ERROR: " + this.name + ": " + exception.toString());
            }
            finally {
                this.time = new Date().getTime() - l;
            }
        }
    }
}

