/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.testerApplet;

import com.topcoder.client.connectiontype.ConnectionType;
import com.topcoder.client.testerApplet.TestProcess;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class MainFrame
extends JFrame {
    private String host;
    private int port;
    private String tunnel;
    private JTextPane log;
    private JTextField threads;
    private JTextField size;
    private JButton start;
    private JCheckBox useSSL;
    private JTextField batch;

    public MainFrame(String string, int n, String string2) {
        super("TopCoder Arena Connection Tester");
        this.host = string;
        this.port = n;
        this.tunnel = string2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        this.log = new JTextPane();
        this.log.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.log);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.getContentPane().add((Component)new JLabel("Packet Size:"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.size = new JTextField("1024", 4);
        this.getContentPane().add((Component)this.size, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.getContentPane().add((Component)new JLabel("Threads:"), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        this.threads = new JTextField("10", 3);
        this.getContentPane().add((Component)this.threads, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        this.getContentPane().add((Component)new JLabel("Batches:"), gridBagConstraints);
        gridBagConstraints.gridx = 6;
        this.batch = new JTextField("1", 3);
        this.getContentPane().add((Component)this.batch, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        this.useSSL = new JCheckBox("Use SSL", true);
        this.getContentPane().add((Component)this.useSSL, gridBagConstraints);
        gridBagConstraints.gridx = 8;
        this.start = new JButton("Start");
        this.getContentPane().add((Component)this.start, gridBagConstraints);
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.startTest();
            }
        });
    }

    public void startTest() {
        this.start.setEnabled(false);
        int n = 10;
        try {
            n = Integer.parseInt(this.threads.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        final int n2 = n;
        n = 1024;
        try {
            n = Integer.parseInt(this.size.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        final int n3 = n;
        final boolean bl = this.useSSL.isSelected();
        final int n4 = Integer.parseInt(this.batch.getText());
        new Thread(new Runnable(){

            public void run() {
                new TestProcess(MainFrame.this.host, MainFrame.this.port, MainFrame.this.tunnel, bl, n2, n3, n4, 1, ConnectionType.getAvailableTypes()){

                    protected void bareAppendLog(String string) {
                        MainFrame.this.appendLog(string);
                    }
                }.runTest();
            }
        }).start();
    }

    private void appendLog(String string) {
        this.log.setText(this.log.getText() + string + "\n");
        this.repaint();
    }
}

