/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.security;

import com.topcoder.shared.util.encoding.Base64Encoding;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;

public class PublicKeyObtainer {
    public static PublicKey obtainPublicKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        Properties properties = new Properties();
        properties.load(PublicKeyObtainer.class.getResourceAsStream("/encryption.properties"));
        String string = properties.getProperty("Algorithm");
        byte[] byArray = Base64Encoding.decode64(properties.getProperty("Key"));
        return PublicKeyObtainer.obtainKey(string, byArray);
    }

    public static PublicKey obtainKey(String string, byte[] byArray) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(string);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }
}

