/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.HTMLCharacterHandler;
import com.topcoder.shared.problem.TextElement;

public class TextElementRenderer
extends BaseRenderer {
    private TextElement textElement;

    public TextElementRenderer() {
        this.textElement = null;
    }

    public TextElementRenderer(TextElement textElement) {
        this.textElement = textElement;
    }

    public void setElement(Element element) {
        if (!(element instanceof TextElement)) {
            throw new IllegalArgumentException("element must be a TextElement Object.");
        }
        this.textElement = (TextElement)element;
    }

    public String toHTML(Language language) {
        if (this.textElement == null) {
            throw new IllegalStateException("The text is not set.");
        }
        return this.textElement.isEscapedText() ? this.textElement.getEditableText() : BaseRenderer.encodeHTML(this.textElement.getEditableText());
    }

    public String toPlainText(Language language) {
        if (this.textElement == null) {
            throw new IllegalStateException("The text is not set.");
        }
        return this.textElement.isEscapedText() ? HTMLCharacterHandler.decode(this.textElement.getEditableText()) : this.textElement.getEditableText();
    }
}

