/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.client.render.DataTypeRenderer;
import com.topcoder.client.render.NodeElementRenderer;
import com.topcoder.client.render.ProblemRenderer;
import com.topcoder.client.render.TextElementRenderer;
import com.topcoder.client.render.UserConstraintRenderer;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ElementRenderer;
import com.topcoder.shared.problem.NodeElement;
import com.topcoder.shared.problem.TextElement;
import com.topcoder.shared.problem.UserConstraint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RendererFactory {
    private Map renderers = Collections.synchronizedMap(new HashMap());

    public RendererFactory() {
        this.registerRenderer(NodeElement.class, NodeElementRenderer.class);
        this.registerRenderer(TextElement.class, TextElementRenderer.class);
        this.registerRenderer(UserConstraint.class, UserConstraintRenderer.class);
        this.registerRenderer(DataType.class, DataTypeRenderer.class);
    }

    public void registerRenderer(Class clazz, Class clazz2) {
        this.renderers.put(clazz, clazz2);
    }

    public ElementRenderer getRenderer(Element element) throws Exception {
        Class clazz = (Class)this.renderers.get(element.getClass());
        if (clazz == null) {
            clazz = this.resolveFromName(element);
            this.renderers.put(element.getClass(), clazz);
        }
        try {
            ElementRenderer elementRenderer = (ElementRenderer)clazz.newInstance();
            elementRenderer.setElement(element);
            if (elementRenderer instanceof BaseRenderer) {
                ((BaseRenderer)elementRenderer).setRendererFactory(this);
            }
            return elementRenderer;
        }
        catch (InstantiationException instantiationException) {
            throw new Exception("Could not instantiate: " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Exception("Illegal Access: " + clazz.getName());
        }
    }

    private Class resolveFromName(Element element) throws Exception {
        System.out.println("Element:" + element.getClass().getName());
        String string = element.getClass().getName().substring(element.getClass().getName().lastIndexOf(".") + 1);
        String string2 = string + "Renderer";
        String string3 = ProblemRenderer.class.getName().substring(0, ProblemRenderer.class.getName().lastIndexOf("."));
        try {
            return Class.forName(string3 + "." + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("Could not find class: " + string3 + string2);
        }
    }
}

