/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.Range;

public class RangeRenderer
extends BaseRenderer {
    private Range range = null;

    public RangeRenderer() {
        this.range = null;
    }

    public RangeRenderer(Range range) {
        this.range = range;
    }

    public void setElement(Element element) {
        if (!(element instanceof Range)) {
            throw new IllegalArgumentException("element must be a Range Object.");
        }
        this.range = (Range)element;
    }

    public String toHTML(Language language) {
        return BaseRenderer.encodeHTML(this.toPlainText(language));
    }

    public String toPlainText(Language language) {
        if (this.range == null) {
            throw new IllegalStateException("The range is not set.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.range.getMin().toString());
        stringBuffer.append(" - ");
        stringBuffer.append(this.range.getMax().toString());
        stringBuffer.append(" (inclusive)");
        return stringBuffer.toString();
    }
}

