/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.client.render.ProblemComponentRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.Problem;
import com.topcoder.shared.problem.ProblemComponent;
import com.topcoder.shared.problem.ProblemConstants;
import java.awt.Color;

public class ProblemRenderer
extends BaseRenderer {
    private Problem problem;
    private Color backgroundColor = null;
    private Color foregroundColor = null;

    public ProblemRenderer(Problem problem) {
        this.problem = problem;
    }

    public void setElement(Element element) throws Exception {
        if (!(element instanceof Problem)) {
            throw new IllegalArgumentException("element must be a Problem Object.");
        }
        this.problem = (Problem)element;
    }

    public String toHTML(Language language) throws Exception {
        if (this.problem == null) {
            throw new IllegalStateException("The problem is not set.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<body");
        if (this.backgroundColor != null) {
            stringBuffer.append(" bgcolor=\"#");
            stringBuffer.append(ProblemRenderer.rgbColor(this.backgroundColor));
            stringBuffer.append("\"");
        } else {
            stringBuffer.append(" bgcolor='black'");
        }
        if (this.foregroundColor != null) {
            stringBuffer.append(" text=\"#");
            stringBuffer.append(ProblemRenderer.rgbColor(this.foregroundColor));
            stringBuffer.append("\"");
        } else {
            stringBuffer.append(" text='white'");
        }
        stringBuffer.append(">");
        if (this.problem.getProblemText() != null && !this.problem.getProblemText().equals("")) {
            stringBuffer.append(this.problem.getProblemText());
            stringBuffer.append("<hr>");
        }
        int n = -1;
        if (this.problem.getPrimaryComponent() != null) {
            stringBuffer.append(new ProblemComponentRenderer(this.problem.getPrimaryComponent()).toHTML(language, false, this.problem.getProblemTypeID() == ProblemConstants.TEAM_PROBLEM));
            n = this.problem.getPrimaryComponent().getComponentId();
            stringBuffer.append("<hr>");
        }
        ProblemComponent[] problemComponentArray = this.problem.getProblemComponents();
        for (int i = 0; i < problemComponentArray.length; ++i) {
            if (problemComponentArray[i].getComponentId() == n) continue;
            stringBuffer.append(new ProblemComponentRenderer(problemComponentArray[i]).toHTML(language, false, false));
            stringBuffer.append("<hr>");
        }
        stringBuffer.append("<p>");
        stringBuffer.append("This problem statement is the exclusive and proprietary property of TopCoder, Inc.  Any unauthorized use or reproduction of this information without the prior written consent of TopCoder, Inc. is strictly prohibited.  (c)2003, TopCoder, Inc.  All rights reserved.  ");
        stringBuffer.append("</p>");
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public String toPlainText(Language language) throws Exception {
        if (this.problem == null) {
            throw new IllegalStateException("The problem is not set.");
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        if (!this.problem.getProblemText().equals("")) {
            stringBuffer.append(this.problem.getProblemText());
            stringBuffer.append("\n\n\n");
        }
        int n = -1;
        if (this.problem.getPrimaryComponent() != null) {
            stringBuffer.append(new ProblemComponentRenderer(this.problem.getPrimaryComponent()).toPlainText(language));
            n = this.problem.getPrimaryComponent().getComponentId();
        }
        ProblemComponent[] problemComponentArray = this.problem.getProblemComponents();
        for (int i = 0; i < problemComponentArray.length; ++i) {
            if (problemComponentArray[i].getComponentId() == n) continue;
            stringBuffer.append(new ProblemComponentRenderer(problemComponentArray[i]).toPlainText(language));
        }
        stringBuffer.append("This problem statement is the exclusive and proprietary property of TopCoder, Inc.  Any unauthorized use or reproduction of this information without the prior written consent of TopCoder, Inc. is strictly prohibited.  (c)2003, TopCoder, Inc.  All rights reserved.  ");
        return stringBuffer.toString();
    }

    static String rgbColor(Color color) {
        String string = ProblemRenderer.lpad(Integer.toString(color.getRed(), 16), '0', 2);
        String string2 = ProblemRenderer.lpad(Integer.toString(color.getGreen(), 16), '0', 2);
        String string3 = ProblemRenderer.lpad(Integer.toString(color.getBlue(), 16), '0', 2);
        return string + string2 + string3;
    }

    private static String lpad(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }
}

