/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.NodeElement;
import java.util.Arrays;
import java.util.Iterator;

public class NodeElementRenderer
extends BaseRenderer {
    private NodeElement nodeElement = null;

    public NodeElementRenderer() {
        this.nodeElement = null;
    }

    public NodeElementRenderer(NodeElement nodeElement) {
        this.nodeElement = nodeElement;
    }

    public void setElement(Element element) {
        if (!(element instanceof NodeElement)) {
            throw new IllegalArgumentException("element must be a NodeElement Object.");
        }
        this.nodeElement = (NodeElement)element;
    }

    public String toHTML(Language language) throws Exception {
        Object object;
        boolean bl;
        if (this.nodeElement == null) {
            throw new IllegalStateException("The node is not set.");
        }
        StringBuffer stringBuffer = new StringBuffer(64 * this.nodeElement.getChildren().size());
        boolean bl2 = bl = Arrays.binarySearch(BaseRenderer.XML_ONLY_TAGS, this.nodeElement.getName()) < 0;
        if (bl) {
            stringBuffer.append('<');
            stringBuffer.append(this.nodeElement.getName());
            Iterator iterator = this.nodeElement.getAttributes().keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuffer.append(' ');
                stringBuffer.append((String)object);
                stringBuffer.append("=\"");
                stringBuffer.append(BaseRenderer.encodeHTML((String)this.nodeElement.getAttributes().get(object)));
                stringBuffer.append('\"');
            }
            stringBuffer.append('>');
        }
        for (int i = 0; i < this.nodeElement.getChildren().size(); ++i) {
            object = (Element)this.nodeElement.getChildren().get(i);
            stringBuffer.append(super.getRenderer((Element)object).toHTML(language));
        }
        if (bl) {
            stringBuffer.append("</");
            stringBuffer.append(this.nodeElement.getName());
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public String toPlainText(Language language) throws Exception {
        if (this.nodeElement == null) {
            throw new IllegalStateException("The node is not set.");
        }
        StringBuffer stringBuffer = new StringBuffer(64 * this.nodeElement.getChildren().size());
        for (int i = 0; i < this.nodeElement.getChildren().size(); ++i) {
            Element element = (Element)this.nodeElement.getChildren().get(i);
            stringBuffer.append(super.getRenderer(element).toPlainText(language));
        }
        return stringBuffer.toString();
    }
}

