/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.MinSizeConstraint;

public class MinSizeConstraintRenderer
extends BaseRenderer {
    private MinSizeConstraint minSizeConstraint;

    public MinSizeConstraintRenderer() {
        this.minSizeConstraint = null;
    }

    public MinSizeConstraintRenderer(MinSizeConstraint minSizeConstraint) {
        this.minSizeConstraint = minSizeConstraint;
    }

    public String toHTML(Language language) {
        return this.toPlainText(language);
    }

    public void setElement(Element element) throws Exception {
        if (!(element instanceof MinSizeConstraint)) {
            throw new IllegalArgumentException("element must be a MinSizeConstraint Object.");
        }
        this.minSizeConstraint = (MinSizeConstraint)element;
    }

    public String toPlainText(Language language) {
        if (this.minSizeConstraint == null) {
            throw new IllegalStateException("The minimum size constraint is not set.");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        for (int i = 0; i < this.minSizeConstraint.getDimension(); ++i) {
            if (i == 0) {
                stringBuffer.append("Elements of ");
                continue;
            }
            stringBuffer.append("elements of ");
        }
        stringBuffer.append(this.minSizeConstraint.getParamName());
        stringBuffer.append(" must have a minimum length of ");
        stringBuffer.append(this.minSizeConstraint.getSize());
        return stringBuffer.toString();
    }
}

