/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.MaxSizeConstraint;

public class MaxSizeConstraintRenderer
extends BaseRenderer {
    private MaxSizeConstraint maxSizeConstraint;

    public MaxSizeConstraintRenderer() {
        this.maxSizeConstraint = null;
    }

    public MaxSizeConstraintRenderer(MaxSizeConstraint maxSizeConstraint) {
        this.maxSizeConstraint = maxSizeConstraint;
    }

    public void setElement(Element element) {
        if (!(element instanceof MaxSizeConstraint)) {
            throw new IllegalArgumentException("element must be a MaxSizeConstraint Object.");
        }
        this.maxSizeConstraint = (MaxSizeConstraint)element;
    }

    public String toHTML(Language language) {
        return this.toPlainText(language);
    }

    public String toPlainText(Language language) {
        if (this.maxSizeConstraint == null) {
            throw new IllegalStateException("The maximum size constraint is not set.");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        for (int i = 0; i < this.maxSizeConstraint.getDimension(); ++i) {
            if (i == 0) {
                stringBuffer.append("Elements of ");
                continue;
            }
            stringBuffer.append("elements of ");
        }
        stringBuffer.append(this.maxSizeConstraint.getParamName());
        stringBuffer.append(" must have a maximum length of ");
        stringBuffer.append(this.maxSizeConstraint.getSize());
        return stringBuffer.toString();
    }
}

