/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.BaseRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.Element;

public class DataTypeRenderer
extends BaseRenderer {
    private DataType dataType;

    public DataTypeRenderer() {
        this.dataType = null;
    }

    public DataTypeRenderer(DataType dataType) {
        this.dataType = dataType;
    }

    public void setElement(Element element) {
        if (!(element instanceof DataType)) {
            throw new IllegalArgumentException("element must be a DataType Object.");
        }
        this.dataType = (DataType)element;
    }

    public String toHTML(Language language) {
        return BaseRenderer.encodeHTML(this.toPlainText(language));
    }

    public String toPlainText(Language language) {
        if (this.dataType == null) {
            throw new IllegalStateException("The data type is not set.");
        }
        String string = this.dataType.getDescriptor(language);
        if (string == null) {
            return "null";
        }
        return string;
    }
}

