/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.render;

import com.topcoder.client.render.RendererFactory;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ElementRenderer;
import com.topcoder.shared.problem.HTMLCharacterHandler;

abstract class BaseRenderer
implements ElementRenderer {
    static final String[] XML_ONLY_TAGS = new String[]{"annotation", "block", "constraints", "example", "flow", "fontstyle", "heading", "inline", "input", "intro", "list", "name", "note", "notes", "output", "problem", "signature", "spec", "special", "tctype", "test-case", "test-cases", "type", "user-constraint"};
    static final String[] HTML_ONLY_TAGS = new String[]{"ul", "ol", "li", "tt", "i", "b", "h1", "h2", "h3", "h4", "h5", "a", "img", "br", "sub", "sup", "p", "pre", "hr", "list"};
    private static final RendererFactory RENDERER_FACTORY_DEFAULT = new RendererFactory();
    private RendererFactory rendererFactory;

    BaseRenderer() {
    }

    static String encodeHTML(String string) {
        return HTMLCharacterHandler.encodeSimple(string);
    }

    ElementRenderer getRenderer(Element element) throws Exception {
        if (this.rendererFactory == null) {
            this.rendererFactory = RENDERER_FACTORY_DEFAULT;
        }
        return this.rendererFactory.getRenderer(element);
    }

    static String removeHtmlTags(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < HTML_ONLY_TAGS.length; ++i) {
            boolean bl = false;
            while (!bl) {
                int n = stringBuffer.indexOf("<" + HTML_ONLY_TAGS[i] + ">");
                int n2 = stringBuffer.indexOf("</" + HTML_ONLY_TAGS[i] + ">");
                int n3 = stringBuffer.indexOf("<" + HTML_ONLY_TAGS[i] + "/>");
                boolean bl2 = bl = n < 0 && n2 < 0 && n3 < 0;
                if (n > -1) {
                    stringBuffer.delete(n, n + HTML_ONLY_TAGS[i].length() + 2);
                }
                if (n2 > -1) {
                    stringBuffer.delete(n2, n2 + HTML_ONLY_TAGS[i].length() + 3);
                }
                if (n3 <= -1) continue;
                stringBuffer.delete(n3, n3 + HTML_ONLY_TAGS[i].length() + 3);
            }
        }
        return stringBuffer.toString();
    }

    public RendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public void setRendererFactory(RendererFactory rendererFactory) {
        this.rendererFactory = rendererFactory;
    }
}

