/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.netClient;

import com.topcoder.client.contestant.message.MessageProcessor;
import com.topcoder.client.netClient.ContestResponseHandler;
import com.topcoder.client.netClient.NetMessageProcessor;
import com.topcoder.client.netClient.RequestTimedOutException;
import com.topcoder.client.netClient.ResponseToSyncRequestWaiter;
import com.topcoder.client.netClient.ResponseWaiterManager;
import com.topcoder.client.security.PublicKeyObtainer;
import com.topcoder.netCommon.contestantMessages.NetCommonCSHandler;
import com.topcoder.netCommon.contestantMessages.request.BaseRequest;
import com.topcoder.netCommon.contestantMessages.request.KeepAliveRequest;
import com.topcoder.netCommon.io.ClientConnector;
import com.topcoder.netCommon.io.ClientConnectorFactory;
import com.topcoder.netCommon.io.ClientSocket;
import com.topcoder.netCommon.io.InputChannelActivityListener;
import com.topcoder.netCommon.io.ProxiedSocketClientConnector;
import com.topcoder.shared.netCommon.resettabletask.ResettableTaskRunner;
import com.topcoder.shared.netCommon.resettabletask.ResettableTimerTask;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class Client {
    private static final long KEEPALIVE_TIMEOUT_MS = 30000L;
    private static final String INACTIVITY_TIMEOUT_KEY = "com.topcoder.input.inactivity.timeout";
    private static final int INACTIVITY_TIMEOUT = Client.getInactivityTimeout();
    private static final String SSL_PORT_OFFSET_KEY = "com.topcoder.ssl.port.offset";
    private static final int SSL_PORT_OFFSET = Client.resolveValue("com.topcoder.ssl.port.offset", 10);
    private ContestResponseHandler responseHandler;
    private ResponseWaiterManager waiterManager = new ResponseWaiterManager();
    private boolean httpTunnel = false;
    private ResettableTaskRunner taskRunner;
    private ResettableTimerTask sendTask;
    private ResettableTimerTask receiveTask;
    private MessageProcessor messageProcessor;
    private boolean rhInitialized = false;
    private ClientSocket clientSocket;
    private Object synchRequestMutex = new Object();

    public Client(String string, int n) throws IOException {
        this(string, n, false);
    }

    public Client(String string, int n, boolean bl) throws IOException {
        this.init(ClientConnectorFactory.createSocketConnector(string, n, bl, SSL_PORT_OFFSET));
    }

    public Client(String string, int n, String string2) throws IOException {
        this.init(new ProxiedSocketClientConnector(string, n, string2));
    }

    public Client(String string, boolean bl) throws IOException {
        this.httpTunnel = true;
        this.init(ClientConnectorFactory.createTunneledConnector(string, bl, 10));
    }

    public synchronized void initContestResponseHandler(MessageProcessor messageProcessor) {
        if (!this.rhInitialized) {
            this.messageProcessor = messageProcessor;
            this.responseHandler = new ContestResponseHandler(this, new NetMessageProcessor(this, this.waiterManager), messageProcessor);
            this.responseHandler.start();
            this.rhInitialized = true;
        }
    }

    public synchronized void sendRequest(BaseRequest baseRequest) {
        try {
            this.writeObject(baseRequest);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSynchRequest(BaseRequest baseRequest) throws RequestTimedOutException {
        Object object = this.synchRequestMutex;
        synchronized (object) {
            int n = baseRequest.getRequestType();
            ResponseToSyncRequestWaiter responseToSyncRequestWaiter = this.waiterManager.registerWaiterFor(n);
            try {
                this.sendRequest(baseRequest);
            }
            catch (RuntimeException runtimeException) {
                this.waiterManager.unregisterWaiterFor(n);
                throw runtimeException;
            }
            try {
                if (!responseToSyncRequestWaiter.block()) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.waiterManager.unregisterWaiterFor(n);
            }
        }
        throw new RequestTimedOutException("Request timed out " + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.responseHandler;
            synchronized (object) {
                if (this.responseHandler != null) {
                    this.responseHandler.close();
                }
            }
            if (this.taskRunner != null && this.taskRunner.isRunning()) {
                this.taskRunner.stop();
            }
            this.waiterManager.unblockAll();
            object = this.clientSocket;
            synchronized (object) {
                this.closeSocket();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void init(ClientConnector clientConnector) throws IOException {
        try {
            this.clientSocket = new ClientSocket(clientConnector, new NetCommonCSHandler(PublicKeyObtainer.obtainPublicKey()));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (IOException)new IOException("Encryption property invalid.").initCause(generalSecurityException);
        }
        this.initKeepAliveTasks(30000L);
    }

    Object readObject() throws IOException, ClassNotFoundException {
        return this.clientSocket.readObject();
    }

    private void writeObject(Object object) throws IOException {
        this.clientSocket.writeObject(object);
        this.sendTask.reset();
    }

    private void closeSocket() throws IOException {
        this.clientSocket.close();
    }

    public void updateKeepAliveParameters(long l, long l2) {
        if (this.sendTask != null) {
            l2 = l2 > l ? l : l2;
            this.sendTask.setWaitTime(this.httpTunnel ? l2 : l);
        }
    }

    private void initKeepAliveTasks(long l) {
        this.taskRunner = new ResettableTaskRunner();
        this.sendTask = new ResettableTimerTask(l){

            protected boolean doAction() {
                try {
                    Client.this.sendRequest(new KeepAliveRequest());
                    return false;
                }
                catch (RuntimeException runtimeException) {
                    if (Client.this.messageProcessor != null) {
                        Client.this.messageProcessor.lostConnection();
                    }
                    return true;
                }
            }
        };
        this.receiveTask = new ResettableTimerTask(INACTIVITY_TIMEOUT){

            protected boolean doAction() {
                try {
                    if (Client.this.messageProcessor != null) {
                        Client.this.messageProcessor.lostConnection();
                    }
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    return true;
                }
            }
        };
        this.clientSocket.setInputChannelActivityListener(new InputChannelActivityListener(){

            public void bytesRead(int n) {
                Client.this.waiterManager.dataRead();
                Client.this.receiveTask.reset();
            }
        });
        this.taskRunner.registerTask("SendKeepAlive", this.sendTask);
        this.taskRunner.registerTask("ReceiveMonitor", this.receiveTask);
        this.taskRunner.start();
    }

    protected void finalize() throws Throwable {
        if (this.taskRunner != null && this.taskRunner.isRunning()) {
            try {
                this.taskRunner.stop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public static int getInactivityTimeout() {
        return Client.resolveValue(INACTIVITY_TIMEOUT_KEY, 100000);
    }

    private static int resolveValue(String string, int n) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }
}

