/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.InterceptorManager;
import com.topcoder.client.contestant.TimeOutException;
import com.topcoder.client.contestant.message.Requester;
import com.topcoder.client.netClient.Client;
import com.topcoder.client.netClient.RequestTimedOutException;
import com.topcoder.netCommon.contest.ComponentAssignmentData;
import com.topcoder.netCommon.contestantMessages.request.ActiveUsersRequest;
import com.topcoder.netCommon.contestantMessages.request.AddTeamMemberRequest;
import com.topcoder.netCommon.contestantMessages.request.AssignComponentsRequest;
import com.topcoder.netCommon.contestantMessages.request.AutoSystestRequest;
import com.topcoder.netCommon.contestantMessages.request.BaseRequest;
import com.topcoder.netCommon.contestantMessages.request.BatchTestRequest;
import com.topcoder.netCommon.contestantMessages.request.ChallengeRequest;
import com.topcoder.netCommon.contestantMessages.request.ChatRequest;
import com.topcoder.netCommon.contestantMessages.request.ClearPracticeProblemRequest;
import com.topcoder.netCommon.contestantMessages.request.ClearPracticeRequest;
import com.topcoder.netCommon.contestantMessages.request.CloseDivSummaryRequest;
import com.topcoder.netCommon.contestantMessages.request.CloseLeaderBoardRequest;
import com.topcoder.netCommon.contestantMessages.request.CloseProblemRequest;
import com.topcoder.netCommon.contestantMessages.request.CloseSummaryRequest;
import com.topcoder.netCommon.contestantMessages.request.CoderHistoryRequest;
import com.topcoder.netCommon.contestantMessages.request.CoderInfoRequest;
import com.topcoder.netCommon.contestantMessages.request.CompileRequest;
import com.topcoder.netCommon.contestantMessages.request.DivSummaryRequest;
import com.topcoder.netCommon.contestantMessages.request.EnterRequest;
import com.topcoder.netCommon.contestantMessages.request.EnterRoundRequest;
import com.topcoder.netCommon.contestantMessages.request.ErrorReportRequest;
import com.topcoder.netCommon.contestantMessages.request.ExchangeKeyRequest;
import com.topcoder.netCommon.contestantMessages.request.GenericPopupRequest;
import com.topcoder.netCommon.contestantMessages.request.GetAdminBroadcastsRequest;
import com.topcoder.netCommon.contestantMessages.request.GetChallengeProblemRequest;
import com.topcoder.netCommon.contestantMessages.request.GetCurrentAppletVersionRequest;
import com.topcoder.netCommon.contestantMessages.request.GetImportantMessagesRequest;
import com.topcoder.netCommon.contestantMessages.request.GetLeaderBoardRequest;
import com.topcoder.netCommon.contestantMessages.request.GetSourceCodeRequest;
import com.topcoder.netCommon.contestantMessages.request.JoinTeamRequest;
import com.topcoder.netCommon.contestantMessages.request.LeaveTeamRequest;
import com.topcoder.netCommon.contestantMessages.request.LoginRequest;
import com.topcoder.netCommon.contestantMessages.request.LogoutRequest;
import com.topcoder.netCommon.contestantMessages.request.LongSubmitRequest;
import com.topcoder.netCommon.contestantMessages.request.LongTestResultsRequest;
import com.topcoder.netCommon.contestantMessages.request.MoveRequest;
import com.topcoder.netCommon.contestantMessages.request.OpenComponentForCodingRequest;
import com.topcoder.netCommon.contestantMessages.request.OpenProblemForReadingRequest;
import com.topcoder.netCommon.contestantMessages.request.OpenSummaryRequest;
import com.topcoder.netCommon.contestantMessages.request.PracticeSystemTestRequest;
import com.topcoder.netCommon.contestantMessages.request.ReadMessageRequest;
import com.topcoder.netCommon.contestantMessages.request.ReconnectRequest;
import com.topcoder.netCommon.contestantMessages.request.RegisterInfoRequest;
import com.topcoder.netCommon.contestantMessages.request.RegisterRequest;
import com.topcoder.netCommon.contestantMessages.request.RegisterUsersRequest;
import com.topcoder.netCommon.contestantMessages.request.RemoveTeamMemberRequest;
import com.topcoder.netCommon.contestantMessages.request.RoundStatsRequest;
import com.topcoder.netCommon.contestantMessages.request.SaveRequest;
import com.topcoder.netCommon.contestantMessages.request.SearchRequest;
import com.topcoder.netCommon.contestantMessages.request.SetLanguageRequest;
import com.topcoder.netCommon.contestantMessages.request.SubmitRequest;
import com.topcoder.netCommon.contestantMessages.request.SynchTimeRequest;
import com.topcoder.netCommon.contestantMessages.request.SystestResultsRequest;
import com.topcoder.netCommon.contestantMessages.request.TestInfoRequest;
import com.topcoder.netCommon.contestantMessages.request.TestRequest;
import com.topcoder.netCommon.contestantMessages.request.ToggleChatRequest;
import com.topcoder.netCommon.contestantMessages.request.UnwatchRequest;
import com.topcoder.netCommon.contestantMessages.request.VerifyRequest;
import com.topcoder.netCommon.contestantMessages.request.VerifyResultRequest;
import com.topcoder.netCommon.contestantMessages.request.ViewQueueRequest;
import com.topcoder.netCommon.contestantMessages.request.VisitedPracticeRequest;
import com.topcoder.netCommon.contestantMessages.request.VoteRequest;
import com.topcoder.netCommon.contestantMessages.request.WLMyTeamInfoRequest;
import com.topcoder.netCommon.contestantMessages.request.WLTeamsInfoRequest;
import com.topcoder.netCommon.contestantMessages.request.WatchRequest;
import com.topcoder.shared.netCommon.SealedSerializable;
import java.util.ArrayList;

final class RequesterImpl
implements Requester {
    private Client client;
    private InterceptorManager interceptorManager = null;

    RequesterImpl() {
    }

    public void requestCurrentAppletVersion() throws TimeOutException {
        GetCurrentAppletVersionRequest getCurrentAppletVersionRequest = new GetCurrentAppletVersionRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(getCurrentAppletVersionRequest)) {
            return;
        }
        try {
            if (this.client != null) {
                this.client.sendSynchRequest(getCurrentAppletVersionRequest);
            }
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestSynchTime(long l) throws TimeOutException {
        SynchTimeRequest synchTimeRequest = new SynchTimeRequest(l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(synchTimeRequest)) {
            return;
        }
        try {
            if (this.client != null) {
                this.client.sendSynchRequest(synchTimeRequest);
            }
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestReconnect(SealedSerializable sealedSerializable, long l) throws TimeOutException {
        ReconnectRequest reconnectRequest = new ReconnectRequest(l, sealedSerializable);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(reconnectRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(reconnectRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestLogin(String string, SealedSerializable sealedSerializable, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws TimeOutException {
        LoginRequest loginRequest = new LoginRequest(string, sealedSerializable, string2, 9, string3, string4, string5, string6, string7, string8);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(loginRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(loginRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestGuestLogin() throws TimeOutException {
        LoginRequest loginRequest = new LoginRequest("Guest", null, 7);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(loginRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(loginRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestDivSummary(long l, long l2) throws TimeOutException {
        DivSummaryRequest divSummaryRequest = new DivSummaryRequest((int)l, (int)l2);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(divSummaryRequest)) {
            return;
        }
        try {
            this.client.sendRequest(divSummaryRequest);
        }
        catch (Exception exception) {
            throw new TimeOutException(exception);
        }
    }

    public void requestWatch(long l) throws TimeOutException {
        WatchRequest watchRequest = new WatchRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(watchRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(watchRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestLogoff() {
        LogoutRequest logoutRequest = new LogoutRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(logoutRequest)) {
            return;
        }
        if (this.client != null) {
            this.client.sendRequest(logoutRequest);
        }
    }

    public void requestMove(int n, long l) throws TimeOutException {
        MoveRequest moveRequest = new MoveRequest(n, (int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(moveRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(moveRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestEnterRound(long l) throws TimeOutException {
        EnterRoundRequest enterRoundRequest = new EnterRoundRequest(l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(enterRoundRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(enterRoundRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestCompile(String string, int n, long l) {
        CompileRequest compileRequest = new CompileRequest(n, (int)l, string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(compileRequest)) {
            return;
        }
        this.client.sendRequest(compileRequest);
    }

    public void requestTest(ArrayList arrayList, long l) {
        TestRequest testRequest = new TestRequest(arrayList, (int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(testRequest)) {
            return;
        }
        this.client.sendRequest(testRequest);
    }

    public void requestBatchTest(ArrayList arrayList, long l) {
        BatchTestRequest batchTestRequest = new BatchTestRequest(arrayList, (int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(batchTestRequest)) {
            return;
        }
        this.client.sendRequest(batchTestRequest);
    }

    public void requestChallenge(String string, long l, ArrayList arrayList) {
        ChallengeRequest challengeRequest = new ChallengeRequest((int)l, arrayList, string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(challengeRequest)) {
            return;
        }
        this.client.sendRequest(challengeRequest);
    }

    public void requestSubmitCode(long l) {
        SubmitRequest submitRequest = new SubmitRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(submitRequest)) {
            return;
        }
        this.client.sendRequest(submitRequest);
    }

    public void requestChatMessage(long l, String string, int n) {
        ChatRequest chatRequest = new ChatRequest(string, (int)l, n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(chatRequest)) {
            return;
        }
        this.client.sendRequest(chatRequest);
    }

    public void requestCoderHistory(String string, long l, int n) {
        CoderHistoryRequest coderHistoryRequest = new CoderHistoryRequest(string, (int)l, n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(coderHistoryRequest)) {
            return;
        }
        this.client.sendRequest(coderHistoryRequest);
    }

    public void requestSubmissionHistory(String string, long l, int n, boolean bl) {
        int n2 = bl ? 1 : 2;
        CoderHistoryRequest coderHistoryRequest = new CoderHistoryRequest(string, (int)l, n, n2);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(coderHistoryRequest)) {
            return;
        }
        this.client.sendRequest(coderHistoryRequest);
    }

    public void requestCoderInfo(String string, int n) {
        CoderInfoRequest coderInfoRequest = new CoderInfoRequest(string, n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(coderInfoRequest)) {
            return;
        }
        this.client.sendRequest(coderInfoRequest);
    }

    public void requestEnter(long l) {
        EnterRequest enterRequest = new EnterRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(enterRequest)) {
            return;
        }
        this.client.sendRequest(enterRequest);
    }

    public void requestOpenComponentForCoding(long l) {
        OpenComponentForCodingRequest openComponentForCodingRequest = new OpenComponentForCodingRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(openComponentForCodingRequest)) {
            return;
        }
        this.client.sendRequest(openComponentForCodingRequest);
    }

    public void requestOpenProblemForReading(long l, long l2) {
        OpenProblemForReadingRequest openProblemForReadingRequest = new OpenProblemForReadingRequest((int)l, (int)l2);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(openProblemForReadingRequest)) {
            return;
        }
        this.client.sendRequest(openProblemForReadingRequest);
    }

    public void requestCloseComponent(long l, String string) {
        CloseProblemRequest closeProblemRequest = new CloseProblemRequest((int)l, string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(closeProblemRequest)) {
            return;
        }
        if (this.client != null) {
            this.client.sendRequest(closeProblemRequest);
        }
    }

    public void requestSave(long l, String string, int n) {
        SaveRequest saveRequest = new SaveRequest(string, (int)l, n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(saveRequest)) {
            return;
        }
        this.client.sendRequest(saveRequest);
    }

    public void requestSubmitLong(long l, String string, int n, boolean bl) {
        LongSubmitRequest longSubmitRequest = new LongSubmitRequest(string, (int)l, n, bl);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(longSubmitRequest)) {
            return;
        }
        this.client.sendRequest(longSubmitRequest);
    }

    public void requestLongTestResults(long l, long l2, String string, int n) {
        LongTestResultsRequest longTestResultsRequest = new LongTestResultsRequest((int)l, (int)l2, string, n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(longTestResultsRequest)) {
            return;
        }
        this.client.sendRequest(longTestResultsRequest);
    }

    public void requestSearch(String string) {
        SearchRequest searchRequest = new SearchRequest(string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(searchRequest)) {
            return;
        }
        this.client.sendRequest(searchRequest);
    }

    public void requestSetLanguage(int n) {
        SetLanguageRequest setLanguageRequest = new SetLanguageRequest(n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(setLanguageRequest)) {
            return;
        }
        this.client.sendRequest(setLanguageRequest);
    }

    public void requestUnwatch(long l) {
        UnwatchRequest unwatchRequest = new UnwatchRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(unwatchRequest)) {
            return;
        }
        this.client.sendRequest(unwatchRequest);
    }

    public void requestCloseDivSummary(long l, long l2) {
        CloseDivSummaryRequest closeDivSummaryRequest = new CloseDivSummaryRequest((int)l, (int)l2);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(closeDivSummaryRequest)) {
            return;
        }
        this.client.sendRequest(closeDivSummaryRequest);
    }

    public void requestClearPractice(long l) {
        ClearPracticeRequest clearPracticeRequest = new ClearPracticeRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(clearPracticeRequest)) {
            return;
        }
        this.client.sendRequest(clearPracticeRequest);
    }

    public void requestClearPracticeProblem(long l, Long[] longArray) {
        ClearPracticeProblemRequest clearPracticeProblemRequest = new ClearPracticeProblemRequest((int)l, longArray);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(clearPracticeProblemRequest)) {
            return;
        }
        this.client.sendRequest(clearPracticeProblemRequest);
    }

    public void requestChallengeComponent(long l, boolean bl, long l2, String string) {
        GetChallengeProblemRequest getChallengeProblemRequest = new GetChallengeProblemRequest(string, (int)l, bl, (int)l2);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(getChallengeProblemRequest)) {
            return;
        }
        this.client.sendRequest(getChallengeProblemRequest);
    }

    public void requestSourceCode(int n, String string, int n2, boolean bl, int n3, boolean bl2) {
        GetSourceCodeRequest getSourceCodeRequest = new GetSourceCodeRequest(n, string, n2, bl, n3, bl2);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(getSourceCodeRequest)) {
            return;
        }
        this.client.sendRequest(getSourceCodeRequest);
    }

    public void requestViewQueueStatus() {
        ViewQueueRequest viewQueueRequest = new ViewQueueRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(viewQueueRequest)) {
            return;
        }
        this.client.sendRequest(viewQueueRequest);
    }

    public void requestActiveUsers() {
        ActiveUsersRequest activeUsersRequest = new ActiveUsersRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(activeUsersRequest)) {
            return;
        }
        this.client.sendRequest(activeUsersRequest);
    }

    public void requestPracticeSystemTest(long l, int[] nArray) {
        PracticeSystemTestRequest practiceSystemTestRequest = new PracticeSystemTestRequest((int)l, nArray);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(practiceSystemTestRequest)) {
            return;
        }
        this.client.sendRequest(practiceSystemTestRequest);
    }

    public void requestGetAdminBroadcast() {
        GetAdminBroadcastsRequest getAdminBroadcastsRequest = new GetAdminBroadcastsRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(getAdminBroadcastsRequest)) {
            return;
        }
        this.client.sendRequest(getAdminBroadcastsRequest);
    }

    public void requestRegisterEventInfo(long l) {
        RegisterInfoRequest registerInfoRequest = new RegisterInfoRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(registerInfoRequest)) {
            return;
        }
        this.client.sendRequest(registerInfoRequest);
    }

    public void requestRegister(long l, ArrayList arrayList) {
        RegisterRequest registerRequest = new RegisterRequest(arrayList, (int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(registerRequest)) {
            return;
        }
        this.client.sendRequest(registerRequest);
    }

    public void requestRegisterUsers(long l) {
        RegisterUsersRequest registerUsersRequest = new RegisterUsersRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(registerUsersRequest)) {
            return;
        }
        this.client.sendRequest(registerUsersRequest);
    }

    public void requestTestInfo(long l) {
        TestInfoRequest testInfoRequest = new TestInfoRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(testInfoRequest)) {
            return;
        }
        this.client.sendRequest(testInfoRequest);
    }

    public void requestToggleChat() {
        ToggleChatRequest toggleChatRequest = new ToggleChatRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(toggleChatRequest)) {
            return;
        }
        this.client.sendRequest(toggleChatRequest);
    }

    public void requestPopupGeneric(int n, int n2, ArrayList arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        GenericPopupRequest genericPopupRequest = new GenericPopupRequest(n, n2, arrayList);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(genericPopupRequest)) {
            return;
        }
        this.client.sendRequest(genericPopupRequest);
    }

    public void requestGetLeaderBoard() {
        GetLeaderBoardRequest getLeaderBoardRequest = new GetLeaderBoardRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(getLeaderBoardRequest)) {
            return;
        }
        this.client.sendRequest(getLeaderBoardRequest);
    }

    public void requestCloseLeaderBoard() {
        CloseLeaderBoardRequest closeLeaderBoardRequest = new CloseLeaderBoardRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(closeLeaderBoardRequest)) {
            return;
        }
        if (this.client != null) {
            this.client.sendRequest(closeLeaderBoardRequest);
        }
    }

    public void requestOpenSummary(long l) {
        OpenSummaryRequest openSummaryRequest = new OpenSummaryRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(openSummaryRequest)) {
            return;
        }
        this.client.sendRequest(openSummaryRequest);
    }

    public void requestCloseSummary(long l) {
        CloseSummaryRequest closeSummaryRequest = new CloseSummaryRequest((int)l);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(closeSummaryRequest)) {
            return;
        }
        if (this.client != null) {
            this.client.sendRequest(closeSummaryRequest);
        }
    }

    public void requestJoinTeam(String string) {
        JoinTeamRequest joinTeamRequest = new JoinTeamRequest(string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(joinTeamRequest)) {
            return;
        }
        this.client.sendRequest(joinTeamRequest);
    }

    public void requestLeaveTeam(String string) {
        LeaveTeamRequest leaveTeamRequest = new LeaveTeamRequest(string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(leaveTeamRequest)) {
            return;
        }
        this.client.sendRequest(leaveTeamRequest);
    }

    public void requestAddTeamMember(String string) {
        AddTeamMemberRequest addTeamMemberRequest = new AddTeamMemberRequest(string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(addTeamMemberRequest)) {
            return;
        }
        this.client.sendRequest(addTeamMemberRequest);
    }

    public void requestRemoveTeamMember(String string) {
        RemoveTeamMemberRequest removeTeamMemberRequest = new RemoveTeamMemberRequest(string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(removeTeamMemberRequest)) {
            return;
        }
        this.client.sendRequest(removeTeamMemberRequest);
    }

    public void requestAssignComponents(ComponentAssignmentData componentAssignmentData) {
        AssignComponentsRequest assignComponentsRequest = new AssignComponentsRequest(componentAssignmentData);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(assignComponentsRequest)) {
            return;
        }
        this.client.sendRequest(assignComponentsRequest);
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setInterceptorManager(InterceptorManager interceptorManager) {
        this.interceptorManager = interceptorManager;
    }

    private void sendRequest(BaseRequest baseRequest) {
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(baseRequest)) {
            return;
        }
        this.client.sendRequest(baseRequest);
    }

    public void requestVote(int n, String string) {
        VoteRequest voteRequest = new VoteRequest(n, string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(voteRequest)) {
            return;
        }
        this.sendRequest(voteRequest);
    }

    public void requestRoundStats(int n, String string) {
        RoundStatsRequest roundStatsRequest = new RoundStatsRequest(n, string);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(roundStatsRequest)) {
            return;
        }
        this.sendRequest(roundStatsRequest);
    }

    public void requestWLMyTeamInfo(int n) {
        WLMyTeamInfoRequest wLMyTeamInfoRequest = new WLMyTeamInfoRequest(n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(wLMyTeamInfoRequest)) {
            return;
        }
        this.sendRequest(wLMyTeamInfoRequest);
    }

    public void requestWLTeamsInfo(int n) {
        WLTeamsInfoRequest wLTeamsInfoRequest = new WLTeamsInfoRequest(n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(wLTeamsInfoRequest)) {
            return;
        }
        this.sendRequest(wLTeamsInfoRequest);
    }

    public void requestSunAutoCompile(int n) {
        AutoSystestRequest autoSystestRequest = new AutoSystestRequest(n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(autoSystestRequest)) {
            return;
        }
        this.client.sendRequest(autoSystestRequest);
    }

    public void requestSystestResults(int n) {
        SystestResultsRequest systestResultsRequest = new SystestResultsRequest(n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(systestResultsRequest)) {
            return;
        }
        this.client.sendRequest(systestResultsRequest);
    }

    public void requestReadMessage(int n) {
        ReadMessageRequest readMessageRequest = new ReadMessageRequest(n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(readMessageRequest)) {
            return;
        }
        this.client.sendRequest(readMessageRequest);
    }

    public void requestImportantMessages() {
        GetImportantMessagesRequest getImportantMessagesRequest = new GetImportantMessagesRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(getImportantMessagesRequest)) {
            return;
        }
        this.client.sendRequest(getImportantMessagesRequest);
    }

    public void requestVisitedPractice() {
        VisitedPracticeRequest visitedPracticeRequest = new VisitedPracticeRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(visitedPracticeRequest)) {
            return;
        }
        this.client.sendRequest(visitedPracticeRequest);
    }

    public void requestVerify() throws TimeOutException {
        VerifyRequest verifyRequest = new VerifyRequest();
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(verifyRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(verifyRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestVerifyResult(int n) throws TimeOutException {
        VerifyResultRequest verifyResultRequest = new VerifyResultRequest(n);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(verifyResultRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(verifyResultRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }

    public void requestErrorReport(Throwable throwable) {
        ErrorReportRequest errorReportRequest = new ErrorReportRequest(throwable);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(errorReportRequest)) {
            return;
        }
        this.client.sendRequest(errorReportRequest);
    }

    public void requestExchangeKey(byte[] byArray) throws TimeOutException {
        ExchangeKeyRequest exchangeKeyRequest = new ExchangeKeyRequest(byArray);
        if (this.interceptorManager != null && this.interceptorManager.sendMessage(exchangeKeyRequest)) {
            return;
        }
        try {
            this.client.sendSynchRequest(exchangeKeyRequest);
        }
        catch (RequestTimedOutException requestTimedOutException) {
            throw new TimeOutException(requestTimedOutException);
        }
    }
}

