/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.impl.ProblemComponentModelImpl;
import com.topcoder.client.contestant.impl.RoundModelImpl;
import com.topcoder.client.contestant.view.EventService;
import com.topcoder.client.render.ProblemRenderer;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Problem;
import java.util.LinkedList;
import java.util.List;

class ProblemModelImpl
implements ProblemModel {
    private Problem serverProblemObject;
    private RoundModelImpl roundModel;
    private Integer division;
    private String name;
    private Long problemID;
    private Integer problemTypeID;
    private ProblemComponentModelImpl[] components;
    private List listeners = new LinkedList();
    private EventService eventService;

    public ProblemModelImpl(Long l, RoundModelImpl roundModelImpl, Integer n, String string, Integer n2, EventService eventService) {
        this.problemID = l;
        this.roundModel = roundModelImpl;
        this.division = n;
        this.name = string;
        this.problemTypeID = n2;
        this.eventService = eventService;
    }

    public ProblemComponentModel[] getComponents() {
        return this.components;
    }

    public ProblemComponentModel getPrimaryComponent() {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].getComponentTypeID() != 1) continue;
            return this.components[i];
        }
        return null;
    }

    public Long getProblemID() {
        return this.problemID;
    }

    public String getName() {
        return this.name;
    }

    public RoundModel getRound() {
        return this.roundModel;
    }

    public Integer getDivision() {
        return this.division;
    }

    public Integer getProblemType() {
        return this.problemTypeID;
    }

    public boolean hasComponents() {
        return this.components != null && this.components.length > 0;
    }

    public boolean hasProblemStatement() {
        return this.serverProblemObject != null;
    }

    public boolean hasIntro() {
        return this.serverProblemObject.getProblemText() != null;
    }

    public String getIntro() {
        return this.serverProblemObject.getProblemText();
    }

    public String getProblemStatement() {
        return this.serverProblemObject.getProblemText();
    }

    public String toHTML(Language language) {
        String string = "";
        try {
            string = new ProblemRenderer(this.serverProblemObject).toHTML(language);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public Problem getProblem() {
        return this.serverProblemObject;
    }

    synchronized void notifyListeners() {
        final ProblemModel.Listener[] listenerArray = this.cloneListeners();
        try {
            this.eventService.invokeLater(new Runnable(){

                public void run() {
                    for (int i = listenerArray.length - 1; i >= 0; --i) {
                        listenerArray[i].updateProblemModel(ProblemModelImpl.this);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    synchronized void notifyListenersReadOnly() {
        final ProblemModel.Listener[] listenerArray = this.cloneListeners();
        try {
            this.eventService.invokeLater(new Runnable(){

                public void run() {
                    for (int i = listenerArray.length - 1; i >= 0; --i) {
                        listenerArray[i].updateProblemModelReadOnly(ProblemModelImpl.this);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized ProblemModel.Listener[] cloneListeners() {
        return this.listeners.toArray(new ProblemModel.Listener[this.listeners.size()]);
    }

    public synchronized void addListener(ProblemModel.Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(ProblemModel.Listener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.serverProblemObject = null;
            for (int i = 0; i < this.components.length; ++i) {
                ProblemComponentModelImpl problemComponentModelImpl = this.components[i];
                problemComponentModelImpl.unsetServerComponentObject();
            }
        }
    }

    synchronized void setComponents(ProblemComponentModelImpl[] problemComponentModelImplArray) {
        this.components = problemComponentModelImplArray;
        this.notifyListeners();
    }

    synchronized void setServerProblemObject(Problem problem) {
        if (this.listeners.size() > 0) {
            this.serverProblemObject = problem;
            this.notifyListeners();
        }
    }

    synchronized void setReadOnlyServerProblemObject(Problem problem) {
        if (this.listeners.size() > 0) {
            this.serverProblemObject = problem;
            this.notifyListenersReadOnly();
        }
    }
}

