/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestant.impl;

import com.topcoder.client.connectiontype.ConnectionType;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.impl.ContestantImpl;

class AutoDetectConnectionTask {
    private volatile boolean cancelled;
    private ContestantImpl contestant;
    private Contestant.StatusListener listener;
    private TestConnectionTypeThread testerThread;

    public AutoDetectConnectionTask(ContestantImpl contestantImpl, Contestant.StatusListener statusListener) {
        this.contestant = contestantImpl;
        this.listener = statusListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionType autoDetect() {
        ConnectionType connectionType = null;
        try {
            ConnectionType[] connectionTypeArray = ConnectionType.getAvailableTypes();
            for (int i = 0; !this.cancelled && connectionType == null && i < connectionTypeArray.length; ++i) {
                ConnectionType connectionType2 = connectionTypeArray[i];
                this.listener.updateStatus(connectionType2.getName() + " connection: connecting...");
                connectionType2.select();
                this.testerThread = null;
                try {
                    if (this.contestant.openConnection(connectionType2) && !this.cancelled) {
                        this.testerThread = new TestConnectionTypeThread(connectionType2);
                        this.testerThread.start();
                        this.testerThread.join(5000L);
                        if (this.testerThread.isSuccessful()) {
                            connectionType = connectionType2;
                            continue;
                        }
                        this.listener.updateStatus(connectionType2.getName() + " connection: Failed!");
                        Thread.sleep(500L);
                        continue;
                    }
                    this.listener.updateStatus(connectionType2.getName() + " connection: Failed!");
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                finally {
                    try {
                        if (this.testerThread != null) {
                            this.testerThread.stopTest();
                        }
                        this.contestant.closeConnection();
                    }
                    catch (Exception exception) {
                        connectionType = null;
                    }
                    connectionType2.unselect();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return connectionType;
    }

    public void cancel() {
        this.cancelled = true;
        TestConnectionTypeThread testConnectionTypeThread = this.testerThread;
        if (testConnectionTypeThread != null) {
            testConnectionTypeThread.stopTest();
        }
    }

    private final class TestConnectionTypeThread
    extends Thread {
        private final ConnectionType typeToTest;
        private volatile boolean stopped;
        private volatile boolean successful;

        public TestConnectionTypeThread(ConnectionType connectionType) {
            super("AutoDetect-" + connectionType.getName());
            this.stopped = false;
            this.successful = false;
            this.setDaemon(true);
            this.typeToTest = connectionType;
        }

        public void stopTest() {
            this.stopped = true;
            this.interrupt();
        }

        public void run() {
            if (this.stopped) {
                return;
            }
            try {
                String string = AutoDetectConnectionTask.this.contestant.executeGetCurrentAppletVersion(this.typeToTest);
                if (!(this.stopped || "".equals(string) || "".equals(string = AutoDetectConnectionTask.this.contestant.executeGetCurrentAppletVersion(this.typeToTest)))) {
                    this.successful = true;
                }
            }
            catch (Exception exception) {
                this.successful = false;
            }
        }

        protected boolean isSuccessful() {
            return this.successful;
        }
    }
}

