/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.widgets;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.frames.RoomListFrame;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public final class LeaderBoardButton
extends JButton {
    private ContestApplet ca;
    private LocalPreferences pref;
    private static final String LEADER_BOARD_IMAGE_FILENAME = "applet_leaderboard_button.gif";
    private static final String DISABLED_LEADER_BOARD_IMAGE_FILENAME = "no_applet_leaderboard_button.gif";
    private ImageIcon enabledIcon;
    private ImageIcon disabledIcon;
    private boolean enabled = true;

    public void setButtonEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            this.setIcon(this.enabledIcon);
        } else {
            this.setIcon(this.disabledIcon);
        }
    }

    public LeaderBoardButton(ContestApplet contestApplet) {
        this.ca = contestApplet;
        this.pref = LocalPreferences.getInstance();
        this.enabledIcon = Common.getImage(LEADER_BOARD_IMAGE_FILENAME, this.ca);
        this.disabledIcon = Common.getImage(DISABLED_LEADER_BOARD_IMAGE_FILENAME, this.ca);
        this.setIcon(this.enabledIcon);
        this.setPreferredSize(new Dimension(this.enabledIcon.getIconWidth(), this.enabledIcon.getIconHeight()));
        this.setMaximumSize(new Dimension(this.enabledIcon.getIconWidth(), this.enabledIcon.getIconHeight()));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LeaderBoardButton.this.enabled) {
                    LeaderBoardButton.this.ca.getRequester().requestGetLeaderBoard();
                    RoomListFrame.getInstance(LeaderBoardButton.this.ca).show();
                }
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setToolTipText("Retrieve all Active Room Leaders.");
        this.setMnemonic('l');
        this.setOpaque(false);
    }
}

