/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class ResultDisplayTypeSelectionPanel {
    private ButtonGroup viewGroup;
    private Set resultDisplayTypes;
    private Listener listener;
    private boolean selectedSet = false;

    public ResultDisplayTypeSelectionPanel(UIPage uIPage, RoundModel roundModel, Listener listener) {
        this.listener = listener;
        this.init(roundModel, uIPage);
    }

    private void init(RoundModel roundModel, UIPage uIPage) {
        this.resultDisplayTypes = new HashSet<ResultDisplayType>(Arrays.asList(roundModel.getRoundProperties().getAllowedScoreTypesToShow()));
        this.viewGroup = new ButtonGroup();
        this.addViewButton(this.viewGroup, uIPage, ResultDisplayType.STATUS, "status_button");
        this.addViewButton(this.viewGroup, uIPage, ResultDisplayType.POINTS, "points_button");
        this.addViewButton(this.viewGroup, uIPage, ResultDisplayType.PASSED_TESTS, "passed_tests_button");
    }

    private void addViewButton(ButtonGroup buttonGroup, UIPage uIPage, final ResultDisplayType resultDisplayType, String string) {
        UIComponent uIComponent = uIPage.getComponent(string);
        uIComponent.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultDisplayTypeSelectionPanel.this.listener.typeChanged(resultDisplayType);
            }
        });
        boolean bl = this.resultDisplayTypes.contains(resultDisplayType);
        uIComponent.setProperty("visible", bl);
        uIComponent.setProperty("actionCommand", String.valueOf(resultDisplayType.getId()));
        AbstractButton abstractButton = (AbstractButton)uIComponent.getEventSource();
        buttonGroup.add(abstractButton);
        if (!this.selectedSet && bl) {
            buttonGroup.setSelected(abstractButton.getModel(), true);
            this.selectedSet = true;
        }
    }

    public void setSelectedType(ResultDisplayType resultDisplayType) {
        String string = String.valueOf(resultDisplayType.getId());
        Enumeration<AbstractButton> enumeration = this.viewGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ButtonModel buttonModel = enumeration.nextElement().getModel();
            if (!buttonModel.getActionCommand().equals(string)) continue;
            this.viewGroup.setSelected(buttonModel, true);
        }
    }

    public ResultDisplayType getSelectedType() {
        return ResultDisplayType.get(Integer.parseInt(this.viewGroup.getSelection().getActionCommand()));
    }

    public static interface Listener {
        public void typeChanged(ResultDisplayType var1);
    }
}

