/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.uilogic.panels.UserTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserTableModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIMouseAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RegistrantsTablePanel
extends UserTablePanel {
    private JFrame jf = null;
    private UIComponent totalLabel;
    private UIComponent div1Label;
    private UIComponent div2Label;
    private UIComponent newbieLabel;

    protected String getTablePanelName() {
        return "registrants_table_panel";
    }

    protected String getTableName() {
        return "registrants_table";
    }

    protected String getMenuName() {
        return "registrants_table_menu";
    }

    public RegistrantsTablePanel(ContestApplet contestApplet, UIPage uIPage, JFrame jFrame) {
        super(contestApplet, uIPage, new UserTableModel(contestApplet.getModel(), CommonData.registrantsHeader), "registrants_user_renderer", "registrants_header_renderer");
        uIPage.getComponent("registrants_table_menu_info").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegistrantsTablePanel.this.infoPopupEvent();
            }
        });
        this.jf = jFrame;
        this.totalLabel = uIPage.getComponent("total_label");
        this.div1Label = uIPage.getComponent("div1_label");
        this.div2Label = uIPage.getComponent("div2_label");
        this.newbieLabel = uIPage.getComponent("newbie_label");
        this.userTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                RegistrantsTablePanel.this.tableCountEvent();
            }
        });
        this.table.addEventListener("Mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                RegistrantsTablePanel.this.doubleClickEvent(mouseEvent);
            }
        });
        this.userTableModel.sort(0, false);
    }

    public int getRowCount() {
        return (Integer)this.table.getProperty("RowCount");
    }

    protected void tableCountEvent() {
        ((TitledBorder)this.tablePanel.getProperty("Border")).setTitle("");
        if (this.totalLabel != null) {
            this.totalLabel.setProperty("Text", "Total registered [" + this.getRowCount() + "]");
            this.div1Label.setProperty("Text", "Div 1 [" + this.getDiv1Count() + "]");
            this.div2Label.setProperty("Text", "Div 2 [" + this.getDiv2Count() + "]");
            this.newbieLabel.setProperty("Text", "New [" + this.getNewCount() + "]");
        }
        this.tablePanel.performAction("revalidate");
        this.tablePanel.performAction("repaint");
    }

    public int getDiv1Count() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(i), new Integer(1)})).getRank() < 1200) continue;
            ++n;
        }
        return n;
    }

    public int getDiv2Count() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(i), new Integer(1)})).getRank() >= 1200 || ((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(i), new Integer(1)})).getRank() == 0) continue;
            ++n;
        }
        return n;
    }

    public int getNewCount() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(i), new Integer(1)})).getRank() != 0) continue;
            ++n;
        }
        return n;
    }

    protected void doubleClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        if (this.isPanelEnabled()) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showContestPopup(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.infoPopupEvent();
            }
        }
    }

    protected void infoPopupEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        String string = ((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(n), new Integer(1)})).getName();
        this.ca.setCurrentFrame(this.jf);
        this.ca.requestCoderInfo(string, ((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(n), new Integer(1)})).getUserType());
    }
}

