/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.components.LongCodeViewer;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.LanguageColoringDecoratorRenderer;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.uilogic.panels.table.ValueTransformDecoratorCellRenderer;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.impl.LongCoderComponentImpl;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LongSummaryTablePanel
extends AbstractSummaryTablePanel {
    private static final int EXAMPLE_COUNT_COLUMN = 8;
    private static final int SUBMISSION_COUNT_COLUMN = 6;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private final ContestApplet ca;
    private final RoomModel room;
    private UIPage page;
    private TableModelListener tableModelListener;
    private ChallengeTableModel tableModel;
    private UIComponent table;
    private UIComponent submissionPopup;
    private UIComponent otherContestPopup;
    private UIComponent endedContestPopup;
    private Class[] tableModelClasses;
    private String[] tableModelHeaders;
    private boolean enabled = true;
    private FrameLogic frame = null;
    private boolean update;
    private LongCodeViewer viewer;
    private boolean endedContestLayout;
    private List tableColumns;
    private UIComponent panel;

    public LongSummaryTablePanel(ContestApplet contestApplet, RoomModel roomModel, FrameLogic frameLogic, boolean bl, UIPage uIPage) {
        this.page = uIPage;
        this.ca = contestApplet;
        this.room = roomModel;
        this.update = bl;
        this.frame = frameLogic;
        this.panel = uIPage.getComponent("long_summary_table_panel");
        this.table = uIPage.getComponent("long_summary_table");
        this.submissionPopup = uIPage.getComponent("long_submission_popup");
        this.otherContestPopup = uIPage.getComponent("long_other_contest_popup");
        this.endedContestPopup = uIPage.getComponent("long_ended_contest_popup");
        uIPage.getComponent("long_other_info_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.infoPopupEvent();
            }
        });
        uIPage.getComponent("long_other_history_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.historyPopupEvent(1);
            }
        });
        uIPage.getComponent("long_other_submission_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.historyPopupEvent(2);
            }
        });
        uIPage.getComponent("long_other_example_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.historyPopupEvent(3);
            }
        });
        uIPage.getComponent("long_ended_info_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.infoPopupEvent();
            }
        });
        uIPage.getComponent("long_ended_history_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.historyPopupEvent(1);
            }
        });
        uIPage.getComponent("long_ended_submission_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.historyPopupEvent(2);
            }
        });
        uIPage.getComponent("long_ended_example_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.historyPopupEvent(3);
            }
        });
        uIPage.getComponent("long_ended_results_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.systemTestResultsEvent();
            }
        });
        uIPage.getComponent("long_source_menu").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongSummaryTablePanel.this.sourcePopupEvent();
            }
        });
        TableColumnModel tableColumnModel = (TableColumnModel)this.table.getProperty("columnmodel");
        this.tableColumns = new ArrayList();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            this.tableColumns.add(enumeration.nextElement());
        }
        this.tableModelListener = new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                LongSummaryTablePanel.this.updateRoomLeader();
            }
        };
        this.createTable();
        this.initTable();
    }

    private void initTable() {
        TableColumnModel tableColumnModel = (TableColumnModel)this.table.getProperty("columnmodel");
        Iterator iterator = this.tableColumns.iterator();
        while (iterator.hasNext()) {
            tableColumnModel.removeColumn((TableColumn)iterator.next());
        }
        iterator = this.tableColumns.iterator();
        while (iterator.hasNext()) {
            tableColumnModel.addColumn((TableColumn)iterator.next());
        }
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
            this.tableModel = null;
        }
        this.prepareForTableModel();
        this.tableModel = new ChallengeTableModel();
        this.tableModel.addTableModelListener(this.tableModelListener);
        if (!this.endedContestLayout) {
            this.table.performAction("removeColumn", new Object[]{this.table.performAction("getColumn", new Object[]{"final_score"})});
        }
        this.table.setProperty("model", this.tableModel);
    }

    private void reinitTable() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LongSummaryTablePanel.this.initTable();
                    LongSummaryTablePanel.this.panel.performAction("invalidate");
                    LongSummaryTablePanel.this.panel.performAction("repaint");
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected boolean isEndedContestLayout() {
        return this.endedContestLayout;
    }

    protected boolean isContestEnded() {
        return this.room.getRoundModel().getPhase() == 9;
    }

    private int fixedColIndex(int n) {
        if (n >= 4 && !this.isEndedContestLayout()) {
            return n + 1;
        }
        return n;
    }

    private void createTable() {
        String string = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        this.page.getComponent("long_summary_table_header_renderer").setProperty("font", new Font(string, 0, n));
        this.page.getComponent("long_summary_table_header_center_renderer").setProperty("font", new Font(string, 0, n));
        this.page.getComponent("long_summary_user_renderer").setProperty("font", new Font(string, 0, n));
        this.page.getComponent("long_summary_user_renderer").setProperty("model", this.ca.getModel());
        this.page.getComponent("long_summary_cell_renderer").setProperty("fontName", string);
        this.page.getComponent("long_summary_cell_renderer").setProperty("fontSize", new Integer(n));
        this.page.getComponent("long_summary_nocolor_cell_renderer").setProperty("fontName", string);
        this.page.getComponent("long_summary_nocolor_cell_renderer").setProperty("fontSize", new Integer(n));
        this.page.getComponent("long_summary_cell_rightaligned_renderer").setProperty("fontName", string);
        this.page.getComponent("long_summary_cell_rightaligned_renderer").setProperty("fontSize", new Integer(n));
        this.page.getComponent("long_summary_cell_center_renderer").setProperty("fontName", string);
        this.page.getComponent("long_summary_cell_center_renderer").setProperty("fontSize", new Integer(n));
        final DecimalFormat decimalFormat = new DecimalFormat("0.00");
        this.page.getComponent("long_summary_status_column").setProperty("CellRenderer", new LanguageColoringDecoratorRenderer(new ValueTransformDecoratorCellRenderer((TableCellRenderer)this.page.getComponent("long_summary_status_column").getProperty("CellRenderer")){

            protected Object transform(Object object, int n, int n2) {
                int n3 = (Integer)object;
                switch (n3) {
                    case 110: {
                        return "Unopened";
                    }
                    case 120: {
                        return "Opened";
                    }
                    case 121: {
                        return "Compiled";
                    }
                    case 130: {
                        return "Pending tests";
                    }
                    case 150: {
                        return "Test completed";
                    }
                }
                throw new IllegalStateException("Invalid component state: " + n3);
            }
        }){

            protected Integer getLanguage(Object object, int n, int n2) {
                Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                return coder.getComponents()[0].getLanguageID();
            }
        });
        this.page.getComponent("long_summary_final_score_column").setProperty("CellRenderer", new LanguageColoringDecoratorRenderer(new ValueTransformDecoratorCellRenderer((TableCellRenderer)this.page.getComponent("long_summary_final_score_column").getProperty("CellRenderer")){

            protected Object transform(Object object, int n, int n2) {
                if (object == null) {
                    return null;
                }
                return decimalFormat.format(object);
            }
        }){

            protected Integer getLanguage(Object object, int n, int n2) {
                Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                return coder.getComponents()[0].getLanguageID();
            }
        });
        this.page.getComponent("long_summary_score_column").setProperty("CellRenderer", new LanguageColoringDecoratorRenderer(new ValueTransformDecoratorCellRenderer((TableCellRenderer)this.page.getComponent("long_summary_score_column").getProperty("CellRenderer")){

            protected Object transform(Object object, int n, int n2) {
                if (object == null) {
                    return null;
                }
                return decimalFormat.format(object);
            }
        }){

            protected Integer getLanguage(Object object, int n, int n2) {
                Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                return coder.getComponents()[0].getLanguageID();
            }
        });
        this.page.getComponent("long_summary_submissions_column").setProperty("CellRenderer", new LanguageColoringDecoratorRenderer((TableCellRenderer)this.page.getComponent("long_summary_submissions_column").getProperty("CellRenderer")){

            protected Integer getLanguage(Object object, int n, int n2) {
                Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                return coder.getComponents()[0].getLanguageID();
            }
        });
        this.page.getComponent("long_summary_last_submission_column").setProperty("CellRenderer", new LanguageColoringDecoratorRenderer(new ValueTransformDecoratorCellRenderer((TableCellRenderer)this.page.getComponent("long_summary_last_submission_column").getProperty("CellRenderer")){

            protected Object transform(Object object, int n, int n2) {
                if (object == null) {
                    return null;
                }
                return LongSummaryTablePanel.this.dateFormat.format(object);
            }
        }){

            protected Integer getLanguage(Object object, int n, int n2) {
                Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                return coder.getComponents()[0].getLanguageID();
            }
        });
        this.page.getComponent("long_summary_examples_column").setProperty("CellRenderer", new LanguageColoringDecoratorRenderer((TableCellRenderer)this.page.getComponent("long_summary_examples_column").getProperty("CellRenderer")){

            protected Integer getLanguage(Object object, int n, int n2) {
                Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                return coder.getComponents()[0].getLanguageID();
            }
        });
        this.page.getComponent("long_summary_last_example_column").setProperty("CellRenderer", new LanguageColoringDecoratorRenderer(new ValueTransformDecoratorCellRenderer((TableCellRenderer)this.page.getComponent("long_summary_last_example_column").getProperty("CellRenderer")){

            protected Object transform(Object object, int n, int n2) {
                if (object == null) {
                    return null;
                }
                return LongSummaryTablePanel.this.dateFormat.format(object);
            }
        }){

            protected Integer getLanguage(Object object, int n, int n2) {
                Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                return coder.getComponents()[0].getLanguageID();
            }
        });
        this.table.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (LongSummaryTablePanel.this.enabled) {
                    LongSummaryTablePanel.this.mouseClickEvent(mouseEvent);
                    LongSummaryTablePanel.this.otherMouseClickEvent(mouseEvent);
                }
            }
        });
        ((JTableHeader)this.table.getProperty("TableHeader")).addMouseListener(new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LongSummaryTablePanel.this.headerClickEvent(mouseEvent);
            }
        });
    }

    private void showSubmissionPopup(MouseEvent mouseEvent) {
        this.submissionPopup.performAction("show", new Object[]{mouseEvent.getComponent(), new Integer(mouseEvent.getX()), new Integer(mouseEvent.getY())});
    }

    public UIComponent getTable() {
        return this.table;
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        Coder coder;
        CoderComponent coderComponent;
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        int n3 = this.fixedColIndex(n2);
        if ((n3 == 6 || n3 == 8) && (coderComponent = (coder = this.tableModel.getCoder(n)).getComponents()[0]) != null && coderComponent.getStatus() >= 120) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showSubmissionPopup(mouseEvent);
            } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.sourcePopupEvent();
            }
        }
    }

    private void otherMouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        int n3 = this.fixedColIndex(n2);
        if (n3 != 6 && n3 != 8) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (this.isEndedContestLayout()) {
                    this.endedContestPopup.performAction("show", new Object[]{mouseEvent.getComponent(), new Integer(mouseEvent.getX()), new Integer(mouseEvent.getY())});
                } else {
                    this.otherContestPopup.performAction("show", new Object[]{mouseEvent.getComponent(), new Integer(mouseEvent.getX()), new Integer(mouseEvent.getY())});
                }
            } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.infoPopupEvent();
            }
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = ((JTableHeader)this.table.getProperty("TableHeader")).columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            n = ((TableColumnModel)this.table.getProperty("ColumnModel")).getColumn(n).getModelIndex();
            this.tableModel.sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.table.performAction("repaint");
        }
    }

    private void infoPopupEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        String string = ((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(n), new Integer(2)})).getName();
        this.ca.setCurrentFrame((JFrame)this.frame.getFrame().getEventSource());
        this.ca.requestCoderInfo(string, ((UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(n), new Integer(2)})).getUserType());
    }

    private void sourcePopupEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        int n2 = (Integer)this.table.getProperty("SelectedColumn");
        int n3 = this.fixedColIndex(n2);
        if (n3 == 6 || n3 == 8) {
            Coder coder = this.tableModel.getCoder(n);
            int n4 = (Integer)this.tableModel.getValueAt(n, n3);
            if (n4 == 0) {
                return;
            }
            if (this.viewer != null) {
                this.closeSourceViewer();
            }
            this.viewer = new LongCodeViewer(this.ca, (JFrame)this.frame.getFrame().getEventSource(), this.room.getRoundModel().getRoundID().intValue(), coder.getHandle(), coder.getComponents()[0].getComponent().getID().intValue(), n3 == 8, n4, true);
            this.viewer.show();
        }
    }

    private void updateRoomLeader() {
        this.tableModel.updateRoomLeader();
        this.panel.performAction("repaint");
    }

    private void historyPopupEvent(int n) {
        int n2 = (Integer)this.table.getProperty("SelectedRow");
        if (n2 >= 0) {
            String string = this.tableModel.getCoder(n2).getHandle();
            this.ca.setCurrentFrame((JFrame)this.frame.getFrame().getEventSource());
            if (n == 1) {
                this.ca.requestCoderHistory(string, this.room.getRoomID(), this.tableModel.getCoder(n2).getUserType());
            } else if (n == 2) {
                this.ca.requestSubmissionHistory(string, this.room.getRoomID(), this.tableModel.getCoder(n2).getUserType(), false);
            } else {
                this.ca.requestSubmissionHistory(string, this.room.getRoomID(), this.tableModel.getCoder(n2).getUserType(), true);
            }
        }
    }

    private void systemTestResultsEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        if (n >= 0) {
            Coder coder = this.tableModel.getCoder(n);
            String string = coder.getHandle();
            this.ca.setCurrentFrame((JFrame)this.frame.getFrame().getEventSource());
            this.ca.getInterFrame().showMessage("Fetching results...", (JFrame)this.frame.getFrame().getEventSource(), 120);
            this.ca.getRequester().requestLongTestResults(coder.getComponents()[0].getComponent().getID(), this.room.getRoomID(), string, 2);
        }
    }

    private void prepareForTableModel() {
        if (!this.room.hasRoundModel()) {
            throw new IllegalStateException("Can't build challenge table model, no round for room: " + this.room);
        }
        RoundModel roundModel = this.room.getRoundModel();
        if (!roundModel.hasProblems(this.room.getDivisionID())) {
            throw new IllegalStateException("Can't build challenge table model, no problems for round: " + roundModel);
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(Integer.class);
        arrayList2.add("Place");
        arrayList.add(Integer.class);
        arrayList2.add("R");
        arrayList.add(UserNameEntry.class);
        arrayList2.add("Handle");
        arrayList.add(String.class);
        arrayList2.add("Status");
        arrayList.add(Double.class);
        this.endedContestLayout = false;
        if (this.isContestEnded()) {
            this.endedContestLayout = true;
        }
        arrayList2.add("Final Score");
        arrayList.add(Double.class);
        arrayList2.add("Score");
        arrayList.add(Integer.class);
        arrayList2.add("Submissions");
        arrayList.add(String.class);
        arrayList2.add("Last submission");
        arrayList.add(Integer.class);
        arrayList2.add("Examples");
        arrayList.add(String.class);
        arrayList2.add("Last example");
        this.tableModelClasses = arrayList.toArray(new Class[0]);
        this.tableModelHeaders = arrayList2.toArray(new String[0]);
    }

    public void updateChallengeTable(RoomModel roomModel) {
        if (this.room != roomModel) {
            throw new IllegalStateException("Got event for unrecognized room: " + roomModel);
        }
        if (this.isEndedContestLayout() ^ this.isContestEnded()) {
            this.reinitTable();
        }
        this.tableModel.updateChallengeTable();
    }

    public void closeSourceViewer() {
        if (this.viewer != null) {
            this.viewer.close();
            this.viewer = null;
        }
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public void updateView(ResultDisplayType resultDisplayType) {
    }

    private final class RankComparator
    implements Comparator {
        private RankComparator() {
        }

        public int compare(Object object, Object object2) {
            Double d = (Double)object;
            Double d2 = (Double)object2;
            double d3 = d - d2;
            if (d3 != 0.0) {
                return -1 * (d3 > 0.0 ? 1 : -1);
            }
            return 0;
        }

        protected int compareStrings(String string, String string2) {
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private final class ChallengeTableModel
    extends SortedTableModel
    implements Coder.Listener {
        private List coderList;
        private RankComparator rankCompare;

        private ChallengeTableModel() {
            super(LongSummaryTablePanel.this.tableModelHeaders, LongSummaryTablePanel.this.tableModelClasses);
            this.coderList = new ArrayList();
            this.rankCompare = new RankComparator();
            for (int i = 0; i < 10; ++i) {
                this.addSortElement(new SortElement(i, false));
            }
            this.updateChallengeTable();
        }

        private void updateChallengeTable() {
            if (!LongSummaryTablePanel.this.update) {
                return;
            }
            if (!LongSummaryTablePanel.this.room.hasCoders()) {
                throw new IllegalStateException("No coders for room: " + LongSummaryTablePanel.this.room);
            }
            Coder[] coderArray = LongSummaryTablePanel.this.room.getCoders();
            for (int i = 0; i < coderArray.length; ++i) {
                coderArray[i].addListener(this);
            }
            this.update(Arrays.asList(coderArray));
            this.updateRoomLeader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateRoomLeader() {
            if (!LongSummaryTablePanel.this.update) {
                return;
            }
            List list = this.coderList;
            synchronized (list) {
                List list2 = (List)this.getItemList();
                this.coderList.clear();
                for (int i = 0; i < list2.size(); ++i) {
                    Coder coder = (Coder)list2.get(i);
                    this.coderList.add(this.getRelevantScoreForStatus(coder));
                }
                Collections.sort(this.coderList, this.rankCompare);
                this.sort();
            }
        }

        public int getCoderRank(Coder coder) {
            if (this.coderList == null) {
                return 1;
            }
            for (int i = 0; i < this.coderList.size(); ++i) {
                Double d = this.getRelevantScoreForStatus(coder);
                Double d2 = (Double)this.coderList.get(i);
                if (d.doubleValue() != d2.doubleValue()) continue;
                return i + 1;
            }
            return -1;
        }

        public void coderEvent(Coder coder) {
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            Coder coder = this.getCoder(n);
            return this.getColValue(coder, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getColValue(Coder coder, int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    List list = this.coderList;
                    synchronized (list) {
                        return new Integer(this.getCoderRank(coder));
                    }
                }
                case 1: {
                    return coder.getRating();
                }
                case 2: {
                    return new UserNameEntry(coder.getHandle(), coder.getRating(), LongSummaryTablePanel.this.room.hasLeader() && LongSummaryTablePanel.this.room.getLeader().getUserName().equals(coder.getHandle()), coder.getUserType());
                }
                case 3: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return longCoderComponentImpl.getStatus();
                }
                case 4: {
                    return coder.getFinalScore() == null ? null : new Double(coder.getFinalScore() / 100.0);
                }
                case 5: {
                    return new Double(coder.getScore() / 100.0);
                }
                case 6: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return new Integer(longCoderComponentImpl.getSubmissionCount());
                }
                case 7: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return longCoderComponentImpl.getLastSubmissionTime() == 0L ? null : new Date(longCoderComponentImpl.getLastSubmissionTime());
                }
                case 8: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return new Integer(longCoderComponentImpl.getExampleSubmissionCount());
                }
                case 9: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return longCoderComponentImpl.getExampleLastSubmissionTime() == 0L ? null : new Date(longCoderComponentImpl.getExampleLastSubmissionTime());
                }
            }
            return null;
        }

        private Double getRelevantScoreForStatus(Coder coder) {
            if (LongSummaryTablePanel.this.isEndedContestLayout()) {
                return coder.getFinalScore();
            }
            return coder.getScore();
        }

        Coder getCoder(int n) {
            return (Coder)this.get(n);
        }

        public int compare(Object object, Object object2) {
            Coder coder = (Coder)object;
            Coder coder2 = (Coder)object2;
            Iterator iterator = this.getSortListIterator();
            while (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n = sortElement.getColumn();
                int n2 = sortElement.isOpposite() ? -1 : 1;
                Comparable comparable = (Comparable)this.getColValue(coder, n);
                Comparable comparable2 = (Comparable)this.getColValue(coder2, n);
                int n3 = 0;
                if (comparable != null) {
                    n3 = comparable2 != null ? comparable.compareTo(comparable2) : 1;
                } else if (comparable2 != null) {
                    n3 = -1;
                }
                if (n3 == 0) continue;
                return n2 * n3;
            }
            return 0;
        }
    }
}

