/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.panels.HTMLPanel;
import com.topcoder.netCommon.contestantMessages.UserInfo;
import java.util.Properties;
import javax.swing.JPanel;

public class IntermissionPanelManager {
    public static final int DEFAULT_INTERMISSION_PANEL = 0;
    public static final int LOGIN_INTERMISSION_PANEL = 1;
    public static final int MOVE_INTERMISSION_PANEL = 2;
    private HTMLPanel defaultPanel;
    private HTMLPanel ratedLoginPanel;
    private HTMLPanel unratedLoginPanel;
    private HTMLPanel firstTimeLoginPanel;
    private HTMLPanel ratedMovePanel;
    private HTMLPanel unratedMovePanel;
    private HTMLPanel firstTimeMovePanel;
    private ContestApplet ca;

    public IntermissionPanelManager(ContestApplet contestApplet) {
        this.ca = contestApplet;
        try {
            this.defaultPanel = new HTMLPanel("images/default.html", this.ca);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.unratedLoginPanel = this.firstTimeLoginPanel = this.defaultPanel;
        this.ratedLoginPanel = this.firstTimeLoginPanel;
        this.unratedMovePanel = this.firstTimeLoginPanel;
        this.ratedMovePanel = this.firstTimeLoginPanel;
        this.firstTimeMovePanel = this.firstTimeLoginPanel;
        Properties properties = new Properties();
        String string = "intermission.properties";
        try {
            properties.load(IntermissionPanelManager.class.getClassLoader().getResourceAsStream(string));
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string);
            exception.printStackTrace();
            return;
        }
        String string2 = properties.getProperty("URLBase");
        String string3 = properties.getProperty("ratedLoginPage");
        try {
            this.ratedLoginPanel = new HTMLPanel(string2 + string3, this.ca);
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string2 + string3);
            exception.printStackTrace();
        }
        string3 = properties.getProperty("unratedLoginPage");
        try {
            this.unratedLoginPanel = new HTMLPanel(string2 + string3, this.ca);
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string2 + string3);
            exception.printStackTrace();
        }
        string3 = properties.getProperty("firstTimeLoginPage");
        try {
            this.firstTimeLoginPanel = new HTMLPanel(string2 + string3, this.ca);
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string2 + string3);
            exception.printStackTrace();
        }
        string3 = properties.getProperty("unratedMovePage");
        try {
            this.unratedMovePanel = new HTMLPanel(string2 + string3, this.ca);
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string2 + string3);
            exception.printStackTrace();
        }
        string3 = properties.getProperty("ratedMovePage");
        try {
            this.ratedMovePanel = new HTMLPanel(string2 + string3, this.ca);
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string3);
            exception.printStackTrace();
        }
        string3 = properties.getProperty("firstTimeMovePage");
        try {
            this.firstTimeMovePanel = new HTMLPanel(string2 + string3, this.ca);
        }
        catch (Exception exception) {
            System.err.println("Error loading " + string3);
            exception.printStackTrace();
        }
    }

    public JPanel getIntermissionPanel(int n) {
        UserInfo userInfo = this.ca.getModel().getUserInfo();
        HTMLPanel hTMLPanel = null;
        switch (n) {
            case 1: {
                if (userInfo.isFirstTimeUser()) {
                    hTMLPanel = this.firstTimeLoginPanel;
                    break;
                }
                if (userInfo.getRating() > 0) {
                    hTMLPanel = this.ratedLoginPanel;
                    break;
                }
                hTMLPanel = this.unratedLoginPanel;
                break;
            }
            case 2: {
                if (userInfo.isFirstTimeUser()) {
                    hTMLPanel = this.firstTimeMovePanel;
                    break;
                }
                if (userInfo.getRating() > 0) {
                    hTMLPanel = this.ratedMovePanel;
                    break;
                }
                hTMLPanel = this.unratedMovePanel;
                break;
            }
            default: {
                hTMLPanel = this.defaultPanel;
            }
        }
        hTMLPanel.replaceVariables(new String[]{"$USERNAME", "$RATING", "$NUMRATEDEVENTS", "$LASTLOGIN"}, new String[]{userInfo.getHandle(), "" + userInfo.getRating(), "" + userInfo.getNumRatedEvents(), userInfo.isFirstTimeUser() ? "" : Common.formatTime(userInfo.getLastLogin())});
        return hTMLPanel.getPanel();
    }
}

