/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLPanel {
    private UIComponent pane;
    private String html;
    private UIPage page;

    public HTMLPanel(ContestApplet contestApplet) {
        this.page = contestApplet.getCurrentUIManager().getUIPage("html_panel", true);
        this.pane = this.page.getComponent("html_panel_editor_pane");
    }

    public HTMLPanel(String string, ContestApplet contestApplet) throws Exception {
        this(contestApplet);
        this.load(string, contestApplet);
    }

    public JPanel getPanel() {
        return (JPanel)this.page.getComponent("root_panel").getEventSource();
    }

    public void load(String string) throws Exception {
        this.load(string, this);
    }

    public void load(String string, Object object) throws Exception {
        URL uRL = string.startsWith("http:") || string.startsWith("file:") ? new URL(string) : object.getClass().getResource(string);
        this.load(uRL);
    }

    public void load(URL uRL) throws Exception {
        String string = uRL.toString();
        URL uRL2 = new URL(string.substring(0, string.lastIndexOf(47) + 1));
        this.html = HTMLPanel.read(uRL);
        SynchronousHTMLEditorKit synchronousHTMLEditorKit = new SynchronousHTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)((HTMLEditorKit)synchronousHTMLEditorKit).createDefaultDocument();
        hTMLDocument.setBase(uRL2);
        synchronousHTMLEditorKit.read(new StringReader(this.html), (Document)hTMLDocument, 0);
        this.pane.setProperty("EditorKit", synchronousHTMLEditorKit);
        this.pane.setProperty("Document", hTMLDocument);
    }

    private static String read(URL uRL) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        StringBuffer stringBuffer = new StringBuffer(1000);
        char[] cArray = new char[1000];
        int n = 0;
        while ((n = bufferedReader.read(cArray, 0, cArray.length)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public void replaceVariables(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer(this.html);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            block1: for (int j = 0; j < stringBuffer.length(); ++j) {
                for (int k = 0; k < string.length(); ++k) {
                    if (stringBuffer.charAt(j + k) != string.charAt(k)) continue block1;
                }
                stringBuffer.replace(j, j + string.length(), string2);
                j += string2.length() - 1;
            }
        }
        this.pane.setProperty("text", stringBuffer.toString());
        this.pane.performAction("revalidate");
        this.pane.performAction("repaint");
    }

    static class SynchronousHTMLEditorKit
    extends HTMLEditorKit {
        SynchronousHTMLEditorKit() {
        }

        public Document createDefaultDocument() {
            HTMLDocument hTMLDocument = (HTMLDocument)super.createDefaultDocument();
            hTMLDocument.setAsynchronousLoadPriority(-1);
            return hTMLDocument;
        }
    }
}

