/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.ui.UIComponent;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;

public class ContestSponsorPanel {
    private LoadThread loadLogo;

    public ContestSponsorPanel(UIComponent uIComponent, String string) {
        WeakReference<UIComponent> weakReference = new WeakReference<UIComponent>(uIComponent);
        this.loadLogo = new LoadThread(weakReference, string);
        this.loadLogo.setName("SponsorLogo LoadThread");
        this.loadLogo.setDaemon(true);
        this.loadLogo.start();
    }

    protected void finalize() throws Throwable {
        LoadThread loadThread = this.loadLogo;
        if (loadThread != null) {
            loadThread.interrupt();
        }
    }

    public void updateURL(String string) {
        this.loadLogo.updateURL(string);
    }

    private static class LoadThread
    extends Thread {
        private static final long REFRESHTIME = 900000L;
        private final WeakReference sponsorLogoRef;
        private final Object mutex = new Object();
        private String imageAddr;
        private boolean mustReload = false;

        public LoadThread(WeakReference weakReference, String string) {
            this.sponsorLogoRef = weakReference;
            this.imageAddr = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                URL uRL;
                Object object = this.mutex;
                synchronized (object) {
                    try {
                        this.mustReload = false;
                        uRL = new URL(this.imageAddr);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return;
                    }
                }
                object = Toolkit.getDefaultToolkit().getImage(uRL);
                UIComponent uIComponent = (UIComponent)this.sponsorLogoRef.get();
                if (uIComponent == null) {
                    return;
                }
                MediaTracker mediaTracker = new MediaTracker((Component)uIComponent.getEventSource());
                boolean bl = true;
                mediaTracker.addImage((Image)object, 1);
                try {
                    mediaTracker.waitForID(1);
                    if (mediaTracker.statusID(1, true) != 8) {
                        mediaTracker.waitForID(1);
                    }
                    uIComponent.setProperty("icon", new ImageIcon((Image)object));
                    uIComponent.performAction("invalidate");
                    uIComponent.performAction("revalidate");
                    uIComponent.performAction("repaint");
                    object = null;
                    mediaTracker = null;
                    uIComponent = null;
                    Object object2 = this.mutex;
                    synchronized (object2) {
                        if (!this.mustReload) {
                            this.mutex.wait(900000L);
                        }
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateURL(String string) {
            Object object = this.mutex;
            synchronized (object) {
                this.imageAddr = string;
                this.mustReload = true;
                this.mutex.notifyAll();
            }
        }
    }
}

