/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.BaseAlgoSummaryTablePanel;
import com.topcoder.client.contestApplet.widgets.AlgorithmCoderComponentRenderer;
import com.topcoder.client.contestApplet.widgets.ContestTableCellRenderer;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import java.awt.Font;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ChallengeTablePanel
extends BaseAlgoSummaryTablePanel {
    private final RoomModel roomModel;

    public ChallengeTablePanel(ContestApplet contestApplet, RoomModel roomModel, FrameLogic frameLogic, UIPage uIPage) {
        super(contestApplet, frameLogic, true, uIPage);
        this.roomModel = roomModel;
        this.init(uIPage.getComponent("challenge_popup"), uIPage.getComponent("other_challenge_popup"), uIPage.getComponent("challenge_table"), uIPage.getComponent("challenge_table_panel"), uIPage.getComponent("source_menu"), uIPage.getComponent("info_menu"), uIPage.getComponent("history_menu"));
    }

    protected void initTable() {
        String string = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        this.page.getComponent("challenge_table_header_renderer").setProperty("font", new Font(string, 0, n));
        this.page.getComponent("user_renderer").setProperty("font", new Font(string, 0, n));
        this.page.getComponent("user_renderer").setProperty("model", this.ca.getModel());
        this.page.getComponent("base_problem_renderer").setProperty("fontName", string);
        this.page.getComponent("base_problem_renderer").setProperty("fontSize", new Integer(n));
        this.page.getComponent("contest_table_cell_renderer").setProperty("fontName", string);
        this.page.getComponent("contest_table_cell_renderer").setProperty("fontSize", new Integer(n));
        UIComponent uIComponent = this.page.getComponent("challenge_problem_column_template");
        uIComponent.setProperty("CellRenderer", new AlgorithmCoderComponentRenderer((ContestTableCellRenderer)this.page.getComponent("base_problem_renderer").getEventSource(), this.getRoundModel()));
        this.table.setProperty("model", this.tableModel);
        int n2 = this.tableModel.getColumnCount();
        int n3 = this.getMaxProblemColumn();
        if (!this.hasFinalScoreColumn()) {
            this.table.performAction("removeColumn", new Object[]{this.page.getComponent("challenge_score_column").getEventSource()});
        } else {
            this.page.getComponent("challenge_score_column").setProperty("modelindex", new Integer(n2 - 1));
        }
        for (int i = 3; i < n3; ++i) {
            TableColumn tableColumn = (TableColumn)uIComponent.performAction("clone");
            tableColumn.setModelIndex(i);
            this.table.performAction("addColumn", new Object[]{tableColumn});
            if (this.hasFinalScoreColumn()) {
                this.table.performAction("moveColumn", new Object[]{new Integer(i + 1), new Integer(i)});
            }
            tableColumn.setHeaderRenderer((TableCellRenderer)uIComponent.getProperty("headerRenderer"));
        }
    }

    protected RoundModel getRoundModel() {
        if (!this.roomModel.hasRoundModel()) {
            throw new IllegalStateException("Can't build challenge table model, no round for room: " + this.roomModel);
        }
        return this.roomModel.getRoundModel();
    }

    protected Integer getDivisionID() {
        return this.roomModel.getDivisionID();
    }

    protected boolean isRoomLeader(String string) {
        return this.roomModel.getLeader().getUserName().equals(string);
    }

    protected Collection getCoders() {
        if (!this.roomModel.hasCoders()) {
            throw new IllegalStateException("No coders for room: " + this.roomModel);
        }
        return Arrays.asList(this.roomModel.getCoders());
    }

    protected RoomModel getRoomByCoder(String string) {
        return this.roomModel;
    }

    public void updateChallengeTable(RoomModel roomModel) {
        if (this.roomModel != roomModel) {
            throw new IllegalStateException("Got event for unrecognized room: " + roomModel);
        }
        this.getTableModel().updateChallengeTable();
    }
}

