/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ChallengeConfigurationPanel {
    private UIPage page;
    private FrameLogic parent;
    private UIComponent probPreview;
    private String probPreviewStr = "PROBLEM STATEMENT\nWe're looking for a value.\nDEFINITION\nClass: Returner\nMethod: zero\nReturns: int";
    private UIComponent coderInfoPreview;
    private String coderInfoPreviewStr = "public class Returner {\npublic int zero() {\n// Uh, return?\nreturn 0;\n}\n}";
    private MutableAttributeSet attr = new SimpleAttributeSet();
    private ActionHandler handler = new ActionHandler();
    private UIComponent probFonts;
    private UIComponent probFontSizes;
    private UIComponent probFixedFonts;
    private UIComponent probFixedFontSizes;
    private UIComponent messageFonts;
    private UIComponent messageFontSizes;
    private HashMap map = new HashMap();
    int r;
    private boolean changesPending = false;
    private LocalPreferences localPref = LocalPreferences.getInstance();

    public ChallengeConfigurationPanel(FrameLogic frameLogic, UIPage uIPage) {
        this.page = uIPage;
        this.parent = frameLogic;
        Vector vector = Common.enumerateFonts();
        Object[] objectArray = new Object[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24"};
        this.probPreview = uIPage.getComponent("challenge_problem_preview_pane");
        this.coderInfoPreview = uIPage.getComponent("challenge_source_preview_pane");
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfore"), "challenge_problem_foreground_button"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobback"), "challenge_problem_background_button"));
        this.probFonts = uIPage.getComponent("challenge_problem_fonts_list");
        this.probFonts.setProperty("items", vector);
        this.probFontSizes = uIPage.getComponent("challenge_problem_fontsize_list");
        this.probFontSizes.setProperty("items", objectArray);
        this.probFonts.setProperty("SelectedItem", this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfont"));
        this.probFontSizes.setProperty("SelectedItem", String.valueOf(this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobontsize")));
        this.probFonts.addEventListener("action", this.handler);
        this.probFontSizes.addEventListener("action", this.handler);
        this.probFixedFonts = uIPage.getComponent("challenge_problem_fixedfonts_list");
        this.probFixedFonts.setProperty("items", vector);
        this.probFixedFontSizes = uIPage.getComponent("challenge_problem_fixedfontsize_list");
        this.probFixedFontSizes.setProperty("items", objectArray);
        this.probFixedFonts.setProperty("SelectedItem", this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfont"));
        this.probFixedFontSizes.setProperty("SelectedItem", String.valueOf(this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfontsize")));
        this.probFixedFonts.addEventListener("action", this.handler);
        this.probFixedFontSizes.addEventListener("action", this.handler);
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore"), "challenge_source_foreground_button"));
        this.map.put("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback", this.createJButton(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback"), "challenge_source_background_button"));
        this.messageFonts = uIPage.getComponent("challenge_source_fonts_list");
        this.messageFonts.setProperty("items", vector);
        this.messageFontSizes = uIPage.getComponent("challenge_source_fontsize_list");
        this.messageFontSizes.setProperty("items", objectArray);
        this.messageFonts.setProperty("SelectedItem", this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont"));
        this.messageFontSizes.setProperty("SelectedItem", String.valueOf(this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize")));
        this.messageFonts.addEventListener("action", this.handler);
        this.messageFontSizes.addEventListener("action", this.handler);
        this.resetPreview();
    }

    private UIComponent createJButton(Color color, String string) {
        UIComponent uIComponent = this.page.getComponent(string);
        uIComponent.setProperty("Background", color);
        uIComponent.addEventListener("action", this.handler);
        return uIComponent;
    }

    private void resetPreview() {
        this.probPreview.setProperty("Text", "");
        this.coderInfoPreview.setProperty("Text", "");
        try {
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfore")).getProperty("Background"));
            this.probPreview.setProperty("Background", ((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobback")).getProperty("Background"));
            StyleConstants.setFontFamily(this.attr, (String)this.probFonts.getProperty("SelectedItem"));
            StyleConstants.setFontSize(this.attr, Integer.parseInt((String)this.probFontSizes.getProperty("SelectedItem")));
            Document document = (Document)this.probPreview.getProperty("document");
            document.insertString(document.getLength(), this.probPreviewStr, this.attr);
            StyleConstants.setForeground(this.attr, (Color)((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore")).getProperty("Background"));
            this.coderInfoPreview.setProperty("Background", ((UIComponent)this.map.get("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback")).getProperty("Background"));
            StyleConstants.setFontFamily(this.attr, (String)this.messageFonts.getProperty("SelectedItem"));
            StyleConstants.setFontSize(this.attr, Integer.parseInt((String)this.messageFontSizes.getProperty("SelectedItem")));
            document = (Document)this.coderInfoPreview.getProperty("Document");
            document.insertString(document.getLength(), this.coderInfoPreviewStr, this.attr);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean areChangesPending() {
        return this.changesPending;
    }

    public void saveChallengePreferences() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            UIComponent uIComponent = (UIComponent)this.map.get(string);
            hashMap.put(string, uIComponent.getProperty("Background"));
        }
        this.localPref.saveColors(hashMap);
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfont", (String)this.probFonts.getProperty("SelectedItem"));
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobontsize", (String)this.probFontSizes.getProperty("SelectedItem"));
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfont", (String)this.probFixedFonts.getProperty("SelectedItem"));
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfixedfontsize", (String)this.probFixedFontSizes.getProperty("SelectedItem"));
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfont", (String)this.messageFonts.getProperty("SelectedItem"));
        this.localPref.setFont("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfontsize", (String)this.messageFontSizes.getProperty("SelectedItem"));
        try {
            this.localPref.savePreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.changesPending = false;
    }

    private class ActionHandler
    implements UIActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                Color color = ((JButton)actionEvent.getSource()).getBackground();
                Color color2 = JColorChooser.showDialog(null, "Choose color", color);
                if (color2 == null) {
                    return;
                }
                if (!color.equals(color2)) {
                    ChallengeConfigurationPanel.this.changesPending = true;
                }
                ((JButton)actionEvent.getSource()).setBackground(color2);
                ChallengeConfigurationPanel.this.resetPreview();
            } else if (object instanceof JComboBox) {
                ChallengeConfigurationPanel.this.changesPending = true;
                ChallengeConfigurationPanel.this.resetPreview();
            }
        }
    }
}

