/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.panels;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.frames.SourceViewer;
import com.topcoder.client.contestApplet.uilogic.panels.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.uilogic.views.ChallengeViewLogic;
import com.topcoder.client.contestApplet.uilogic.views.PrettyToggleProvider;
import com.topcoder.client.contestApplet.widgets.AlgorithmCoderComponentRenderer;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIMouseAdapter;
import com.topcoder.netCommon.contest.ResultDisplayType;
import com.topcoder.netCommon.contest.round.RoundProperties;
import com.topcoder.netCommon.contest.round.text.ComponentNameBuilder;
import com.topcoder.netCommon.contestantMessages.response.data.ComponentChallengeData;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;

public abstract class BaseAlgoSummaryTablePanel
extends AbstractSummaryTablePanel
implements ChallengeViewLogic {
    protected final ContestApplet ca;
    protected ChallengeTableModel tableModel;
    protected UIComponent table;
    private boolean once = true;
    private boolean enabled = true;
    private int lastColumnIndexFix;
    private int columnCount;
    private int maxProblemColumn;
    private Class[] tableModelClasses;
    private String[] tableModelHeaders;
    private int oldCompID = 0;
    private ArrayList oldArgs = null;
    private static final Boolean PROBLEM_OPENED = new Boolean(true);
    private final Map clickStatusController = new HashMap();
    private ProblemModel currentProblemInfo;
    private SourceViewer src;
    private UIComponent contestPopup;
    private UIComponent otherContestPopup;
    private final CoderComponent.Listener myCoderComponentListener = new CoderComponent.Listener(){

        public void coderComponentEvent(CoderComponent coderComponent) {
            if (coderComponent.hasSourceCode()) {
                if (BaseAlgoSummaryTablePanel.this.currentProblemInfo == null) {
                    throw new IllegalStateException("Missing problem info");
                }
                ComponentNameBuilder componentNameBuilder = BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundType().getComponentNameBuilder();
                String string = componentNameBuilder.longNameForComponent(coderComponent.getComponent().getClassName(), coderComponent.getComponent().getPoints(), BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundProperties());
                BaseAlgoSummaryTablePanel.this.src.clear();
                BaseAlgoSummaryTablePanel.this.src.setCode(coderComponent.getSourceCode(), coderComponent.getSourceCodeLanguage());
                BaseAlgoSummaryTablePanel.this.src.setTitle(coderComponent.getCoder().getHandle() + "'s " + string + " (" + coderComponent.getSourceCodeLanguage().getName() + ")");
            } else {
                BaseAlgoSummaryTablePanel.this.sourceViewerClosing();
            }
        }
    };
    private final ProblemModel.Listener myProblemModelListener = new ProblemModel.Listener(){

        public void updateProblemModel(ProblemModel problemModel) {
            if (problemModel.hasProblemStatement()) {
                BaseAlgoSummaryTablePanel.this.ca.getInterFrame().hideMessage();
                if (BaseAlgoSummaryTablePanel.this.src == null) {
                    throw new IllegalStateException("Source viewer not initialized!");
                }
                BaseAlgoSummaryTablePanel.this.src.setTitle(problemModel.getName());
                if (BaseAlgoSummaryTablePanel.this.once) {
                    BaseAlgoSummaryTablePanel.this.once = false;
                }
                BaseAlgoSummaryTablePanel.this.src.show();
                BaseAlgoSummaryTablePanel.this.src.setProblem(problemModel);
                BaseAlgoSummaryTablePanel.this.challengeHandle = BaseAlgoSummaryTablePanel.this.currentComponent.getCoder().getHandle();
                BaseAlgoSummaryTablePanel.this.src.setCoderComponent(BaseAlgoSummaryTablePanel.this.currentComponent);
                BaseAlgoSummaryTablePanel.this.src.setWriter(BaseAlgoSummaryTablePanel.this.currentComponent.getCoder().getHandle());
                if (BaseAlgoSummaryTablePanel.this.currentComponent.getComponent().getComponentTypeID() == 1) {
                    BaseAlgoSummaryTablePanel.this.src.setChallengeable(true);
                } else {
                    BaseAlgoSummaryTablePanel.this.src.setChallengeable(false);
                }
            } else {
                throw new IllegalStateException("Missing statement for problem " + problemModel);
            }
            BaseAlgoSummaryTablePanel.this.src.refreshStatement();
        }

        public void updateProblemModelReadOnly(ProblemModel problemModel) {
        }
    };
    private String challengeHandle;
    private CoderComponent currentComponent;
    protected UIPage page;
    private FrameLogic frame;
    protected UIComponent panel;
    private boolean update;
    protected TableModelListener tableModelListener;
    static /* synthetic */ Class class$com$topcoder$client$contestApplet$uilogic$panels$table$ChallengeProblemEntry;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        if (this.src != null) {
            this.src.setPanelEnabled(bl);
        }
    }

    public BaseAlgoSummaryTablePanel(ContestApplet contestApplet, FrameLogic frameLogic, boolean bl, UIPage uIPage) {
        this.ca = contestApplet;
        this.frame = frameLogic;
        this.update = bl;
        this.page = uIPage;
    }

    protected void init(UIComponent uIComponent, UIComponent uIComponent2, UIComponent uIComponent3, UIComponent uIComponent4, UIComponent uIComponent5, UIComponent uIComponent6, UIComponent uIComponent7) {
        this.contestPopup = uIComponent;
        this.otherContestPopup = uIComponent2;
        this.table = uIComponent3;
        this.panel = uIComponent4;
        this.prepareForTableModel();
        this.tableModel = new ChallengeTableModel();
        this.tableModelListener = new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (BaseAlgoSummaryTablePanel.this.currentProblemInfo != null && BaseAlgoSummaryTablePanel.this.currentComponent.getStatus() == 140) {
                    BaseAlgoSummaryTablePanel.this.src.notifyChallengeSucceeded(BaseAlgoSummaryTablePanel.this.currentComponent.getCoder().getHandle(), Common.formatNoFractions(BaseAlgoSummaryTablePanel.this.currentProblemInfo.getComponents()[0].getPoints()));
                }
                BaseAlgoSummaryTablePanel.this.updateRoomLeader();
            }
        };
        this.tableModel.addTableModelListener(this.tableModelListener);
        uIComponent6.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseAlgoSummaryTablePanel.this.infoPopupEvent();
            }
        });
        uIComponent7.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseAlgoSummaryTablePanel.this.historyPopupEvent();
            }
        });
        uIComponent5.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseAlgoSummaryTablePanel.this.sourcePopupEvent();
            }
        });
        uIComponent3.setProperty("model", this.tableModel);
        this.initTable();
        uIComponent3.addEventListener("mouse", new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (BaseAlgoSummaryTablePanel.this.enabled) {
                    BaseAlgoSummaryTablePanel.this.mouseClickEvent(mouseEvent);
                    BaseAlgoSummaryTablePanel.this.otherMouseClickEvent(mouseEvent);
                }
            }
        });
        ((JTableHeader)uIComponent3.getProperty("tableheader")).addMouseListener(new UIMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BaseAlgoSummaryTablePanel.this.headerClickEvent(mouseEvent);
            }
        });
    }

    public UIComponent getTable() {
        return this.table;
    }

    private void showContestPopup(MouseEvent mouseEvent) {
        this.contestPopup.performAction("show", new Object[]{mouseEvent.getComponent(), new Integer(mouseEvent.getX()), new Integer(mouseEvent.getY())});
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getComponent();
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
        jTable.setRowSelectionInterval(n, n);
        jTable.setColumnSelectionInterval(n2, n2);
        if (n2 > 2 && n2 < this.maxProblemColumn) {
            Coder coder = this.tableModel.getCoder(n);
            int n3 = 2;
            ProblemModel[] problemModelArray = this.getRoundModel().getProblems(this.getDivisionID());
            CoderComponent coderComponent = null;
            boolean bl = false;
            for (int i = 0; !bl && i < problemModelArray.length; ++i) {
                for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                    if (++n3 != n2) continue;
                    coderComponent = coder.getComponent(problemModelArray[i].getComponents()[j].getID());
                    bl = true;
                }
                if (problemModelArray[i].getProblemType() != 2 || ++n3 != n2) continue;
                coderComponent = null;
                bl = true;
            }
            if (coderComponent != null && coderComponent.getStatus() >= 120) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.showContestPopup(mouseEvent);
                } else if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.sourcePopupEvent();
                } else if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.getCellRenderer(jTable, n2).toggleDisplayTypeForComponent(coderComponent, this.getRoundModel().getRoundProperties().getAllowedScoreTypesToShow());
                    this.tableModel.fireTableCellUpdated(n, n2);
                }
            }
        }
    }

    protected AlgorithmCoderComponentRenderer getCellRenderer(JTable jTable, int n) {
        return (AlgorithmCoderComponentRenderer)jTable.getColumnModel().getColumn(n).getCellRenderer();
    }

    private void otherMouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        if (n2 < 3 || n2 >= this.maxProblemColumn) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.otherContestPopup.performAction("show", new Object[]{mouseEvent.getComponent(), new Integer(mouseEvent.getX()), new Integer(mouseEvent.getY())});
            } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.infoPopupEvent();
            }
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = ((JTableHeader)this.table.getProperty("TableHeader")).columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.tableModel.sort(n, (mouseEvent.getModifiers() & 1) > 0);
            ((JTableHeader)this.table.getProperty("TableHeader")).repaint();
        }
    }

    private void infoPopupEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        UserNameEntry userNameEntry = (UserNameEntry)this.table.performAction("getValueAt", new Object[]{new Integer(n), new Integer(2)});
        this.challengeHandle = userNameEntry.getName();
        this.ca.setCurrentFrame((JFrame)this.frame.getFrame().getEventSource());
        this.ca.requestCoderInfo(this.challengeHandle, userNameEntry.getUserType());
    }

    private void historyPopupEvent() {
        int n = (Integer)this.table.getProperty("SelectedRow");
        if (n >= 0) {
            String string = this.tableModel.getCoder(n).getHandle();
            this.ca.setCurrentFrame((JFrame)this.frame.getFrame().getEventSource());
            this.ca.requestCoderHistory(string, this.getRoomByCoder(string).getRoomID(), this.tableModel.getCoder(n).getUserType());
        }
    }

    private void sourcePopupEvent() {
        CoderComponent coderComponent;
        int n = (Integer)this.table.getProperty("SelectedRow");
        int n2 = (Integer)this.table.getProperty("SelectedColumn");
        if (n2 > 2 && n2 < this.maxProblemColumn && (coderComponent = this.tableModel.getCoderComponent(n, n2)).getStatus() > 110) {
            String string = this.tableModel.getValueAt(n, 2).toString();
            if (!this.canOpenSource(coderComponent, string)) {
                return;
            }
            if (coderComponent.getStatus() > 120) {
                this.createNewSourceViewer(true);
            } else {
                this.createNewSourceViewer(false);
            }
            this.currentComponent = coderComponent;
            this.currentProblemInfo = this.currentComponent.getComponent().getProblem();
            this.challengeHandle = string;
            this.ca.setCurrentFrame((JFrame)this.frame.getFrame().getEventSource());
            boolean bl = false;
            if (this.frame instanceof PrettyToggleProvider) {
                bl = ((PrettyToggleProvider)((Object)this.frame)).getPrettyToggle();
            }
            this.currentComponent.addListener(this.myCoderComponentListener);
            this.currentProblemInfo.addListener(this.myProblemModelListener);
            this.ca.setCurrentFrame((JFrame)this.frame.getFrame().getEventSource());
            this.ca.getInterFrame().showMessage("Fetching problem...", (JFrame)this.frame.getFrame().getEventSource(), 40);
            long l = this.currentComponent.getComponent().getID();
            SourceViewer.PROBLEM_STATE.add(l + "_" + string);
            this.ca.getModel().getRequester().requestChallengeComponent(l, bl, this.getRoomByCoder(this.challengeHandle).getRoomID(), this.challengeHandle);
        }
    }

    public void setOldArgs(ArrayList arrayList, int n) {
        this.oldArgs = arrayList;
        this.oldCompID = n;
    }

    public void doChallenge(String string, CoderComponent coderComponent, FrameLogic frameLogic) {
        if (!this.enabled) {
            return;
        }
        ComponentChallengeData componentChallengeData = coderComponent.getComponent().getComponentChallengeData();
        this.challengeHandle = string;
        this.currentComponent = coderComponent;
        this.ca.setCurrentFrame((JFrame)this.frame.getFrame().getEventSource());
        String string2 = "You are entering arguments to challenge the " + componentChallengeData.getMethodName() + " method of the " + componentChallengeData.getClassName() + " class.  If successful, this challenge will be worth " + 50 + " points. If it is unsuccessful, it will cost you " + -25 + " points.";
        if (this.oldCompID != coderComponent.getComponent().getID().intValue()) {
            Common.showArgInput(this.ca, string2, componentChallengeData.getParamTypes(), null, frameLogic, true, coderComponent.getComponent());
        } else {
            Common.showArgInput(this.ca, string2, componentChallengeData.getParamTypes(), this.oldArgs, frameLogic, true, coderComponent.getComponent());
        }
    }

    private void updateRoomLeader() {
        this.tableModel.updateRoomLeader();
        this.panel.performAction("repaint");
    }

    public void updateView(ResultDisplayType resultDisplayType) {
        JTable jTable = (JTable)this.getTable().getEventSource();
        for (int i = 3; i < this.maxProblemColumn; ++i) {
            this.getCellRenderer(jTable, i).setDisplayType(resultDisplayType);
        }
        this.tableModel.fireTableDataChanged();
    }

    protected void prepareForTableModel() {
        RoundModel roundModel = this.getRoundModel();
        if (!roundModel.hasProblems(this.getDivisionID())) {
            throw new IllegalStateException("Can't build challenge table model, no problems for round: " + roundModel);
        }
        ProblemModel[] problemModelArray = roundModel.getProblems(this.getDivisionID());
        boolean bl = false;
        for (int i = 0; i < problemModelArray.length; ++i) {
            if (problemModelArray[i].getProblemType() != 2) continue;
            bl = true;
        }
        String string = bl ? "C: " : "";
        String string2 = "P: ";
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(Integer.class);
        arrayList2.add("Place");
        arrayList.add(Integer.class);
        arrayList2.add("R");
        arrayList.add(UserNameEntry.class);
        arrayList2.add("Handle");
        ComponentNameBuilder componentNameBuilder = roundModel.getRoundType().getComponentNameBuilder();
        RoundProperties roundProperties = roundModel.getRoundProperties();
        for (int i = 0; i < problemModelArray.length; ++i) {
            for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                arrayList.add(class$com$topcoder$client$contestApplet$uilogic$panels$table$ChallengeProblemEntry == null ? BaseAlgoSummaryTablePanel.class$("com.topcoder.client.contestApplet.uilogic.panels.table.ChallengeProblemEntry") : class$com$topcoder$client$contestApplet$uilogic$panels$table$ChallengeProblemEntry);
                ProblemComponentModel problemComponentModel = problemModelArray[i].getComponents()[j];
                String string3 = componentNameBuilder.shortNameForComponent(problemComponentModel.getClassName(), problemComponentModel.getPoints(), roundProperties);
                arrayList2.add(string + string3);
            }
            if (problemModelArray[i].getProblemType() != 2) continue;
            arrayList.add(class$java$lang$String == null ? BaseAlgoSummaryTablePanel.class$("java.lang.String") : class$java$lang$String);
            arrayList2.add(string2 + problemModelArray[i].getName());
        }
        this.lastColumnIndexFix = 0;
        if (roundModel.getRoundProperties().usesScore()) {
            arrayList.add(String.class);
            arrayList2.add("Score");
            this.lastColumnIndexFix = 1;
        }
        this.tableModelClasses = arrayList.toArray(new Class[0]);
        this.tableModelHeaders = arrayList2.toArray(new String[0]);
        this.columnCount = this.tableModelClasses.length;
        this.maxProblemColumn = this.columnCount - this.lastColumnIndexFix;
    }

    private void createNewSourceViewer(boolean bl) {
        boolean bl2;
        this.closeSourceViewer();
        RoomModel roomModel = this.getRoomByCoder(this.tableModel.getValueAt((Integer)this.table.getProperty("SelectedRow"), 2).toString());
        boolean bl3 = bl2 = roomModel.isPracticeRoom() || roomModel.getRoundModel().isInChallengePhase();
        if (bl2) {
            bl2 = roomModel.isAssigned(this.ca.getModel().getCurrentUser());
        }
        if (!bl) {
            bl2 = false;
        }
        this.src = new SourceViewer(this.ca, bl2);
        this.src.setPanel(this);
    }

    public UIComponent getPanel() {
        return this.panel;
    }

    public Collection getFilteredCoders() {
        Collection collection = this.getCoders();
        if (this.getRoundModel().getRoundProperties().getShowScoresOfOtherCoders().booleanValue()) {
            return collection;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Coder coder = (Coder)iterator.next();
            if (!coder.getHandle().equals(this.ca.getModel().getCurrentUser())) continue;
            return Collections.singletonList(coder);
        }
        return Collections.EMPTY_LIST;
    }

    public void closeSourceViewer() {
        if (this.src != null) {
            this.sourceViewerClosing();
            this.src.hide();
            this.src.dispose();
            this.src = null;
        }
    }

    private String getUniqueClickStatusKey(CoderComponent coderComponent, String string) {
        if (coderComponent != null && string != null && string.trim().length() > 0) {
            return coderComponent.getComponent().getID() + "_" + string;
        }
        return null;
    }

    private boolean canOpenSource(CoderComponent coderComponent, String string) {
        String string2 = this.getUniqueClickStatusKey(coderComponent, string);
        if (string2 == null) {
            return false;
        }
        if (!this.clickStatusController.containsKey(string2)) {
            this.clickStatusController.put(string2, PROBLEM_OPENED);
            return true;
        }
        return false;
    }

    public void sourceViewerClosing() {
        if (this.currentProblemInfo != null) {
            this.currentProblemInfo.removeListener(this.myProblemModelListener);
            this.currentProblemInfo = null;
        }
        if (this.currentComponent != null) {
            this.clickStatusController.remove(this.getUniqueClickStatusKey(this.currentComponent, this.challengeHandle));
            this.currentComponent.removeListener(this.myCoderComponentListener);
            this.currentComponent = null;
        }
    }

    public abstract void updateChallengeTable(RoomModel var1);

    protected abstract RoundModel getRoundModel();

    protected abstract Integer getDivisionID();

    protected abstract boolean isRoomLeader(String var1);

    protected abstract Collection getCoders();

    protected abstract RoomModel getRoomByCoder(String var1);

    protected abstract void initTable();

    public ChallengeTableModel getTableModel() {
        return this.tableModel;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public int getMaxProblemColumn() {
        return this.maxProblemColumn;
    }

    public boolean hasFinalScoreColumn() {
        return this.maxProblemColumn != this.columnCount;
    }

    private final class RankComparator
    implements Comparator {
        private RankComparator() {
        }

        public int compare(Object object, Object object2) {
            Double d = (Double)object;
            Double d2 = (Double)object2;
            return d2.compareTo(d);
        }
    }

    final class ChallengeTableModel
    extends SortedTableModel
    implements Coder.Listener {
        private Map rankByScore;
        private RankComparator rankComparator;

        protected ChallengeTableModel() {
            super(BaseAlgoSummaryTablePanel.this.tableModelHeaders, BaseAlgoSummaryTablePanel.this.tableModelClasses);
            this.rankByScore = new HashMap();
            this.rankComparator = new RankComparator();
            if (BaseAlgoSummaryTablePanel.this.lastColumnIndexFix > 0) {
                this.addSortElement(new SortElement(BaseAlgoSummaryTablePanel.this.maxProblemColumn, true));
            }
            this.addSortElement(new SortElement(0, true));
            this.addSortElement(new SortElement(1, true));
            this.addSortElement(new SortElement(2, true));
            for (int i = 2; i < BaseAlgoSummaryTablePanel.this.maxProblemColumn; ++i) {
                this.addSortElement(new SortElement(i, true));
            }
            this.updateChallengeTable();
        }

        public void updateChallengeTable() {
            if (!BaseAlgoSummaryTablePanel.this.update) {
                return;
            }
            Collection collection = BaseAlgoSummaryTablePanel.this.getFilteredCoders();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Coder coder = (Coder)iterator.next();
                coder.addListener(this);
            }
            this.update(collection);
            this.updateRoomLeader();
        }

        public void updateRoomLeader() {
            if (!BaseAlgoSummaryTablePanel.this.update) {
                return;
            }
            List list = (List)this.getItemList();
            Double[] doubleArray = new Double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Coder coder = (Coder)list.get(i);
                doubleArray[i] = coder.getScore();
            }
            Arrays.sort(doubleArray, 0, doubleArray.length, this.rankComparator);
            this.rankByScore.clear();
            Double d = new Double(Double.MIN_VALUE);
            for (int i = 0; i < doubleArray.length; ++i) {
                if (d.equals(doubleArray[i])) continue;
                d = doubleArray[i];
                this.rankByScore.put(d, new Integer(i + 1));
            }
            this.sort();
        }

        private int getCoderRank(Coder coder) {
            if (BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundProperties().usesScore()) {
                Integer n = (Integer)this.rankByScore.get(coder.getScore());
                return n != null ? n : -1;
            }
            return 1;
        }

        public void coderEvent(Coder coder) {
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            Coder coder = this.getCoder(n);
            return this.getValueAt(coder, n2);
        }

        private Object getValueAt(Coder coder, int n) {
            if (n == 0) {
                return new Integer(this.getCoderRank(coder));
            }
            if (n == 1) {
                return coder.getRating();
            }
            if (n == 2) {
                return new UserNameEntry(coder.getHandle(), coder.getRating(), BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundProperties().usesScore() && BaseAlgoSummaryTablePanel.this.isRoomLeader(coder.getHandle()), coder.getUserType());
            }
            if (n >= 3 && n < BaseAlgoSummaryTablePanel.this.maxProblemColumn) {
                if (this.shouldUsePassedSystemTestsOnColumn(n)) {
                    return this.getComponentColumnValueAsTests(coder, n);
                }
                return this.getComponentColumnValueAsPoints(coder, n);
            }
            if (n == BaseAlgoSummaryTablePanel.this.maxProblemColumn) {
                return new Double(coder.getScore() / 100.0);
            }
            throw new IllegalArgumentException("Invalid column: " + n);
        }

        private boolean shouldUsePassedSystemTestsOnColumn(int n) {
            ResultDisplayType resultDisplayType = BaseAlgoSummaryTablePanel.this.getCellRenderer((JTable)BaseAlgoSummaryTablePanel.this.table.getEventSource(), n).getDisplayType();
            return BaseAlgoSummaryTablePanel.this.getRoundModel().getPhase() >= 9 && ResultDisplayType.PASSED_TESTS.equals(resultDisplayType);
        }

        private Object getComponentColumnValueAsPoints(Coder coder, int n) {
            int n2 = 2;
            ProblemModel[] problemModelArray = BaseAlgoSummaryTablePanel.this.getRoundModel().getProblems(BaseAlgoSummaryTablePanel.this.getDivisionID());
            for (int i = 0; i < problemModelArray.length; ++i) {
                double d = 0.0;
                for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                    d += coder.getComponent(problemModelArray[i].getComponents()[j].getID()).getPoints().doubleValue() / 100.0;
                    if (++n2 != n) continue;
                    return coder.getComponent(problemModelArray[i].getComponents()[j].getID());
                }
                if (problemModelArray[i].getProblemType() != 2 || ++n2 != n) continue;
                return new Double(d);
            }
            throw new IllegalArgumentException("Invalid column: " + n);
        }

        private Object getComponentColumnValueAsTests(Coder coder, int n) {
            int n2 = 2;
            ProblemModel[] problemModelArray = BaseAlgoSummaryTablePanel.this.getRoundModel().getProblems(BaseAlgoSummaryTablePanel.this.getDivisionID());
            for (int i = 0; i < problemModelArray.length; ++i) {
                int n3 = 0;
                for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                    Integer n4 = coder.getComponent(problemModelArray[i].getComponents()[j].getID()).getPassedSystemTests();
                    n3 += n4 == null ? 0 : n4;
                    if (++n2 != n) continue;
                    return coder.getComponent(problemModelArray[i].getComponents()[j].getID());
                }
                if (problemModelArray[i].getProblemType() != 2 || ++n2 != n) continue;
                return new Integer(n3);
            }
            throw new IllegalArgumentException("Invalid column: " + n);
        }

        Coder getCoder(int n) {
            return (Coder)this.get(n);
        }

        private CoderComponent getCoderComponent(int n, int n2) {
            Coder coder = (Coder)this.get(n);
            ProblemModel[] problemModelArray = BaseAlgoSummaryTablePanel.this.getRoundModel().getProblems(BaseAlgoSummaryTablePanel.this.getDivisionID());
            int n3 = 2;
            CoderComponent coderComponent = null;
            boolean bl = false;
            for (int i = 0; !bl && i < problemModelArray.length; ++i) {
                for (int j = 0; j < problemModelArray[i].getComponents().length; ++j) {
                    if (++n3 != n2) continue;
                    coderComponent = coder.getComponent(problemModelArray[i].getComponents()[j].getID());
                    bl = true;
                }
                if (problemModelArray[i].getProblemType() != 2 || ++n3 != n2) continue;
                coderComponent = null;
                bl = true;
            }
            return coderComponent;
        }

        public int compare(Object object, Object object2) {
            Coder coder = (Coder)object;
            Coder coder2 = (Coder)object2;
            Iterator iterator = this.getSortListIterator();
            while (iterator.hasNext()) {
                int n;
                SortElement sortElement = (SortElement)iterator.next();
                int n2 = sortElement.getColumn();
                int n3 = n = sortElement.isOpposite() ? -1 : 1;
                if (n2 == 0) {
                    int n4 = this.getCoderRank(coder) - this.getCoderRank(coder2);
                    if (n4 == 0) continue;
                    return n * n4;
                }
                if (n2 == 1) {
                    int n5 = coder.getRating() - coder2.getRating();
                    if (n5 == 0) continue;
                    return n * n5;
                }
                if (n2 == 2) {
                    int n6 = ChallengeTableModel.compareStrings(coder.getHandle(), coder2.getHandle());
                    if (n6 == 0) continue;
                    return n * n6;
                }
                if (n2 >= 3 && n2 < BaseAlgoSummaryTablePanel.this.maxProblemColumn) {
                    int n7 = this.shouldUsePassedSystemTestsOnColumn(n2) ? this.compareCoderByComponentPassedTestsColumn(coder, coder2, n2) : (BaseAlgoSummaryTablePanel.this.getRoundModel().getRoundProperties().usesScore() ? this.compareCoderByComponentPointsColumn(coder, coder2, n2) : this.compareCoderByComponentStatusColumn(coder, coder2, n2));
                    if (n7 == 0) continue;
                    return n7 * n;
                }
                if (n2 == BaseAlgoSummaryTablePanel.this.maxProblemColumn) {
                    double d = coder.getScore() - coder2.getScore();
                    if (d == 0.0) continue;
                    return n * (d > 0.0 ? 1 : -1);
                }
                throw new IllegalStateException("bad sort column =" + sortElement);
            }
            return 0;
        }

        private int compareCoderByComponentStatusColumn(Coder coder, Coder coder2, int n) {
            Object object = this.getValueAt(coder, n);
            Object object2 = this.getValueAt(coder2, n);
            if (object instanceof CoderComponent) {
                return ((CoderComponent)object).getStatus().compareTo(((CoderComponent)object2).getStatus());
            }
            return ((Comparable)object).compareTo(object2);
        }

        private int compareCoderByComponentPassedTestsColumn(Coder coder, Coder coder2, int n) {
            Object object = this.getValueAt(coder, n);
            Object object2 = this.getValueAt(coder2, n);
            if (object instanceof CoderComponent) {
                Integer n2 = ((CoderComponent)object).getPassedSystemTests();
                Integer n3 = ((CoderComponent)object2).getPassedSystemTests();
                if (n2 == null) {
                    return n3 == null ? 0 : -1;
                }
                if (n3 == null) {
                    return 1;
                }
                return n2.compareTo(n3);
            }
            return ((Comparable)object).compareTo(object2);
        }

        private int compareCoderByComponentPointsColumn(Coder coder, Coder coder2, int n) {
            Object object = this.getValueAt(coder, n);
            Object object2 = this.getValueAt(coder2, n);
            if (object instanceof CoderComponent) {
                return ((CoderComponent)object).getPoints().compareTo(((CoderComponent)object2).getPoints());
            }
            return ((Comparable)object).compareTo(object2);
        }
    }
}

