/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.contestApplet.uilogic.panels.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.ChallengeTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.ChatPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.uilogic.panels.LongSummaryTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.ResultDisplayTypeSelectionPanel;
import com.topcoder.client.contestApplet.uilogic.panels.UserTablePanel;
import com.topcoder.client.contestApplet.uilogic.views.PrettyToggleProvider;
import com.topcoder.client.contestApplet.widgets.MoveFocus;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.view.RoomView;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Component;

public class RoomInfoFrame
implements FrameLogic,
RoomView,
PrettyToggleProvider {
    private UIComponent frame;
    private UIPage page;
    private RoomModel model;
    private ContestApplet parentFrame = null;
    private AbstractSummaryTablePanel challengePanel = null;
    private UserTablePanel userPanel = null;
    private ChatPanel chatPanel = null;
    private boolean once = true;
    private UIComponent jrb2 = null;
    private boolean enabled = true;
    private ResultDisplayTypeSelectionPanel resultDisplayTypeSelectionPanel;
    private ContestSponsorPanel sponsorPanel;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
        this.userPanel.setPanelEnabled(bl);
        this.chatPanel.setPanelEnabled(bl);
        this.challengePanel.setPanelEnabled(bl);
    }

    public UIComponent getFrame() {
        return this.frame;
    }

    public boolean getPrettyToggle() {
        return (Boolean)this.jrb2.getProperty("Selected");
    }

    public RoomInfoFrame(ContestApplet contestApplet, RoomModel roomModel) {
        this.page = contestApplet.getCurrentUIManager().getUIPage("room_info_frame", true);
        this.frame = this.page.getComponent("root_frame");
        this.jrb2 = this.page.getComponent("pretty_on");
        this.parentFrame = contestApplet;
        this.model = roomModel;
    }

    public RoomModel getModel() {
        return this.model;
    }

    public boolean hasRoomModel() {
        return this.model != null;
    }

    public void showFrame(boolean bl) {
        if (this.once) {
            Common.setLocationRelativeTo((Component)this.parentFrame.getMainFrame(), (Component)this.frame.getEventSource());
            this.once = false;
        }
        this.frame.performAction("show");
        MoveFocus.moveFocus(this.challengePanel.getTable());
    }

    private boolean isLongRound() {
        return this.model.getRoundModel() != null && this.model.getRoundModel().getRoundType().isLongRound();
    }

    private void create() {
        if (this.isLongRound()) {
            this.page.getComponent("challenge_table_panel").setProperty("Visible", Boolean.FALSE);
            this.page.getComponent("pretty_toggle_panel").setProperty("Visible", Boolean.FALSE);
            this.challengePanel = new LongSummaryTablePanel(this.parentFrame, this.model, this, true, this.page);
        } else {
            this.page.getComponent("long_summary_table_panel").setProperty("Visible", Boolean.FALSE);
            this.challengePanel = new ChallengeTablePanel(this.parentFrame, this.model, this, this.page);
        }
        this.chatPanel = new ChatPanel(this.parentFrame, this.page);
        this.chatPanel.readonly(true);
        this.userPanel = new UserTablePanel(this.parentFrame, this.page);
        this.sponsorPanel = new ContestSponsorPanel(this.page.getComponent("sponsor_logo"), CommonData.getSponsorWatchRoomImageAddr(this.parentFrame.getSponsorName(), this.getModel()));
        this.resultDisplayTypeSelectionPanel = new ResultDisplayTypeSelectionPanel(this.page, this.model.getRoundModel(), new ResultDisplayTypeSelectionPanel.Listener(){

            public void typeChanged(ResultDisplayType resultDisplayType) {
                RoomInfoFrame.this.challengePanel.updateView(resultDisplayType);
            }
        });
        this.frame.performAction("pack");
    }

    public void setModel(RoomModel roomModel) {
        this.model = roomModel;
        this.create();
        roomModel.addChatView(this.chatPanel);
        roomModel.addUserListView(this.userPanel);
        roomModel.addUserListView(this.chatPanel);
        roomModel.addChallengeView(this.challengePanel);
        this.userPanel.updateUserList(roomModel.getUsers());
    }

    public void unsetModel() {
        this.model.removeChallengeView(this.challengePanel);
        this.model.removeUserListView(this.chatPanel);
        this.model.removeUserListView(this.userPanel);
        this.model.removeChatView(this.chatPanel);
        this.model.unsetWatchView();
        this.frame.performAction("hide");
    }

    public void setName(String string) {
        this.frame.setProperty("title", (String)this.frame.getProperty("title") + " - " + string);
        this.frame.performAction("repaint");
    }

    public void setStatus(String string) {
    }

    public String toString() {
        return "Room Info Frame - " + this.model;
    }

    public void dispose() {
        this.frame.performAction("dispose");
    }

    public void hide() {
        this.frame.performAction("hide");
    }
}

