/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.uilogic.frames.FrameLogic;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.netCommon.contest.Matrix2D;
import com.topcoder.shared.problem.DataType;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfirmInputDialog
implements FrameLogic {
    private boolean status = false;
    private UIPage page;
    private UIComponent dialog;

    public UIComponent getFrame() {
        return this.dialog;
    }

    public ConfirmInputDialog(ContestApplet contestApplet, UIComponent uIComponent, DataType[] dataTypeArray, ArrayList arrayList) {
        this.page = contestApplet.getCurrentUIManager().getUIPage("confirm_input_dialog", true);
        this.dialog = this.page.getComponent("root_dialog", false);
        this.dialog.setProperty("owner", uIComponent.getEventSource());
        this.dialog.create();
        if (dataTypeArray.length != arrayList.size()) {
            throw new IllegalArgumentException("The number of arguments does not match the number of parameters");
        }
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.fill = 2;
        UIComponent uIComponent2 = this.page.getComponent("label_template");
        UIComponent uIComponent3 = this.page.getComponent("textfield_template");
        JPanel jPanel = (JPanel)this.page.getComponent("param_panel").getEventSource();
        for (int i = 0; i < dataTypeArray.length; ++i) {
            String string = dataTypeArray[i].getDescription();
            Object e = arrayList.get(i);
            gridBagConstraints.insets = i == 0 ? new Insets(15, 15, 0, 15) : new Insets(5, 15, 0, 15);
            JTextField jTextField = (JTextField)uIComponent3.performAction("clone");
            jTextField.setText(this.formatText(e));
            JLabel jLabel = (JLabel)uIComponent2.performAction("clone");
            jLabel.setText("(" + (i + 1) + ") " + string);
            Common.insertInPanel(jLabel, jPanel, gridBagConstraints, 0, i, 1, 1, 0.0, 0.0);
            Common.insertInPanel(jTextField, jPanel, gridBagConstraints, 1, i, 1, 1, 0.1, 0.1);
        }
        this.page.getComponent("ok_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmInputDialog.this.okButtonEvent();
            }
        });
        this.page.getComponent("cancel_button").addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmInputDialog.this.cancelButtonEvent();
            }
        });
        this.dialog.performAction("pack");
        Common.setLocationRelativeTo(uIComponent, this.dialog);
    }

    private String formatText(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ArrayList) {
            this.formatTextArray(stringBuffer, (ArrayList)object);
        } else if (object instanceof Matrix2D) {
            this.formatTextMatrix(stringBuffer, (Matrix2D)object);
        } else {
            this.formatTextString(stringBuffer, object.toString());
        }
        return stringBuffer.toString();
    }

    private void formatTextMatrix(StringBuffer stringBuffer, Matrix2D matrix2D) {
        stringBuffer.append("{");
        for (int i = 0; i < matrix2D.numRows(); ++i) {
            this.formatTextArray(stringBuffer, matrix2D.getRow(i));
            if (i >= matrix2D.numRows() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
    }

    private void formatTextArray(StringBuffer stringBuffer, ArrayList arrayList) {
        stringBuffer.append("{");
        for (int i = 0; i < arrayList.size(); ++i) {
            this.formatTextString(stringBuffer, arrayList.get(i).toString());
            if (i >= arrayList.size() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
    }

    private void formatTextString(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
    }

    public boolean showDialog() {
        this.dialog.performAction("show");
        return this.status;
    }

    private void okButtonEvent() {
        this.status = true;
        this.dialog.performAction("dispose");
    }

    private void cancelButtonEvent() {
        this.status = false;
        this.dialog.performAction("dispose");
    }
}

