/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.uilogic.components;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.uilogic.frames.BroadcastSummaryFrame;
import com.topcoder.client.contestant.BroadcastListener;
import com.topcoder.client.contestant.BroadcastManager;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.netCommon.contestantMessages.AdminBroadcast;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.Observable;
import java.util.Observer;

public class BroadcastButton
implements BroadcastListener {
    private BroadcastManager manager;
    private WeakListener windowListener;
    private WeakObserver prefObserver;
    private ContestApplet ca;
    private boolean flashing;
    private boolean flashingEnabled = false;
    private LocalPreferences pref;
    private UIComponent button;

    public BroadcastButton(ContestApplet contestApplet, UIComponent uIComponent) {
        this.ca = contestApplet;
        this.button = uIComponent;
        this.pref = LocalPreferences.getInstance();
        this.setFlashingEnabled();
        this.prefObserver = new WeakObserver(this);
        this.pref.addSaveObserver(this.prefObserver);
        this.manager = this.ca.getModel().getBroadcastManager();
        this.windowListener = new WeakListener(this);
        BroadcastSummaryFrame.getInstance(this.ca).getFrame().addEventListener("window", this.windowListener);
        this.button.addEventListener("action", new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((Boolean)BroadcastButton.this.button.getProperty("enabled")).booleanValue()) {
                    BroadcastButton.this.ca.getRequester().requestGetAdminBroadcast();
                    BroadcastSummaryFrame.getInstance(BroadcastButton.this.ca).showFrame();
                }
            }
        });
        this.manager.addBroadcastListener(this, false);
    }

    public void setEnabled(boolean bl) {
        this.button.setProperty("enabled", bl);
    }

    private synchronized void setFlashing(boolean bl) {
        if (this.flashing == bl) {
            return;
        }
        this.flashing = bl && this.flashingEnabled;
        this.button.setProperty("flashing", this.flashing);
        this.button.performAction("repaint");
    }

    public synchronized void newBroadcast(AdminBroadcast adminBroadcast) {
        if (!this.manager.hasRead(adminBroadcast)) {
            this.setFlashing(true);
        }
    }

    public void readBroadcast(AdminBroadcast adminBroadcast) {
    }

    public void refreshBroadcasts() {
    }

    protected void finalize() throws Throwable {
        BroadcastSummaryFrame.getInstance(this.ca).getFrame().removeEventListener("window", this.windowListener);
        LocalPreferences.getInstance().removeSaveObserver(this.prefObserver);
    }

    private synchronized void setFlashingEnabled() {
        this.flashingEnabled = Boolean.valueOf(this.pref.getProperty("com.topcoder.jmaContestApplet.ContestApplet.disableBroadcastPopup", "" + Boolean.FALSE));
    }

    private static final class WeakListener
    extends UIWindowAdapter {
        private WeakReference buttonRef;

        private WeakListener(BroadcastButton broadcastButton) {
            this.buttonRef = new WeakReference<BroadcastButton>(broadcastButton);
        }

        public void windowActivated(WindowEvent windowEvent) {
            BroadcastButton broadcastButton = (BroadcastButton)this.buttonRef.get();
            if (broadcastButton != null) {
                broadcastButton.setFlashing(false);
            }
        }
    }

    private static final class WeakObserver
    implements Observer {
        private WeakReference ref;

        public WeakObserver(BroadcastButton broadcastButton) {
            this.ref = new WeakReference<BroadcastButton>(broadcastButton);
        }

        public void update(Observable observable, Object object) {
            BroadcastButton broadcastButton = (BroadcastButton)this.ref.get();
            if (broadcastButton != null) {
                broadcastButton.setFlashingEnabled();
            }
        }
    }
}

