/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.rooms;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.rooms.CoderRoomInterface;
import com.topcoder.client.contestApplet.rooms.RoomModule;
import com.topcoder.client.contestApplet.uilogic.frames.ChallengeFrame;
import com.topcoder.client.contestApplet.uilogic.frames.CodingFrame;
import com.topcoder.client.contestApplet.uilogic.panels.ChatPanel;
import com.topcoder.client.contestApplet.uilogic.panels.CoderContestantTablePanel;
import com.topcoder.client.contestApplet.uilogic.panels.CompPanel;
import com.topcoder.client.contestApplet.uilogic.panels.CompetitionCompPanel;
import com.topcoder.client.contestApplet.uilogic.panels.ProblemPanel;
import com.topcoder.client.contestApplet.uilogic.panels.RoomPanel;
import com.topcoder.client.contestApplet.uilogic.panels.TimeLine;
import com.topcoder.client.contestApplet.uilogic.panels.TimerPanel;
import com.topcoder.client.contestApplet.uilogic.panels.UserTablePanel;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.client.contestant.ProblemModel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.CodingView;
import com.topcoder.client.contestant.view.PhaseListener;
import com.topcoder.client.ui.UIComponent;
import com.topcoder.client.ui.UIPage;
import com.topcoder.client.ui.event.UIActionListener;
import com.topcoder.client.ui.event.UIWindowAdapter;
import com.topcoder.netCommon.contest.ContestConstants;
import com.topcoder.netCommon.contest.round.text.ComponentNameBuilder;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import com.topcoder.shared.problem.DataType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class CoderRoom
extends RoomModule
implements CodingView,
PhaseListener,
CoderRoomInterface {
    private UIComponent problemSelector;
    private RoomPanel panel = null;
    private CompPanel compPanel = null;
    private ChatPanel chatPanel = null;
    private UserTablePanel userPanel = null;
    private CoderContestantTablePanel contestantPanel = null;
    private CodingFrame codingRoom = null;
    private ChallengeFrame statusFrame = null;
    protected UIPage page;
    private TimeLine timeLine = null;
    private ProblemPanel problemPanel = null;
    private ArrayList tempArgs = null;
    private CompetitionCompPanel ccp = null;
    private boolean openingProblem = false;
    private boolean problemListStatus = true;
    private boolean enabled = true;
    private boolean timeLineWithChallengePhase;
    private static final String SELECTONE = "Select one";
    public static final String SPECTATOR_ROOM = "Spectator Room";
    private static final String DEFAULT_NAME = "Coder Room";
    private CoderComponent.Listener myCoderComponentListener = new CoderComponent.Listener(){

        public void coderComponentEvent(CoderComponent coderComponent) {
            if (coderComponent.hasSourceCode()) {
                CoderRoom.this.codingRoom.updateComponentSource(coderComponent.getSourceCode(), coderComponent.getSourceCodeLanguage());
            }
            coderComponent.removeListener(this);
        }
    };
    private ProblemModel.Listener myProblemModelListener = new ProblemModel.Listener(){

        public void updateProblemModel(ProblemModel problemModel) {
            if (CoderRoom.this.openingProblem) {
                CoderRoom.this.openingProblem = false;
                CoderRoom.this.parentFrame.getInterFrame().hideMessage();
                CoderRoom.this.updateCodingWindow(problemModel);
            }
        }

        public void updateProblemModelReadOnly(ProblemModel problemModel) {
        }
    };
    private CoderComponent currentCoderComponent;

    public CoderRoom(ContestApplet contestApplet) {
        this(contestApplet, "coder");
    }

    protected CoderRoom(ContestApplet contestApplet, String string) {
        super(contestApplet, 2);
        this.create("", string);
    }

    private String getDefaultName() {
        return DEFAULT_NAME;
    }

    public void setArgs(ArrayList arrayList) {
        this.tempArgs = arrayList;
    }

    public void setConnectionStatus(boolean bl) {
        this.enabled = bl;
        this.panel.setStatusLabel(bl);
        this.chatPanel.setPanelEnabled(bl);
        this.userPanel.setPanelEnabled(bl);
        this.contestantPanel.setPanelEnabled(bl);
        this.problemPanel.setPanelEnabled(bl);
        this.statusFrame.setPanelEnabled(bl);
        if (!bl) {
            this.problemListStatus = (Boolean)this.problemSelector.getProperty("Enabled");
        }
        if (this.problemListStatus && bl) {
            this.problemSelector.setProperty("Enabled", Boolean.TRUE);
        }
        if (this.problemListStatus && !bl) {
            this.problemSelector.setProperty("Enabled", Boolean.FALSE);
        }
        if (this.codingRoom != null) {
            this.codingRoom.setPanelEnabled(bl);
        }
    }

    private void create(String string, String string2) {
        if (string == null) {
            string = this.getDefaultName();
        }
        this.page = this.parentFrame.getCurrentUIManager().getUIPage(string2);
        this.ccp = new CompetitionCompPanel(this.page);
        this.panel = new RoomPanel(string, this.parentFrame, this.createWorkPanel(), this.ccp, this.page);
        this.compPanel = this.panel.getCompPanel();
        this.panel.showTimer();
    }

    private UIComponent createWorkPanel() {
        TimeLine timeLine = this.newTimeLine();
        this.problemSelector = this.buildProblemSelector(new UIActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoderRoom.this.problemsListEvent();
            }
        });
        ProblemPanel problemPanel = new ProblemPanel(this.parentFrame, this.page, this, this.problemSelector);
        UserTablePanel userTablePanel = new UserTablePanel(this.parentFrame, this.page);
        ChatPanel chatPanel = new ChatPanel(this.parentFrame, 1, this.page);
        CoderContestantTablePanel coderContestantTablePanel = new CoderContestantTablePanel(this.parentFrame, this.page);
        this.createNewCodingRoom();
        this.chatPanel = chatPanel;
        this.userPanel = userTablePanel;
        this.contestantPanel = coderContestantTablePanel;
        this.timeLine = timeLine;
        this.problemPanel = problemPanel;
        return this.page.getComponent("work_panel_base");
    }

    protected TimeLine newTimeLine() {
        this.timeLineWithChallengePhase = true;
        return new TimeLine(this.parentFrame, this.page);
    }

    protected void updateTimeLine() {
        boolean bl = this.roomModel.getRoundModel().getRoundProperties().hasChallengePhase();
        if (!bl && this.timeLineWithChallengePhase) {
            this.timeLineWithChallengePhase = false;
            this.timeLine.updateIcons("phase_empty_nc_image", "phase_coding_nc_image", "phase_intermission_nc_image", "phase_challenge_image", "phase_system_nc_image", this.parentFrame);
        } else if (bl && !this.timeLineWithChallengePhase) {
            this.timeLine.updateIcons("phase_empty_image", "phase_coding_image", "phase_intermission_image", "phase_challenge_image", "phase_system_image", this.parentFrame);
            this.timeLineWithChallengePhase = true;
        }
    }

    public RoomModel getRoomModel() {
        return this.roomModel;
    }

    public JPanel reload() {
        this.panel.getWorkPanel().performAction("revalidate");
        this.panel.getWorkPanel().performAction("repaint");
        return (JPanel)this.panel.getPanel().getEventSource();
    }

    public void clear() {
        super.clear();
        this.problemSelector.setProperty("Enabled", Boolean.TRUE);
        this.clearProblemSelector();
        this.userPanel.clear();
        this.contestantPanel.clear();
        this.chatPanel.clear();
    }

    public void enter() {
        this.chatPanel.enter();
    }

    public boolean leave() {
        this.closeCodingWindow();
        this.codingRoom.hide();
        if (this.statusFrame != null) {
            this.statusFrame.hide();
        }
        this.chatPanel.leave();
        this.unsetModel();
        return true;
    }

    public void resetFocus() {
        this.chatPanel.leave();
        this.chatPanel.enter();
    }

    public CodingFrame getCodingFrame() {
        return this.codingRoom;
    }

    public synchronized void phaseEvent(int n, RoundModel roundModel) {
        this.setTimerPhase(n, roundModel);
        this.timeLine.setPhase(n);
        this.problemPanel.setPhase(n);
        switch (n) {
            case 4: {
                this.problemSelector.setProperty("Enabled", Boolean.TRUE);
                break;
            }
            case 5: {
                this.codingRoom.setButtons(false, false, false, false, false, true, false, false);
                this.codingRoom.enableText(false);
                this.codingRoom.setButtons(false, false, false, false, false, true, false, false);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 0: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown phase (" + n + ").");
            }
        }
    }

    private void setTimerPhase(int n, RoundModel roundModel) {
        int n2 = -1;
        String string = null;
        switch (n) {
            case 0: {
                string = "TOPCODER TIME";
                n2 = 1;
                break;
            }
            case 7: {
                string = "PENDING SYSTESTS";
                n2 = 1;
                break;
            }
            case 9: {
                string = "CONTEST COMPLETE";
                n2 = 1;
                break;
            }
            case 2: {
                string = "REGISTRATION";
                n2 = 2;
                break;
            }
            case 3: {
                string = "STARTS IN";
                n2 = 2;
                break;
            }
            case 1: {
                string = "STARTS IN";
                n2 = 2;
                break;
            }
            case 4: {
                string = "CODING";
                n2 = 2;
                break;
            }
            case 5: {
                string = "INTERMISSION";
                n2 = 2;
                break;
            }
            case 6: {
                string = "CHALLENGE";
                n2 = 2;
                break;
            }
            case 10: {
                string = "VOTING";
                n2 = 2;
                break;
            }
            case 11: {
                string = "TIE BREAKING VOTE";
                n2 = 2;
                break;
            }
            case 8: {
                string = "SYSTEM TESTING";
                n2 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad phase type: " + n);
            }
        }
        this.getTimerPanel().setTitle(string);
        this.getTimerPanel().setMode(n2);
        this.statusFrame.getTimerPanel().setTitle(string);
        this.statusFrame.getTimerPanel().setMode(n2);
        TimerPanel timerPanel = this.codingRoom.getTimerPanel();
        timerPanel.setTitle(string);
        boolean bl = timerPanel.isRoundModelInitialized();
        if (roundModel != null && !bl) {
            timerPanel.setRoundModel(roundModel);
        }
        timerPanel.setMode(n2);
    }

    public void timeOutEvent(int n) {
        switch (n) {
            case 34: {
                this.codingRoom.setButtons(true, true, true, true, true, false, true, false);
                break;
            }
            case 4: {
                this.codingRoom.setButtons(true, true, true, true, true, false, true, false);
                break;
            }
            case 15: {
                this.codingRoom.setButtons(true, true, true, false, false, true, true, true);
            }
        }
    }

    protected void addViews() {
        if (!this.roomModel.hasRoundModel()) {
            throw new IllegalStateException("No round associated with: " + this.roomModel);
        }
        RoundModel roundModel = this.roomModel.getRoundModel();
        roundModel.addPhaseListener(this);
        if (!roundModel.hasProblems(this.roomModel.getDivisionID())) {
            throw new IllegalStateException("Missing problem labels for round: " + roundModel);
        }
        this.createProblems(roundModel.getAssignedComponents(this.roomModel.getDivisionID()));
        this.createNewStatusRoom();
        this.getTimerPanel().setRoundModel(roundModel);
        this.codingRoom.getTimerPanel().setRoundModel(roundModel);
        this.codingRoom.setRoomModel(this.roomModel);
        this.updateTimeLine();
        this.statusFrame.getTimerPanel().setRoundModel(roundModel);
        this.phaseEvent(roundModel.getPhase(), null);
        this.roomModel.addChatView(this.chatPanel);
        this.roomModel.addChallengeView(this.statusFrame.getChallengePanel());
        if (this.statusFrame.getAssignmentPanel() != null) {
            this.roomModel.addChallengeView(this.statusFrame.getAssignmentPanel());
            this.roomModel.addAssignmentView(this.statusFrame.getAssignmentPanel());
        }
        this.roomModel.addUserListView(this.userPanel);
        this.roomModel.addUserListView(this.chatPanel);
        this.roomModel.addCodingView(this);
        Coder[] coderArray = this.roomModel.getCoders();
        UserListItem[] userListItemArray = new UserListItem[coderArray.length];
        for (int i = 0; i < coderArray.length; ++i) {
            Coder coder = coderArray[i];
            userListItemArray[i] = new UserListItem(coder.getHandle(), coder.getRating(), coder.getUserType());
        }
        this.contestantPanel.updateUserList(userListItemArray);
        this.ccp.updateContestInfo(this.roomModel.getStatus());
        this.compPanel.setContestName(this.roomModel.getName());
    }

    protected void clearViews() {
        this.ccp.updateContestInfo("");
        this.compPanel.setContestName("");
        this.contestantPanel.clear();
        if (this.roomModel != null) {
            this.roomModel.removeCodingView(this);
            this.roomModel.removeUserListView(this.chatPanel);
            this.roomModel.removeUserListView(this.userPanel);
            if (this.statusFrame != null && this.statusFrame.getAssignmentPanel() != null) {
                this.roomModel.removeChallengeView(this.statusFrame.getAssignmentPanel());
                this.roomModel.removeAssignmentView(this.statusFrame.getAssignmentPanel());
            }
            try {
                this.roomModel.removeChallengeView(this.statusFrame.getChallengePanel());
                this.roomModel.removeChatView(this.chatPanel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.roomModel.hasRoundModel()) {
                this.getTimerPanel().unsetRoundModel();
                this.roomModel.getRoundModel().removePhaseListener(this);
            } else {
                throw new IllegalStateException("No round associated with: " + this.roomModel);
            }
        }
    }

    public void updateCompileError(ArrayList arrayList) {
        this.codingRoom.updateCompile((Boolean)arrayList.get(0), (String)arrayList.get(1));
    }

    public void setTestInfo(DataType[] dataTypeArray, int n) {
        this.codingRoom.testComponentID = n;
        ProblemComponentModel problemComponentModel = this.codingRoom.getComponentModel();
        if (problemComponentModel.getTestCases().length == 0) {
            Common.showArgInput(this.parentFrame, null, dataTypeArray, this.tempArgs, this.codingRoom, false, problemComponentModel, this.codingRoom.getLanguage());
        } else {
            Common.showArgInput(this.parentFrame, "Select an example from the drop-down list, or create your own custom arguments to test with.", dataTypeArray, this.tempArgs, this.codingRoom, false, problemComponentModel, this.codingRoom.getLanguage());
        }
    }

    private void updateCodingWindow(ProblemModel problemModel) {
        this.problemSelector.setProperty("Enabled", Boolean.FALSE);
        this.codingRoom.clear();
        this.codingRoom.updateComponentInfo(problemModel.getComponents()[0]);
        this.codingRoom.setCR(this);
        this.codingRoom.showFrame(true);
    }

    private void createNewCodingRoom() {
        if (this.codingRoom != null) {
            this.codingRoom.hide();
            this.codingRoom.dispose();
            this.codingRoom.setCR(null);
            this.codingRoom = null;
        }
        this.codingRoom = this.newCodingRoom();
        this.codingRoom.setRoomModel(this.roomModel);
        this.codingRoom.getFrame().addEventListener("Window", new UIWindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CoderRoom.this.closeCodingWindow();
            }
        });
        this.codingRoom.create();
        if (this.roomModel != null) {
            this.codingRoom.getTimerPanel().setRoundModel(this.roomModel.getRoundModel());
            this.setTimerPhase(this.roomModel.getRoundModel().getPhase(), null);
        }
    }

    protected CodingFrame newCodingRoom() {
        return new CodingFrame(this.parentFrame);
    }

    private void createNewStatusRoom() {
        if (this.statusFrame != null) {
            this.statusFrame.hide();
            this.statusFrame.dispose();
            this.statusFrame = null;
        }
        this.statusFrame = new ChallengeFrame(this.parentFrame, this.roomModel);
    }

    private void problemsListEvent() {
        Object object = this.getSelectedProblemComponent();
        if (object == null) {
            return;
        }
        String string = this.parentFrame.getModel().getCurrentUser();
        if (!this.roomModel.isAssigned(string)) {
            Common.showMessage("Not assigned", "You are not assigned to this room.", this.parentFrame.getCurrentFrame());
            return;
        }
        ProblemComponentModel problemComponentModel = (ProblemComponentModel)object;
        this.currentCoderComponent = this.roomModel.getCoder(string).getComponent(problemComponentModel.getID());
        this.currentCoderComponent.addListener(this.myCoderComponentListener);
        problemComponentModel.getProblem().addListener(this.myProblemModelListener);
        this.openingProblem = true;
        this.createNewCodingRoom();
        this.parentFrame.getRequester().requestOpenComponentForCoding(problemComponentModel.getID());
    }

    public void closeCodingWindow() {
        this.openingProblem = false;
        if (this.enabled) {
            this.problemSelector.setProperty("Enabled", Boolean.TRUE);
            this.problemSelectorReset();
        } else {
            this.problemListStatus = true;
        }
        if (!this.codingRoom.isSaved()) {
            this.codingRoom.setButtons(false, false, false, false, false, false, false, false);
        }
        if (this.currentCoderComponent != null) {
            this.currentCoderComponent.removeListener(this.myCoderComponentListener);
            this.currentCoderComponent.getComponent().getProblem().removeListener(this.myProblemModelListener);
            this.currentCoderComponent = null;
        }
        this.resetFocus();
    }

    public boolean isCodingWindowOpened() {
        return this.currentCoderComponent != null;
    }

    protected UIComponent buildProblemSelector(UIActionListener uIActionListener) {
        UIComponent uIComponent = this.page.getComponent("problem_list");
        uIComponent.setProperty("Renderer", this.getProblemListRenderer(uIComponent));
        uIComponent.addEventListener("action", uIActionListener);
        return uIComponent;
    }

    private ListCellRenderer getProblemListRenderer(UIComponent uIComponent) {
        final ListCellRenderer listCellRenderer = (ListCellRenderer)uIComponent.getProperty("Renderer");
        return new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof ProblemComponentModel) {
                    RoundModel roundModel = CoderRoom.this.roomModel.getRoundModel();
                    ComponentNameBuilder componentNameBuilder = roundModel.getRoundType().getComponentNameBuilder();
                    ProblemComponentModel problemComponentModel = (ProblemComponentModel)object;
                    object = componentNameBuilder.shortNameForComponent(problemComponentModel.getClassName(), problemComponentModel.getPoints(), roundModel.getRoundProperties());
                }
                return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        };
    }

    protected void problemSelectorReset() {
        UIComponent uIComponent = this.problemSelector;
        uIComponent.setProperty("SelectedItem", SELECTONE);
    }

    protected void clearProblemSelector() {
        UIComponent uIComponent = this.problemSelector;
        uIComponent.performAction("removeAllItems");
    }

    void createProblems(ProblemComponentModel[] problemComponentModelArray) {
        this.updateProblemSelector(problemComponentModelArray);
    }

    protected void updateProblemSelector(ProblemComponentModel[] problemComponentModelArray) {
        UIComponent uIComponent = this.problemSelector;
        uIComponent.performAction("removeAllItems");
        uIComponent.performAction("addItem", new Object[]{SELECTONE});
        for (int i = 0; i < problemComponentModelArray.length; ++i) {
            uIComponent.performAction("addItem", new Object[]{problemComponentModelArray[i]});
        }
    }

    protected Object getSelectedProblemComponent() {
        UIComponent uIComponent = this.problemSelector;
        int n = (Integer)uIComponent.getProperty("SelectedIndex");
        if (n < 0) {
            return null;
        }
        this.tempArgs = null;
        Object object = uIComponent.performAction("getItemAt", new Object[]{new Integer(n)});
        if (object.equals(SELECTONE)) {
            return null;
        }
        return object;
    }

    public void challengeButtonEvent(ActionEvent actionEvent) {
        RoundModel roundModel = this.roomModel.getRoundModel();
        if (roundModel.canDisplaySummary()) {
            this.statusFrame.showFrame(true);
        } else {
            this.parentFrame.popup(1, "Error", "Summary not available until the end of the round.");
        }
    }

    private TimerPanel getTimerPanel() {
        return this.panel.getTimerPanel();
    }

    public void updateSystestProgress(int n, int n2, RoundModel roundModel) {
        if (!ContestConstants.isPracticeRoomType(this.roomModel.getType())) {
            this.getTimerPanel().updateSystestProgress(n, n2);
            this.statusFrame.getTimerPanel().updateSystestProgress(n, n2);
            this.codingRoom.getTimerPanel().updateSystestProgress(n, n2);
        }
    }

    public void enableRound(RoundModel roundModel) {
    }

    protected UIComponent getProblemSelector() {
        return this.problemSelector;
    }
}

