/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.panels.table.RoundRenderer;
import com.topcoder.client.contestApplet.panels.table.TablePanel;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.netCommon.contestantMessages.response.CreateVisitedPracticeResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public final class VisitedPracticePanel
extends TablePanel {
    private static final String[] headers = new String[]{"Room Name"};
    private final MenuItemInfo[] OPEN_POPUP = new MenuItemInfo[]{new MenuItemInfo("Open", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            VisitedPracticePanel.this.openMessageEvent();
        }
    })};
    private boolean enabled = true;
    static /* synthetic */ Class class$com$topcoder$netCommon$contestantMessages$response$data$RoundData;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void update(CreateVisitedPracticeResponse createVisitedPracticeResponse) {
        int[] nArray = createVisitedPracticeResponse.getRoundIDs();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Integer(nArray[i]));
        }
        this.getTableModel().update(arrayList);
    }

    public VisitedPracticePanel(ContestApplet contestApplet) {
        super(contestApplet, "Rooms where you have opened at least one problem", new VisitedPracticeTableModel(contestApplet));
        this.setContestPopup("", this.OPEN_POPUP);
        this.contestTable.setRowMargin(3);
        this.contestTable.setRowSelectionAllowed(true);
        this.contestTable.setColumnSelectionAllowed(false);
        this.contestTable.setAutoResizeMode(3);
        this.contestTable.getTableHeader().setBackground(Common.BG_COLOR);
        this.contestTable.getColumnModel().getColumn(0).setMinWidth(200);
        this.contestTable.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.contestTable.getColumnModel().getColumn(0).setResizable(true);
        this.contestTable.getColumnModel().getColumn(0).setMaxWidth(500);
        this.contestTable.getColumnModel().getColumn(0).setCellRenderer(new RoundRenderer());
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (VisitedPracticePanel.this.enabled) {
                    VisitedPracticePanel.this.mouseClickEvent(mouseEvent);
                }
            }
        });
        this.contestTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (VisitedPracticePanel.this.enabled && keyEvent.getKeyCode() == 10) {
                    VisitedPracticePanel.this.openMessageEvent();
                }
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openMessageEvent();
        }
    }

    private synchronized void openMessageEvent() {
        int n = this.contestTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        RoundModel roundModel = (RoundModel)this.getTableModel().getValueAt(n, 0);
        this.ca.getRoomManager().loadRoom(roundModel.getCoderRooms()[0].getType(), roundModel.getCoderRooms()[0].getRoomID(), 2);
    }

    static class VisitedPracticeTableModel
    extends SortedTableModel {
        private Contestant model;

        public VisitedPracticeTableModel(ContestApplet contestApplet) {
            super(headers, new Class[]{class$com$topcoder$netCommon$contestantMessages$response$data$RoundData == null ? (class$com$topcoder$netCommon$contestantMessages$response$data$RoundData = VisitedPracticePanel.class$("com.topcoder.netCommon.contestantMessages.response.data.RoundData")) : class$com$topcoder$netCommon$contestantMessages$response$data$RoundData});
            this.model = contestApplet.getModel();
            this.addSortElement(new SortElement(0, true));
        }

        public Object getValueAt(int n, int n2) {
            Integer n3 = (Integer)this.get(n);
            return this.model.getRound(n3.intValue());
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            RoundModel roundModel = this.model.getRound(n.longValue());
            RoundModel roundModel2 = this.model.getRound(n2.longValue());
            Iterator iterator = this.getSortListIterator();
            if (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n3 = sortElement.isOpposite() ? -1 : 1;
                int n4 = roundModel.getContestName().compareTo(roundModel2.getContestName());
                return n3 * n4;
            }
            throw new IllegalStateException("Problem sorting broadcasts: " + this.getItemList());
        }
    }
}

