/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.panels.table.TablePanel;
import com.topcoder.client.contestApplet.widgets.ContestTableModel;
import com.topcoder.client.contestant.view.TeamListView;
import com.topcoder.netCommon.contestantMessages.response.data.TeamListInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;

public final class TeamListTablePanel
extends TablePanel
implements TeamListView {
    public TeamListTablePanel(ContestApplet contestApplet) {
        super(contestApplet, "Teams", new ContestTableModel(CommonData.teamInfoHeader, new Class[]{String.class, String.class, Integer.class, Integer.class, String.class}), true);
        TableColumnModel tableColumnModel = this.contestTable.getColumnModel();
        tableColumnModel.getColumn(0).setWidth(150);
        tableColumnModel.getColumn(0).setMinWidth(150);
        tableColumnModel.getColumn(1).setWidth(150);
        tableColumnModel.getColumn(1).setMinWidth(150);
        tableColumnModel.getColumn(2).setWidth(100);
        tableColumnModel.getColumn(2).setMinWidth(100);
        tableColumnModel.getColumn(2).setMaxWidth(100);
        tableColumnModel.getColumn(3).setWidth(100);
        tableColumnModel.getColumn(3).setMinWidth(100);
        tableColumnModel.getColumn(3).setMaxWidth(100);
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TeamListTablePanel.this.doubleClickEvent(mouseEvent);
            }
        });
    }

    private ArrayList getTableRow(TeamListInfo teamListInfo) {
        JLabel jLabel = new JLabel(teamListInfo.getCaptainName());
        jLabel.setForeground(Common.getRankColor(teamListInfo.getCaptainRank()));
        JLabel jLabel2 = new JLabel(teamListInfo.getTeamName());
        jLabel2.setIcon(Common.getRankIcon(teamListInfo.getTeamRank()));
        jLabel2.setForeground(Common.getRankColor(teamListInfo.getTeamRank()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(jLabel2);
        arrayList.add(jLabel);
        arrayList.add(new Integer(teamListInfo.getAvailable()));
        arrayList.add(new Integer(teamListInfo.getMembers()));
        arrayList.add(teamListInfo.getStatus());
        return arrayList;
    }

    public void updateTeamList(TeamListInfo teamListInfo) {
        ArrayList arrayList = this.getTableRow(teamListInfo);
        for (int i = 0; i < this.getTableModel().getRowCount(); ++i) {
            if (!((JLabel)((ArrayList)this.getTableModel().get(i)).get(0)).getText().equals(teamListInfo.getTeamName())) continue;
            ((ContestTableModel)this.getTableModel()).updateRow(i, arrayList);
            return;
        }
        this.getTableModel().add(arrayList);
    }

    public String getSelectedTeam() {
        if (this.contestTable.getSelectedRow() < 0) {
            return "";
        }
        return ((JLabel)((ArrayList)this.getTableModel().get(this.contestTable.getSelectedRow())).get(0)).getText();
    }

    private void doubleClickEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.infoPopupEvent();
        }
    }

    private void infoPopupEvent() {
        this.ca.setCurrentFrame(this.ca.getMainFrame());
    }

    public void updateTeam(TeamListInfo teamListInfo) {
    }
}

