/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.panels.table.TablePanel;
import com.topcoder.netCommon.contestantMessages.response.LongTestResultsResponse;
import com.topcoder.netCommon.contestantMessages.response.data.LongTestResultData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class LongTestResultsSummaryPanel
extends TablePanel {
    private static final String[] headers = new String[]{"Test Case", "Score", "Time", "Message"};
    private final MenuItemInfo[] OPEN_POPUP = new MenuItemInfo[]{new MenuItemInfo("Details", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongTestResultsSummaryPanel.this.openMessageEvent();
        }
    })};
    private DecimalFormat scoreFormat = new DecimalFormat("0.00");
    private boolean enabled = true;
    private LongTestResultsResponse response;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public LongTestResultsSummaryPanel(ContestApplet contestApplet, LongTestResultsResponse longTestResultsResponse) {
        super(contestApplet, "Results", new LongTestResultsSummaryTableModel());
        this.response = longTestResultsResponse;
        this.setContestPopup("", this.OPEN_POPUP);
        this.contestTable.setRowMargin(3);
        this.contestTable.setRowSelectionAllowed(true);
        this.contestTable.setColumnSelectionAllowed(false);
        this.contestTable.setAutoResizeMode(3);
        this.contestTable.getTableHeader().setBackground(Common.BG_COLOR);
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (LongTestResultsSummaryPanel.this.enabled) {
                    LongTestResultsSummaryPanel.this.mouseClickEvent(mouseEvent);
                }
            }
        });
        this.contestTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LongTestResultsSummaryPanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.contestTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (LongTestResultsSummaryPanel.this.enabled && keyEvent.getKeyCode() == 10) {
                    LongTestResultsSummaryPanel.this.openMessageEvent();
                }
            }
        });
        this.getTableModel().update(Arrays.asList(longTestResultsResponse.getResultData()));
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showContestPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openMessageEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.getTable().getTableHeader().repaint();
        }
    }

    private synchronized void openMessageEvent() {
        int n = this.contestTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        LongTestResultData longTestResultData = (LongTestResultData)this.tableModel.get(n);
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<html>");
        stringBuffer.append(longTestResultData.getTestCaseIndex()).append(") Score: ").append(this.scoreFormat.format(longTestResultData.getScore())).append(" Run Time: ").append(longTestResultData.getExecTime()).append(" ms.<br><br>");
        stringBuffer.append("Example Case:<br>").append(this.response.getArgs()[longTestResultData.getTestCaseIndex()]).append("<br><br>");
        stringBuffer.append("Fatal Errors:<br>").append(Common.htmlEncodeNoHeaders(longTestResultData.getMessage())).append("<br><br>");
        stringBuffer.append("Standard Out:<br>").append(Common.htmlEncodeNoHeaders(longTestResultData.getStdOut())).append("<br><br>");
        stringBuffer.append("Standard Error:<br>").append(Common.htmlEncodeNoHeaders(longTestResultData.getStdErr())).append("<br><br>");
        stringBuffer.append("---------------------------------------------------------------------------<br>");
        stringBuffer.append("</html>");
        this.ca.popup(0, "Test Result Info", stringBuffer.toString());
    }

    static class LongTestResultsSummaryTableModel
    extends SortedTableModel {
        public LongTestResultsSummaryTableModel() {
            super(headers, new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = LongTestResultsSummaryPanel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = LongTestResultsSummaryPanel.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$String == null ? (class$java$lang$String = LongTestResultsSummaryPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = LongTestResultsSummaryPanel.class$("java.lang.String")) : class$java$lang$String});
            this.addSortElement(new SortElement(0, true));
            this.addSortElement(new SortElement(1, true));
        }

        public Object getValueAt(int n, int n2) {
            LongTestResultData longTestResultData = (LongTestResultData)this.get(n);
            switch (n2) {
                case 0: {
                    return new Integer(longTestResultData.getTestCaseIndex());
                }
                case 1: {
                    return new Double(longTestResultData.getScore());
                }
                case 2: {
                    long l = longTestResultData.getExecTime();
                    if (l < 1000L) {
                        return "" + l + " ms";
                    }
                    return "" + (double)l / 1000.0 + "s";
                }
                case 3: {
                    if (longTestResultData.getMessage() != null) {
                        return longTestResultData.getMessage();
                    }
                    return "";
                }
            }
            throw new IllegalArgumentException("Bad column: " + n2);
        }

        public int compare(Object object, Object object2) {
            LongTestResultData longTestResultData = (LongTestResultData)object;
            LongTestResultData longTestResultData2 = (LongTestResultData)object2;
            Iterator iterator = this.getSortListIterator();
            block6: while (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n = sortElement.getColumn();
                int n2 = sortElement.isOpposite() ? -1 : 1;
                switch (n) {
                    case 0: {
                        int n3 = longTestResultData2.getTestCaseIndex() - longTestResultData.getTestCaseIndex();
                        if (n3 == 0) continue block6;
                        return n2 * (n3 > 0 ? 1 : -1);
                    }
                    case 1: {
                        int n4;
                        double d = longTestResultData.getScore();
                        double d2 = longTestResultData2.getScore();
                        int n5 = d > d2 ? 1 : (n4 = d == d2 ? 0 : -1);
                        if (n4 != 0) {
                            return n2 * n4;
                        }
                    }
                    case 2: {
                        long l = longTestResultData.getExecTime();
                        long l2 = longTestResultData2.getExecTime();
                        long l3 = l2 - l;
                        if (l3 == 0L) continue block6;
                        return n2 * (l3 > 0L ? 1 : -1);
                    }
                    case 3: {
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Bad column: " + sortElement);
            }
            return 0;
        }
    }
}

