/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.common.PopUpHelper;
import com.topcoder.client.contestApplet.panels.table.AbstractSummaryTablePanel;
import com.topcoder.client.contestApplet.panels.table.RankRenderer;
import com.topcoder.client.contestApplet.panels.table.UserNameEntry;
import com.topcoder.client.contestApplet.panels.table.UserNameRenderer;
import com.topcoder.client.contestApplet.widgets.CellRendererFactory;
import com.topcoder.client.contestApplet.widgets.ContestTableCellRenderer;
import com.topcoder.client.contestApplet.widgets.ContestTableHeaderRenderer;
import com.topcoder.client.contestApplet.widgets.LanguageColoringDecoratorRenderer;
import com.topcoder.client.contestApplet.widgets.LongCodeViewer;
import com.topcoder.client.contestApplet.widgets.ValueTransformDecoratorCellRenderer;
import com.topcoder.client.contestant.Coder;
import com.topcoder.client.contestant.CoderComponent;
import com.topcoder.client.contestant.Contestant;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.impl.LongCoderComponentImpl;
import com.topcoder.netCommon.contest.ResultDisplayType;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class LongSummaryTablePanel
extends AbstractSummaryTablePanel {
    private static final int EXAMPLE_COUNT_COLUMN = 8;
    private static final int SUBMISSION_COUNT_COLUMN = 6;
    private static final boolean headersVisible = true;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private final ContestApplet ca;
    private final Contestant model;
    private final RoomModel room;
    private ChallengeTableModel tableModel;
    private JTable table;
    private JPopupMenu submissionPopup;
    private JPopupMenu otherContestPopup;
    private JPopupMenu endedContestPopup;
    private Class[] tableModelClasses;
    private String[] tableModelHeaders;
    private boolean enabled = true;
    private JFrame frame = null;
    private boolean update;
    private LongCodeViewer viewer;
    private final MenuItemInfo[] ON_USER_POPUP = new MenuItemInfo[]{new MenuItemInfo("Info", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.infoPopupEvent();
        }
    }), new MenuItemInfo("History", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.historyPopupEvent(1);
        }
    }), new MenuItemInfo("Submission History", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.historyPopupEvent(2);
        }
    }), new MenuItemInfo("Example History", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.historyPopupEvent(3);
        }
    })};
    private final MenuItemInfo[] ON_END_CONTEST_POPUP = new MenuItemInfo[]{new MenuItemInfo("Info", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.infoPopupEvent();
        }
    }), new MenuItemInfo("History", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.historyPopupEvent(1);
        }
    }), new MenuItemInfo("Submission History", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.historyPopupEvent(2);
        }
    }), new MenuItemInfo("Example History", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.historyPopupEvent(3);
        }
    }), new MenuItemInfo("System test results", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.systemTestResultsEvent();
        }
    })};
    private final MenuItemInfo[] ON_SUBMISSION_POPUP = new MenuItemInfo[]{new MenuItemInfo("Source", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LongSummaryTablePanel.this.sourcePopupEvent();
        }
    })};
    private boolean endedContestLayout;

    public LongSummaryTablePanel(ContestApplet contestApplet, RoomModel roomModel, JFrame jFrame, boolean bl) {
        super(new GridBagLayout());
        UIManager.put("MenuItem.selectionBackground", Common.HB_COLOR);
        this.ca = contestApplet;
        this.model = contestApplet.getModel();
        this.room = roomModel;
        this.update = bl;
        this.submissionPopup = PopUpHelper.createPopupMenu("Info", this.ON_SUBMISSION_POPUP);
        this.otherContestPopup = PopUpHelper.createPopupMenu("", this.ON_USER_POPUP);
        this.endedContestPopup = PopUpHelper.createPopupMenu("", this.ON_END_CONTEST_POPUP);
        this.frame = jFrame;
        this.initTable();
    }

    private void initTable() {
        this.prepareForTableModel();
        this.tableModel = new ChallengeTableModel();
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                LongSummaryTablePanel.this.updateRoomLeader();
            }
        });
        this.table = this.createTable();
        this.createTablePanel();
    }

    private void reinitTable() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LongSummaryTablePanel.this.remove(0);
                    LongSummaryTablePanel.this.initTable();
                    LongSummaryTablePanel.this.getRootPane().validate();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    private JTable createTable() {
        JTable jTable = new JTable(this.tableModel);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setBackground(Common.TB_COLOR);
        jTable.setForeground(Common.TF_COLOR);
        jTable.setSelectionBackground(Common.HB_COLOR);
        jTable.setSelectionForeground(Common.HF_COLOR);
        jTable.setShowGrid(false);
        jTable.setSelectionMode(0);
        jTable.getColumnModel().setColumnMargin(0);
        LongSummaryTablePanel.setHeaders(jTable);
        String string = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        ContestTableCellRenderer contestTableCellRenderer = new ContestTableCellRenderer(string, n);
        jTable.setDefaultRenderer(String.class, contestTableCellRenderer);
        int n2 = jTable.getColumnModel().getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            ContestTableHeaderRenderer contestTableHeaderRenderer = new ContestTableHeaderRenderer(true, string, n);
            tableColumn.setHeaderRenderer(contestTableHeaderRenderer);
            int n3 = this.fixedColIndex(i);
            if (n3 == 0) {
                tableColumn.setPreferredWidth(25);
                tableColumn.setCellRenderer(new ContestTableCellRenderer(string, n));
                continue;
            }
            if (n3 == 1) {
                tableColumn.setPreferredWidth(23);
                tableColumn.setCellRenderer(new RankRenderer());
                continue;
            }
            if (n3 == 2) {
                tableColumn.setPreferredWidth(115);
                tableColumn.setCellRenderer(new UserNameRenderer(this.model, string, n));
                continue;
            }
            if (n3 == 3) {
                tableColumn.setPreferredWidth(140);
                tableCellRenderer = new ComponentStatusRenderer(new ContestTableCellRenderer(string, n));
                tableColumn.setCellRenderer(new LanguageColoringDecoratorRenderer(tableCellRenderer){

                    protected Integer getLanguage(Object object, int n, int n2) {
                        Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                        return coder.getComponents()[0].getLanguageID();
                    }
                });
                continue;
            }
            if (n3 == 4) {
                tableColumn.setPreferredWidth(100);
                contestTableHeaderRenderer.setHorizontalAlignment(0);
                tableCellRenderer = CellRendererFactory.create(string, n, new DecimalFormat("0.00"), 4);
                tableColumn.setCellRenderer(new LanguageColoringDecoratorRenderer(tableCellRenderer){

                    protected Integer getLanguage(Object object, int n, int n2) {
                        Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                        return coder.getComponents()[0].getLanguageID();
                    }
                });
                continue;
            }
            if (n3 == 5) {
                contestTableHeaderRenderer.setHorizontalAlignment(0);
                tableColumn.setPreferredWidth(100);
                tableCellRenderer = CellRendererFactory.create(string, n, new DecimalFormat("0.00"), 4);
                tableColumn.setCellRenderer(new LanguageColoringDecoratorRenderer(tableCellRenderer){

                    protected Integer getLanguage(Object object, int n, int n2) {
                        Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                        return coder.getComponents()[0].getLanguageID();
                    }
                });
                continue;
            }
            if (n3 == 6) {
                contestTableHeaderRenderer.setHorizontalAlignment(0);
                tableColumn.setPreferredWidth(80);
                tableCellRenderer = CellRendererFactory.create(string, n, 4);
                tableColumn.setCellRenderer(new LanguageColoringDecoratorRenderer(tableCellRenderer){

                    protected Integer getLanguage(Object object, int n, int n2) {
                        Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                        return coder.getComponents()[0].getLanguageID();
                    }
                });
                continue;
            }
            if (n3 == 7) {
                contestTableHeaderRenderer.setHorizontalAlignment(0);
                tableColumn.setPreferredWidth(140);
                tableCellRenderer = CellRendererFactory.create(string, n, this.dateFormat, 0);
                tableColumn.setCellRenderer(new LanguageColoringDecoratorRenderer(tableCellRenderer){

                    protected Integer getLanguage(Object object, int n, int n2) {
                        Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                        return coder.getComponents()[0].getLanguageID();
                    }
                });
                continue;
            }
            if (n3 == 8) {
                contestTableHeaderRenderer.setHorizontalAlignment(0);
                tableColumn.setPreferredWidth(80);
                tableCellRenderer = CellRendererFactory.create(string, n, 4);
                tableColumn.setCellRenderer(new LanguageColoringDecoratorRenderer(tableCellRenderer){

                    protected Integer getLanguage(Object object, int n, int n2) {
                        Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                        return new Integer(((LongCoderComponentImpl)coder.getComponents()[0]).getExampleLastLanguage());
                    }
                });
                continue;
            }
            if (n3 != 9) continue;
            contestTableHeaderRenderer.setHorizontalAlignment(0);
            tableColumn.setPreferredWidth(140);
            tableCellRenderer = CellRendererFactory.create(string, n, this.dateFormat, 0);
            tableColumn.setCellRenderer(new LanguageColoringDecoratorRenderer(tableCellRenderer){

                protected Integer getLanguage(Object object, int n, int n2) {
                    Coder coder = LongSummaryTablePanel.this.tableModel.getCoder(n);
                    return new Integer(((LongCoderComponentImpl)coder.getComponents()[0]).getExampleLastLanguage());
                }
            });
        }
        return jTable;
    }

    private int fixedColIndex(int n) {
        if (n >= 4 && !this.isEndedContestLayout()) {
            return n + 1;
        }
        return n;
    }

    protected boolean isEndedContestLayout() {
        return this.endedContestLayout;
    }

    protected boolean isContestEnded() {
        return this.room.getRoundModel().getPhase() == 9;
    }

    private static void setHeaders(JTable jTable) {
        String string = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderRenderer(new ContestTableHeaderRenderer(true, string, n));
            jTable.getColumnModel().getColumn(i).setCellRenderer(new ContestTableCellRenderer(string, n));
        }
    }

    private void createTablePanel() {
        String string = "Details Table";
        int n = 0;
        int n2 = 0;
        JScrollPane jScrollPane = new JScrollPane(this.table);
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        gridBagConstraints.insets = new Insets(-1, -1, -1, -1);
        this.setBorder(Common.getTitledBorder(string));
        this.setPreferredSize(new Dimension(n, n2));
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.getViewport().setBackground(Common.TB_COLOR);
        this.table.setPreferredScrollableViewportSize(jScrollPane.getSize());
        this.setBackground(Common.WPB_COLOR);
        this.setOpaque(true);
        Common.insertInPanel(jScrollPane, this, gridBagConstraints, 0, 0, 1, 1);
        String string2 = LocalPreferences.getInstance().getFont("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont");
        int n3 = LocalPreferences.getInstance().getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize");
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setBackground(Common.BG_COLOR);
        this.table.getTableHeader().setResizingAllowed(true);
        this.table.getTableHeader().setDefaultRenderer(new ContestTableHeaderRenderer(true, string2, n3));
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (LongSummaryTablePanel.this.enabled) {
                    LongSummaryTablePanel.this.mouseClickEvent(mouseEvent);
                    LongSummaryTablePanel.this.otherMouseClickEvent(mouseEvent);
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LongSummaryTablePanel.this.headerClickEvent(mouseEvent);
            }
        });
    }

    private void showSubmissionPopup(MouseEvent mouseEvent) {
        this.submissionPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public JComponent getTable() {
        return this.table;
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        Coder coder;
        CoderComponent coderComponent;
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        int n3 = this.fixedColIndex(n2);
        if ((n3 == 6 || n3 == 8) && (coderComponent = (coder = this.tableModel.getCoder(n)).getComponents()[0]) != null && coderComponent.getStatus() >= 120) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showSubmissionPopup(mouseEvent);
            } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.sourcePopupEvent();
            }
        }
    }

    private void otherMouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        int n2 = ((JTable)mouseEvent.getComponent()).columnAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        ((JTable)mouseEvent.getComponent()).setColumnSelectionInterval(n2, n2);
        int n3 = this.fixedColIndex(n2);
        if (n3 != 6 && n3 != 8) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (this.isEndedContestLayout()) {
                    this.endedContestPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.otherContestPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.infoPopupEvent();
            }
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.table.getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.tableModel.sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.table.getTableHeader().repaint();
        }
    }

    private void infoPopupEvent() {
        int n = this.table.getSelectedRow();
        String string = ((UserNameEntry)this.table.getValueAt(n, 2)).getName();
        this.ca.setCurrentFrame(this.frame);
        this.ca.requestCoderInfo(string, ((UserNameEntry)this.table.getValueAt(n, 2)).getUserType());
    }

    private void sourcePopupEvent() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        int n3 = this.fixedColIndex(n2);
        if (n3 == 6 || n3 == 8) {
            Coder coder = this.tableModel.getCoder(n);
            int n4 = (Integer)this.tableModel.getValueAt(n, n2);
            if (n4 == 0) {
                return;
            }
            if (this.viewer != null) {
                this.closeSourceViewer();
            }
            this.viewer = new LongCodeViewer(this.ca, this.frame, this.room.getRoundModel().getRoundID().intValue(), coder.getHandle(), coder.getComponents()[0].getComponent().getID().intValue(), n3 == 8, n4, true);
            this.viewer.show();
        }
    }

    private void updateRoomLeader() {
        this.tableModel.updateRoomLeader();
        this.repaint();
    }

    public void updateView(ResultDisplayType resultDisplayType) {
    }

    private void historyPopupEvent(int n) {
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0) {
            String string = this.tableModel.getCoder(n2).getHandle();
            this.ca.setCurrentFrame(this.frame);
            if (n == 1) {
                this.ca.requestCoderHistory(string, this.room.getRoomID(), this.tableModel.getCoder(n2).getUserType());
            } else if (n == 2) {
                this.ca.requestSubmissionHistory(string, this.room.getRoomID(), this.tableModel.getCoder(n2).getUserType(), false);
            } else {
                this.ca.requestSubmissionHistory(string, this.room.getRoomID(), this.tableModel.getCoder(n2).getUserType(), true);
            }
        }
    }

    private void systemTestResultsEvent() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            Coder coder = this.tableModel.getCoder(n);
            String string = coder.getHandle();
            this.ca.setCurrentFrame(this.frame);
            this.ca.getInterFrame().showMessage("Fetching results...", this, 120);
            this.ca.getRequester().requestLongTestResults(coder.getComponents()[0].getComponent().getID(), this.room.getRoomID(), string, 2);
        }
    }

    private void prepareForTableModel() {
        if (!this.room.hasRoundModel()) {
            throw new IllegalStateException("Can't build challenge table model, no round for room: " + this.room);
        }
        RoundModel roundModel = this.room.getRoundModel();
        if (!roundModel.hasProblems(this.room.getDivisionID())) {
            throw new IllegalStateException("Can't build challenge table model, no problems for round: " + roundModel);
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(Integer.class);
        arrayList2.add("Place");
        arrayList.add(Integer.class);
        arrayList2.add("R");
        arrayList.add(UserNameEntry.class);
        arrayList2.add("Handle");
        arrayList.add(String.class);
        arrayList2.add("Status");
        arrayList.add(Double.class);
        this.endedContestLayout = false;
        if (this.isContestEnded()) {
            this.endedContestLayout = true;
            arrayList2.add("Final Score");
            arrayList.add(Double.class);
        }
        arrayList2.add("Score");
        arrayList.add(Integer.class);
        arrayList2.add("Submissions");
        arrayList.add(String.class);
        arrayList2.add("Last submission");
        arrayList.add(Integer.class);
        arrayList2.add("Examples");
        arrayList.add(String.class);
        arrayList2.add("Last example");
        this.tableModelClasses = arrayList.toArray(new Class[0]);
        this.tableModelHeaders = arrayList2.toArray(new String[0]);
    }

    public void updateChallengeTable(RoomModel roomModel) {
        if (this.room != roomModel) {
            throw new IllegalStateException("Got event for unrecognized room: " + roomModel);
        }
        if (this.isEndedContestLayout() ^ this.isContestEnded()) {
            this.reinitTable();
        }
        this.tableModel.updateChallengeTable();
    }

    public void closeSourceViewer() {
        if (this.viewer != null) {
            this.viewer.close();
            this.viewer = null;
        }
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    private final class RankComparator
    implements Comparator {
        private RankComparator() {
        }

        public int compare(Object object, Object object2) {
            Double d = (Double)object;
            Double d2 = (Double)object2;
            double d3 = d - d2;
            if (d3 != 0.0) {
                return -1 * (d3 > 0.0 ? 1 : -1);
            }
            return 0;
        }

        protected int compareStrings(String string, String string2) {
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private final class ChallengeTableModel
    extends SortedTableModel
    implements Coder.Listener {
        private List coderList;
        private RankComparator rankCompare;

        private ChallengeTableModel() {
            super(LongSummaryTablePanel.this.tableModelHeaders, LongSummaryTablePanel.this.tableModelClasses);
            this.coderList = new ArrayList();
            this.rankCompare = new RankComparator();
            for (int i = 0; i < 10; ++i) {
                this.addSortElement(new SortElement(i, false));
            }
            this.updateChallengeTable();
        }

        private void updateChallengeTable() {
            if (!LongSummaryTablePanel.this.update) {
                return;
            }
            if (!LongSummaryTablePanel.this.room.hasCoders()) {
                throw new IllegalStateException("No coders for room: " + LongSummaryTablePanel.this.room);
            }
            Coder[] coderArray = LongSummaryTablePanel.this.room.getCoders();
            for (int i = 0; i < coderArray.length; ++i) {
                coderArray[i].addListener(this);
            }
            this.update(Arrays.asList(coderArray));
            this.updateRoomLeader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateRoomLeader() {
            if (!LongSummaryTablePanel.this.update) {
                return;
            }
            List list = this.coderList;
            synchronized (list) {
                List list2 = (List)this.getItemList();
                this.coderList.clear();
                for (int i = 0; i < list2.size(); ++i) {
                    Coder coder = (Coder)list2.get(i);
                    this.coderList.add(this.getRelevantScoreForStatus(coder));
                }
                Collections.sort(this.coderList, this.rankCompare);
                this.sort();
            }
        }

        public int getCoderRank(Coder coder) {
            if (this.coderList == null) {
                return 1;
            }
            for (int i = 0; i < this.coderList.size(); ++i) {
                Double d = this.getRelevantScoreForStatus(coder);
                Double d2 = (Double)this.coderList.get(i);
                if (d.doubleValue() != d2.doubleValue()) continue;
                return i + 1;
            }
            return -1;
        }

        public void coderEvent(Coder coder) {
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            Coder coder = this.getCoder(n);
            return this.getColValue(coder, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getColValue(Coder coder, int n) {
            int n2 = LongSummaryTablePanel.this.fixedColIndex(n);
            switch (n2) {
                case 0: {
                    List list = this.coderList;
                    synchronized (list) {
                        return new Integer(this.getCoderRank(coder));
                    }
                }
                case 1: {
                    return coder.getRating();
                }
                case 2: {
                    return new UserNameEntry(coder.getHandle(), coder.getRating(), LongSummaryTablePanel.this.room.hasLeader() && LongSummaryTablePanel.this.room.getLeader().getUserName().equals(coder.getHandle()), coder.getUserType());
                }
                case 3: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return longCoderComponentImpl.getStatus();
                }
                case 4: {
                    return coder.getFinalScore() == null ? null : new Double(coder.getFinalScore() / 100.0);
                }
                case 5: {
                    return new Double(coder.getScore() / 100.0);
                }
                case 6: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return new Integer(longCoderComponentImpl.getSubmissionCount());
                }
                case 7: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return longCoderComponentImpl.getLastSubmissionTime() == 0L ? null : new Date(longCoderComponentImpl.getLastSubmissionTime());
                }
                case 8: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return new Integer(longCoderComponentImpl.getExampleSubmissionCount());
                }
                case 9: {
                    LongCoderComponentImpl longCoderComponentImpl = (LongCoderComponentImpl)coder.getComponents()[0];
                    return longCoderComponentImpl.getExampleLastSubmissionTime() == 0L ? null : new Date(longCoderComponentImpl.getExampleLastSubmissionTime());
                }
            }
            return null;
        }

        private Double getRelevantScoreForStatus(Coder coder) {
            if (LongSummaryTablePanel.this.isEndedContestLayout()) {
                return coder.getFinalScore();
            }
            return coder.getScore();
        }

        Coder getCoder(int n) {
            return (Coder)this.get(n);
        }

        public int compare(Object object, Object object2) {
            Coder coder = (Coder)object;
            Coder coder2 = (Coder)object2;
            Iterator iterator = this.getSortListIterator();
            while (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n = sortElement.getColumn();
                int n2 = sortElement.isOpposite() ? -1 : 1;
                Comparable comparable = (Comparable)this.getColValue(coder, n);
                Comparable comparable2 = (Comparable)this.getColValue(coder2, n);
                int n3 = 0;
                if (comparable != null) {
                    n3 = comparable2 != null ? comparable.compareTo(comparable2) : 1;
                } else if (comparable2 != null) {
                    n3 = -1;
                }
                if (n3 == 0) continue;
                return n2 * n3;
            }
            return 0;
        }
    }

    private static class ComponentStatusRenderer
    extends ValueTransformDecoratorCellRenderer {
        public ComponentStatusRenderer(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer);
        }

        protected Object transform(Object object, int n, int n2) {
            int n3 = (Integer)object;
            switch (n3) {
                case 110: {
                    return "Unopened";
                }
                case 120: {
                    return "Opened";
                }
                case 121: {
                    return "Compiled";
                }
                case 130: {
                    return "Pending tests";
                }
                case 150: {
                    return "Test completed";
                }
            }
            throw new IllegalStateException("Invalid component state: " + n3);
        }
    }
}

