/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels.table;

import com.topcoder.client.SortElement;
import com.topcoder.client.SortedTableModel;
import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.MenuItemInfo;
import com.topcoder.client.contestApplet.frames.ImportantMessageDialog;
import com.topcoder.client.contestApplet.panels.table.BroadcastMessageRenderer;
import com.topcoder.client.contestApplet.panels.table.DateRenderer;
import com.topcoder.client.contestApplet.panels.table.TablePanel;
import com.topcoder.netCommon.contestantMessages.response.GetImportantMessagesResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public final class ImportantMessageSummaryPanel
extends TablePanel {
    private static final String[] headers = new String[]{"Read", "Message"};
    private final MenuItemInfo[] OPEN_POPUP = new MenuItemInfo[]{new MenuItemInfo("Open", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ImportantMessageSummaryPanel.this.openMessageEvent();
        }
    })};
    private boolean enabled = true;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    public void setPanelEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void update(GetImportantMessagesResponse getImportantMessagesResponse) {
        this.getTableModel().update(getImportantMessagesResponse.getItems());
    }

    public ImportantMessageSummaryPanel(ContestApplet contestApplet) {
        super(contestApplet, "Important Messages", new ImportantMessageSummaryTableModel());
        this.setContestPopup("", this.OPEN_POPUP);
        this.contestTable.setRowMargin(3);
        this.contestTable.setRowSelectionAllowed(true);
        this.contestTable.setColumnSelectionAllowed(false);
        this.contestTable.setAutoResizeMode(3);
        this.contestTable.getTableHeader().setBackground(Common.BG_COLOR);
        this.contestTable.getColumnModel().getColumn(0).setMinWidth(159);
        this.contestTable.getColumnModel().getColumn(0).setPreferredWidth(159);
        this.contestTable.getColumnModel().getColumn(0).setResizable(false);
        this.contestTable.getColumnModel().getColumn(0).setMaxWidth(159);
        this.contestTable.getColumnModel().getColumn(0).setCellRenderer(new DateRenderer());
        this.contestTable.getColumnModel().getColumn(1).setMinWidth(300);
        this.contestTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.contestTable.getColumnModel().getColumn(1).setCellRenderer(new BroadcastMessageRenderer());
        this.contestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ImportantMessageSummaryPanel.this.enabled) {
                    ImportantMessageSummaryPanel.this.mouseClickEvent(mouseEvent);
                }
            }
        });
        this.contestTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ImportantMessageSummaryPanel.this.headerClickEvent(mouseEvent);
            }
        });
        this.contestTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ImportantMessageSummaryPanel.this.enabled && keyEvent.getKeyCode() == 10) {
                    ImportantMessageSummaryPanel.this.openMessageEvent();
                }
            }
        });
    }

    private void mouseClickEvent(MouseEvent mouseEvent) {
        int n = ((JTable)mouseEvent.getComponent()).rowAtPoint(mouseEvent.getPoint());
        ((JTable)mouseEvent.getComponent()).setRowSelectionInterval(n, n);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showContestPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.openMessageEvent();
        }
    }

    private void headerClickEvent(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.getTable().getTableHeader().columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.getTableModel().sort(n, (mouseEvent.getModifiers() & 1) > 0);
            this.getTable().getTableHeader().repaint();
        }
    }

    private synchronized void openMessageEvent() {
        int n = this.contestTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        GetImportantMessagesResponse.ImportantMessage importantMessage = (GetImportantMessagesResponse.ImportantMessage)this.tableModel.get(n);
        ImportantMessageDialog importantMessageDialog = new ImportantMessageDialog(this.ca, importantMessage.getMessage());
        importantMessageDialog.show();
    }

    static class ImportantMessageSummaryTableModel
    extends SortedTableModel {
        public ImportantMessageSummaryTableModel() {
            super(headers, new Class[]{class$java$lang$Long == null ? (class$java$lang$Long = ImportantMessageSummaryPanel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$String == null ? (class$java$lang$String = ImportantMessageSummaryPanel.class$("java.lang.String")) : class$java$lang$String});
            this.addSortElement(new SortElement(0, true));
        }

        public Object getValueAt(int n, int n2) {
            GetImportantMessagesResponse.ImportantMessage importantMessage = (GetImportantMessagesResponse.ImportantMessage)this.get(n);
            switch (n2) {
                case 0: {
                    return new Long(importantMessage.getTime());
                }
                case 1: {
                    return Common.htmlEncode(importantMessage.getMessage());
                }
            }
            throw new IllegalArgumentException("Bad column: " + n2);
        }

        public int compare(Object object, Object object2) {
            GetImportantMessagesResponse.ImportantMessage importantMessage = (GetImportantMessagesResponse.ImportantMessage)object;
            GetImportantMessagesResponse.ImportantMessage importantMessage2 = (GetImportantMessagesResponse.ImportantMessage)object2;
            Iterator iterator = this.getSortListIterator();
            if (iterator.hasNext()) {
                SortElement sortElement = (SortElement)iterator.next();
                int n = sortElement.getColumn();
                int n2 = sortElement.isOpposite() ? -1 : 1;
                switch (n) {
                    case 0: {
                        long l = importantMessage.getTime() - importantMessage2.getTime();
                        return n2 * (l > 0L ? 1 : -1);
                    }
                    case 1: {
                        int n3 = importantMessage.getMessage().compareTo(importantMessage2.getMessage());
                        return n2 * n3;
                    }
                }
                throw new IllegalArgumentException("Bad column: " + sortElement);
            }
            throw new IllegalStateException("Problem sorting broadcasts: " + this.getItemList());
        }
    }
}

